# EduBench: 用于评估大语言模型在多样化教育场景中表现的综合基准数据集

<p align="center">
  📄 <a href="https://arxiv.org/pdf/2505.16160 " target="_blank">Paper</a> &nbsp; | &nbsp;
  🤗 <a href="https://huggingface.co/DirectionAI/EDU-Qwen2.5-7B" target="_blank">Model</a> &nbsp; |
  🎰 <a href="https://huggingface.co/datasets/DirectionAI/EduBench" target="_blank">Datasets</a> &nbsp; | &nbsp;
  ⚖️ <a href="" target="_blank">MIT License</a>
</p>

# 目录
- [概述](#概述)
- [框架](#框架)
- [数据集构建](#数据集构建)
  - [评估指标设计](#评估指标设计)
  - [数据集生成](#数据集生成)
  - [数据评估](#数据集生成)
- [实验与分析](#实验与分析)
  - [评估结果](#评估结果)
  - [模型与人类评估一致性分析](#模型与人类评估一致性分析)
  - [模型蒸馏](#模型蒸馏)
 

# 概述
<div align="center">
  <img src="images/distribution-radar.jpg" alt="Distribution Radar" width="1200"/>
  <br>
  <strong>左侧部分展示了我们的9个教育场景，沿纵向展示了它们的多维教育背景和相应的指标。右侧部分展示了EduBench上的人工评估结果。</strong>
</div>

<br>

首次推出 EduBench 📚，一个专为教育场景量身定制的 多样化基准数据集 🌟，涵盖 9大教育场景 🏫 和超过 4000个不同教育情景 🔍，为教育领域的模型评估提供全新视角。

我们设计了 多维度评估指标 🛠️，全面覆盖 教师端和学生端 的 12个关键维度 🧠，确保对场景适应性、事实与推理准确性等方面进行深入评估。

不仅如此，借助 知识蒸馏技术 🔬，我们让小模型如 Qwen2.5-7B-Instruct 在仅有少量数据的情况下，依然能够实现与最先进的大型模型 DeepSeek V3 和 Qwen Max 相媲美的性能。EduBench 不仅是一个基准，更是教育模型发展的 游戏改变者 🚀！





---
# 框架
<div align="center">
  <img src="images/framework.jpg" alt="Framework" width="1200"/>
  <br>
  <strong>左侧部分展示了我们的数据整理流程；中间部分展示了我们的三个主要评估原则，以及我们对大语言模型与人类评判一致性问题的探究；右侧部分展示了我们的数据如何提升小型模型的性能。</strong>
</div>

---
# 数据集构建

我们首先根据服务对象的不同，将教育场景分为以下两类：

**一、以学生为中心的场景（Student-Oriented Scenarios）**

- 问题解答（Q&A）
- 错误纠正（EC）
- 思路提供（IP）
- 个性化学习支持（PLS）
- 情感支持（ES）

**二、以教师为中心的场景（Teacher-Oriented Scenarios）**

- 问题生成（QG）
- 自动评分（AG）
- 教学资料生成（TMG）
- 个性化内容创作（PCC）

## 评估指标设计

根据定义的教育场景，我们设计了全面的评估指标体系，每个场景下包含 4 个子指标，共计 12 个核心评估指标。

### 1. 场景适配性（Scenario Adaptation）

用于评估模型回答是否在语境上恰当，并符合教育场景的预期要求。

- **指令遵循与任务完成**（Instruction Following & Task Completion）
- **角色与语气一致性**（Role & Tone Consistency）
- **内容相关性与范围控制**（Content Relevance & Scope Control）
- **场景元素整合能力**（Scenario Element Integration）

### 2. 事实性与推理准确性（Factual & Reasoning Accuracy）

用于评估模型回答中信息的正确性以及推理过程的严谨性。

- **基础事实准确性**（Basic Factual Accuracy）
- **领域知识准确性**（Domain Knowledge Accuracy）
- **推理过程严谨性**（Reasoning Process Rigor）
- **错误识别与纠正精度**（Error Identification & Correction Precision）

### 3. 教学应用性（Pedagogical Application）

用于评估模型回答是否体现良好的教学原则，并能有效支持学生学习。

- **清晰、简洁与启发性**（Clarity, Simplicity & Inspiration）
- **激励、引导与积极反馈**（Motivation, Guidance & Positive Feedback）
- **个性化、适应性与学习支持**（Personalization, Adaptation & Learning Support）
- **高阶思维与技能发展**（Higher-Order Thinking & Skill Development）



## 数据集生成

我们以错误纠正（EC）为例，运行以下代码进行数据生成
```
python ./code/generation/EC.py
```

## 数据评估
评估数据集时只需运行下面代码(需要进行api配置的调整)
```
python ./code/evaluation/evaluation.py
```
---
# 实验与分析

### 评估结果
<div align="center">
  
| Evaluator       | Model                  | Q&A  | PLS  | EC   | IP   | AG   | TMG  | ES   | QG   | PCC  | Average |
|-----------------|------------------------|------|------|------|------|------|------|------|------|------|---------|
| **DeepSeek R1** | DeepSeek R1            | **9.81** | **9.83** | **9.05** | **9.11** | 7.74 | **9.46** | **9.71** | **9.22** | **9.73** | **9.29** |
|                 | DeepSeek V3            | 9.67 | 9.12 | 8.97 | 8.82 | **8.32** | 9.31 | 9.34 | 8.65 | 9.23 | 9.05 |
|                 | Qwen Max               | 9.07 | 9.11 | 8.86 | 8.84 | 7.99 | 9.15 | 9.40 | 8.89 | 9.29 | 8.96 |
|                 | Qwen2.5-14B-Instruct   | 8.94 | 8.79 | 8.68 | 8.23 | 7.83 | 9.06 | 8.52 | 8.35 | 8.80 | 8.58 |
|                 | Qwen2.5-7B-Instruct    | 8.34 | 9.01 | 8.64 | 8.16 | 6.64 | 9.33 | 8.75 | 8.23 | 9.06 | 8.46 |
| **DeepSeek V3** | DeepSeek R1            | 9.49 | **9.65** | **9.27** | **8.75** | **7.27** | **9.45** | **9.38** | **9.33** | **9.71** | **9.14** |
|                 | DeepSeek V3            | **9.68** | 9.04 | 9.14 | 8.53 | 7.05 | 9.34 | 9.00 | 9.06 | 8.92 | 8.86 |
|                 | Qwen Max               | 9.18 | 8.88 | 9.06 | 8.52 | 7.23 | 9.24 | 9.04 | 9.05 | 9.29 | 8.83 |
|                 | Qwen2.5-14B-Instruct   | 9.07 | 8.72 | 8.97 | 8.30 | 6.77 | 9.21 | 8.74 | 9.02 | 8.80 | 8.62 |
|                 | Qwen2.5-7B-Instruct    | 9.15 | 9.07 | 9.01 | 8.47 | 6.44 | 9.21 | 8.85 | 8.69 | 9.00 | 8.65 |
| **GPT-4o**      | DeepSeek R1            | 9.32 | **9.38** | 9.05 | 8.78 | 8.51 | **9.25** | **9.15** | 8.98 | **9.08** | **9.06** |
|                 | DeepSeek V3            | 9.22 | 9.15 | **9.14** | 8.77 | 8.54 | 9.12 | 9.05 | **9.00** | 8.95 | 8.99 |
|                 | Qwen Max               | **9.50** | 9.17 | 9.01 | 8.69 | **8.70** | 8.99 | 8.96 | 8.92 | 9.05 | 8.99 |
|                 | Qwen2.5-14B-Instruct   | 9.34 | 9.25 | 8.92 | 8.51 | 8.11 | 8.99 | 9.11 | 8.77 | 8.82 | 8.87 |
|                 | Qwen2.5-7B-Instruct    | 9.22 | 9.17 | 8.92 | **8.84** | 8.04 | 9.05 | 9.00 | 8.62 | 8.94 | 8.87 |
| **QwQ-Plus**    | DeepSeek R1            | **9.85** | **9.87** | **9.24** | **9.05** | **8.78** | **9.75** | **9.85** | **9.09** | **9.88** | **9.49** |
|                 | DeepSeek V3            | 9.59 | 9.43 | 9.06 | 8.66 | 8.18 | 9.29 | 9.66 | 8.47 | 9.24 | 9.06 |
|                 | Qwen Max               | 9.90 | 9.25 | 9.03 | 8.78 | 8.11 | 9.54 | 9.56 | 8.79 | 9.70 | 9.18 |
|                 | Qwen2.5-14B-Instruct   | 9.83 | 9.21 | 9.05 | 8.23 | 7.88 | 9.22 | 9.45 | 8.48 | 9.02 | 8.94 |
|                 | Qwen2.5-7B-Instruct    | 9.02 | 9.28 | 8.79 | 8.82 | 7.16 | 9.33 | 9.31 | 7.98 | 9.35 | 8.78 |
| **Human**       | DeepSeek R1            | 7.17 | **9.11** | **8.71** | **8.80** | **8.42** | **8.86** | **9.15** | **8.79** | **9.35** | **8.71** |
|                 | DeepSeek V3            | 7.45 | 8.12 | 8.16 | 8.17 | 7.84 | 7.56 | 8.08 | 8.01 | 7.03 | 7.82 |
|                 | Qwen Max               | **7.72** | 7.94 | 8.21 | 8.15 | 7.89 | 7.99 | 7.85 | 8.39 | 8.42 | 8.06 |
|                 | Qwen2.5-14B-Instruct   | 7.66 | 7.38 | 7.92 | 7.56 | 7.55 | 7.84 | 7.31 | 7.91 | 7.36 | 7.61 |
|                 | Qwen2.5-7B-Instruct    | 6.78 | 7.63 | 7.93 | 7.74 | 6.79 | 7.86 | 7.79 | 7.55 | 7.42 | 7.50 |

</div>

<div align="center">
  <strong>表1：由不同评估模型评估的场景级平均得分。</strong>
</div>

<br>
<div align="center">

| Evaluator       | Model                  | BFA  | CSI  | CRSC | DKA  | EICP | HOTS | IFTC | MGP  | PAS  | RPR  | RTC  | SEI  | Average |
|-----------------|------------------------|------|------|------|------|------|------|------|------|------|------|------|------|---------|
| **DeepSeek R1** | DeepSeek R1            | 9.55 | **8.67** | **9.64** | **9.53** | 8.66 | **8.39** | **9.61** | 7.30 | **9.80** | **9.17** | **9.64** | **9.45** | **9.12** |
|                 | DeepSeek V3            | **9.58** | 8.47 | 9.48 | 9.30 | **9.32** | 7.53 | 9.39 | **7.48** | 8.92 | 9.05 | 9.32 | 9.10 | 8.91 |
|                 | Qwen Max               | 9.42 | 8.49 | 9.46 | 9.24 | 9.09 | 7.67 | 9.25 | 7.44 | 8.97 | 8.62 | 9.34 | 9.05 | 8.84 |
|                 | Qwen2.5-14B-Instruct   | 9.08 | 8.28 | 9.20 | 8.82 | 8.98 | 7.16 | 8.87 | 6.86 | 8.20 | 8.57 | 9.02 | 8.51 | 8.46 |
|                 | Qwen2.5-7B-Instruct    | 8.73 | 8.22 | 9.00 | 9.00 | 8.30 | 7.27 | 8.72 | 6.61 | 8.68 | 8.05 | 9.23 | 8.55 | 8.36 |
| **DeepSeek V3** | DeepSeek R1            | 9.51 | **8.75** | **9.44** | **9.45** | **7.61** | **8.53** | **9.47** | 7.76 | **9.64** | **8.85** | **9.14** | **9.06** | **8.93** |
|                 | DeepSeek V3            | **9.57** | 8.61 | 9.25 | 9.27 | 7.23 | 7.98 | 9.21 | 7.56 | 8.94 | 8.76 | 9.00 | 8.59 | 8.66 |
|                 | Qwen Max               | 9.38 | 8.53 | 9.12 | 9.23 | 7.43 | 7.99 | 9.16 | **7.85** | 9.05 | 8.57 | 9.00 | 8.61 | 8.66 |
|                 | Qwen2.5-14B-Instruct   | 9.28 | 8.50 | 9.03 | 9.14 | 7.14 | 7.81 | 8.94 | 7.55 | 8.71 | 8.35 | 8.82 | 8.25 | 8.46 |
|                 | Qwen2.5-7B-Instruct    | 9.27 | 8.55 | 9.08 | 9.12 | 6.77 | 7.86 | 8.96 | 7.05 | 8.95 | 8.42 | 8.82 | 8.53 | 8.44 |
| **GPT-4o**      | DeepSeek R1            | 9.48 | **8.73** | **9.59** | **9.17** | 9.05 | **8.35** | 9.13 | 8.45 | **9.18** | **8.89** | **9.11** | **8.65** | **8.98** |
|                 | DeepSeek V3            | 9.54 | 8.72 | 9.51 | 9.05 | **9.14** | 8.05 | **9.16** | **8.59** | 8.95 | 8.75 | 9.02 | 8.63 | 8.93 |
|                 | Qwen Max               | **9.58** | 8.65 | 9.43 | 8.83 | 9.07 | 8.08 | 9.14 | 8.56 | 8.97 | 8.89 | 8.95 | 8.64 | 8.90 |
|                 | Qwen2.5-14B-Instruct   | 9.45 | 8.51 | 9.44 | 8.88 | 8.93 | 7.83 | 9.02 | 8.20 | 8.88 | 8.60 | 9.07 | 8.43 | 8.77 |
|                 | Qwen2.5-7B-Instruct    | 9.45 | 8.57 | 9.38 | 8.85 | 8.59 | 8.00 | 9.01 | 8.20 | 8.85 | 8.65 | 9.02 | **8.65** | 8.77 |
| **QwQ-Plus**    | DeepSeek R1            | **9.78** | **8.47** | **9.78** | **9.82** | **9.70** | **8.19** | **9.65** | **8.35** | **9.86** | **9.61** | **9.70** | **9.58** | **9.37** |
|                 | DeepSeek V3            | 9.42 | 8.25 | 9.57 | 9.09 | 9.52 | 7.22 | 9.36 | 7.62 | 9.23 | 9.23 | 9.39 | 9.32 | 8.93 |
|                 | Qwen Max               | 9.64 | 8.39 | 9.59 | 9.47 | 9.30 | 7.48 | 9.45 | 7.68 | 9.39 | 9.10 | 9.48 | 9.36 | 9.03 |
|                 | Qwen2.5-14B-Instruct   | 9.49 | 8.20 | 9.48 | 8.98 | 9.20 | 7.10 | 9.15 | 7.64 | 8.77 | 8.83 | 9.41 | 9.06 | 8.78 |
|                 | Qwen2.5-7B-Instruct    | 9.08 | 8.10 | 9.31 | 8.98 | 8.91 | 7.02 | 9.03 | 7.18 | 9.09 | 8.61 | 9.30 | 9.33 | 8.66 |
| **Human**       | DeepSeek R1            | **8.97** | **8.60** | **8.98** | **8.94** | **8.86** | **8.56** | **8.77** | **8.20** | **9.26** | **7.95** | **8.91** | **8.92** | **8.74** |
|                 | DeepSeek V3            | 8.77 | 7.77 | 8.40 | 7.89 | 8.11 | 7.25 | 8.10 | 7.70 | 7.42 | 7.03 | 7.80 | 7.47 | 7.89 |
|                 | Qwen Max               | 8.81 | 8.01 | 8.52 | 8.27 | 8.23 | 7.59 | 8.10 | 7.70 | 7.89 | 7.31 | 8.09 | 7.74 | 8.02 |
|                 | Qwen2.5-14B-Instruct   | 8.74 | 7.76 | 8.26 | 7.79 | 7.86 | 6.88 | 7.77 | 6.97 | 7.02 | 7.01 | 7.59 | 7.03 | 7.56 |
|                 | Qwen2.5-7B-Instruct    | 8.49 | 7.63 | 8.04 | 7.82 | 7.45 | 6.93 | 7.65 | 7.05 | 7.38 | 5.90 | 7.82 | 7.35 | 7.46 |

</div>

<div align="center">
  <strong>表2：展示了不同评价模型在不同指标下评价的指标级平均得分。</strong>
</div>

**模型评估结果**  
DeepSeek R1 在不同指标中展现出最佳的整体表现，而 Qwen2.5-7B-Instruct 在表2 中表现最差。

**人工评估结果**  
在表2中，DeepSeek R1 和 Qwen2.5-7B-Instruct 依然分别展现出最佳和最差的表现，这一结果与基于模型的评估结果一致。

---


### 模型与人类评估一致性分析
<div align="center">
  
| Model          | DeepSeek R1 | GPT-4o | QwQ-Plus | DeepSeek V3 | Human |
|----------------|-------------|--------|----------|-------------|-------|
| **DeepSeek R1** | -           | 0.55   | 0.61     | **0.65**    | 0.63  |
| **GPT-4o**      | 0.55        | -      | 0.57     | **0.58**    | 0.56  |
| **QwQ-Plus**    | 0.61        | 0.57   | -        | **0.62**    | 0.63  |
| **DeepSeek V3** | 0.65        | 0.58   | 0.62     | -           | 0.63  |
| **Human**       | 0.63        | 0.56   | 0.63     | **0.63**    | -     |

</div>

<div align="center">
  
  <strong>不同评估模型与人工评估之间的 Kendall's W，我们可以发现：</strong>

</div>

- **评价模型之间的一致性**：模型表现出高度的一致性，几乎所有模型的 Kendall's W 值都在 0.5 以上，大多数在 0.6 左右，显示出很强的一致性。
- **人类和模型之间的一致性**：模型的评估评分与人类判断并不完全一致，这可能是由于他们对评估指标的理解有限。

---
### 模型蒸馏

<div align="center">

| Model                  | BFA  | CSI  | CRSC | DKA  | EICP | HOTS | IFTC | MGP  | PAS  | RPR  | RTC  | SEI  | Average |
|------------------------|------|------|------|------|------|------|------|------|------|------|------|------|---------|
| DeepSeek R1            | _9.51_ | **8.75** | **9.44** | **9.45** | **7.61** | **8.53** | **9.47** | _7.76_ | **9.64** | _8.85_ | **9.14** | **9.06** | **8.93** |
| DeepSeek V3            | **9.57** | _8.61_ | 9.25 | _9.27_ | 7.23 | 7.98 | 9.21 | 7.56 | 8.94 | 8.76 | 9.00 | 8.59 | 8.66 |
| Qwen Max               | 9.38 | 8.53 | 9.12 | 9.23 | _7.43_ | 7.99 | 9.16 | **7.85** | 9.05 | 8.57 | 9.00 | 8.61 | 8.66 |
| Qwen2.5-14B-Instruct   | 9.28 | 8.50 | 9.03 | 9.14 | 7.14 | 7.81 | 8.94 | 7.55 | 8.71 | 8.35 | 8.82 | 8.25 | 8.46 |
| Qwen2.5-7B-Instruct    | 9.27 | 8.55 | 9.08 | 9.12 | 6.77 | 7.86 | 8.96 | 7.05 | 8.95 | 8.42 | 8.82 | 8.53 | 8.44 |
| Distillation Qwen2.5-7B| 9.26 | 8.56 | _9.27_ | 8.95 | 6.89 | _8.43_ | _9.41_ | 7.32 | _9.56_ | **9.26** | _9.09_ | _8.95_ | _8.75_ |

</div>

<div align="center">
  
   <strong>蒸馏模型与其他模型在各项指标上的表现：</strong>

</div>

- **数据集构建**：为了充分利用不同生成模型在各种教育场景中的优势，我们采用了一个多源蒸馏流程。对于每个任务，我们从测试集中选择表现最优的模型作为回答生成器，并使用它来回答教育领域的问题，从而构建用于蒸馏模型的训练数据集。通过该蒸馏流程，我们获得了包含 4,000 个样本的训练集，覆盖了全部 9 个教育场景中的各类子任务。
- **性能表现**：在经过蒸馏之后，7B 模型在 12 项指标中的 10 项上都有显著提升，其整体表现已与当前最先进的模型相当。

