# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['nonebot_plugin_report']

package_data = \
{'': ['*']}

install_requires = \
['nonebot2>=2.0.0rc2,<3.0.0']

setup_kwargs = {
    'name': 'nonebot-plugin-report',
    'version': '1.2.0',
    'description': 'Push message from anywhere to your bot through webhook.',
    'long_description': '<div align="center">\n\n# nonebot-plugin-report\n\n</div>\n\n## 功能\n\n该插件提供了一个位于 `/report` 的路由，通过此路由可直接向用户推送消息，实现消息推送机器人的功能\n\n## 使用\n\n请求体示例\n```json\n{\n    "token": "your token here",\n    "title": "report title",\n    "content": "report content",\n    "send_to": "send to"\n}\n```\n\n### 字段\n\nField | Type | Desc\n-- | -- | --\n`token` | `Optional[str]` | 令牌，当与设置的 `REPORT_TOKEN` 相同时才会推送消息，否则返回 403\n`title` | `Optional[str]` | 消息标题\n`content` | `str` | 消息内容，*必需字段*\n`send_from` | `Optional[ID]` | 推送消息的机器人 ID\n`send_to` | `Optional[ID \\| List[ID]]` | 推送用户 `user_id`；<br/>若为 `null` 则推送给所有超管；\n`send_to_group` | `Optional[ID \\| List[ID]]` | 推送群组 `group_id`\n\n### 配置\n\nField | Type | Desc | Default\n-- | -- | -- | --\n`REPORT_TOKEN` | `Optional[str]` | 令牌，若不设置则不会进行验证，所有人都可以触发 webhook |\n`REPORT_ROUTE` | `str` | 路由，若与其它路由冲突可以更换该值，| `/report`\n`REPORT_TEMPLATE` | `str` | 消息模板，支持 `title` 与 `content` 两个字段，| `{title}\\n{content}`\n\n## 使用例\n\n### python\n\n```bash\nimport requests\ndata = {\'token\': \'...\', \'content\': \'...\'}\nrequests.post(\'http://127.0.0.1:8080/report\', json=data)\n```\n\n### curl\n\n```bash\ncurl -L -X POST \\\n     -d \'{"token": "...", "content": "..."}\' \\\n     -H "Content-Type: application/json" \\\n     -- http://127.0.0.1:8080/report\n```\n\n### todo\n\n- [x] 支持设置消息模板\n',
    'author': 'syrinka',
    'author_email': 'syrinka@foxmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/syrinka/nonebot-plugin-report',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8.0,<4.0.0',
}


setup(**setup_kwargs)
