"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaApplication = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const codedeploy_generated_1 = require("../codedeploy.generated");
const utils_1 = require("../utils");
/**
 * A CodeDeploy Application that deploys to an AWS Lambda function.
 *
 * @resource AWS::CodeDeploy::Application
 */
class LambdaApplication extends core_1.Resource {
    constructor(scope, id, props = {}) {
        super(scope, id, {
            physicalName: props.applicationName,
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_codedeploy_LambdaApplicationProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, LambdaApplication);
            }
            throw error;
        }
        const resource = new codedeploy_generated_1.CfnApplication(this, 'Resource', {
            applicationName: this.physicalName,
            computePlatform: 'Lambda',
        });
        this.applicationName = this.getResourceNameAttribute(resource.ref);
        this.applicationArn = this.getResourceArnAttribute(utils_1.arnForApplication(resource.ref), {
            service: 'codedeploy',
            resource: 'application',
            resourceName: this.physicalName,
            arnFormat: core_1.ArnFormat.COLON_RESOURCE_NAME,
        });
    }
    /**
     * Import an Application defined either outside the CDK, or in a different CDK Stack.
     *
     * @param scope the parent Construct for this new Construct
     * @param id the logical ID of this new Construct
     * @param lambdaApplicationName the name of the application to import
     * @returns a Construct representing a reference to an existing Application
     */
    static fromLambdaApplicationName(scope, id, lambdaApplicationName) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.applicationArn = utils_1.arnForApplication(lambdaApplicationName);
                this.applicationName = lambdaApplicationName;
            }
        }
        return new Import(scope, id);
    }
    validate() {
        return utils_1.validateName('Application', this.physicalName);
    }
}
exports.LambdaApplication = LambdaApplication;
_a = JSII_RTTI_SYMBOL_1;
LambdaApplication[_a] = { fqn: "@aws-cdk/aws-codedeploy.LambdaApplication", version: "1.186.0" };
//# sourceMappingURL=data:application/json;base64,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