#!/bin/bash

# This script starts JobServers via "server.sh" and ssh agent.
# For ssh-agent see: http://mah.everybody.org/docs/ssh
#
# -h  displays the help
#
#
# $Revision: 1.2 $
# FracPete

function usage()
{
   echo
   echo "usage: ${0##*/} -H <host-file> -j <filename> -f <filename>"
   echo "       -p <client-port> -o <output-dir> [-h]"
   echo 
   echo "starts the JobServers via 'server.sh' and ssh-agent"
   echo "for ssh-agent see: http://mah.everybody.org/docs/ssh"
   echo "The servers file is a simple text file with a hostname in each line."
   echo "E.g.:"
   echo "   somehost"
   echo "   anotherone"
   echo "Each entry can have its own parameters, i.e. just list the options "
   echo "from the command line after a colon \";\" in the clients file. E.g.:"
   echo "   somehost;-A /some/dir/ant"
   echo "Note: the options -h, -H are not available!"
   echo 
   echo " -h   this help"
   echo " -H   the name of the file containing the hostnames for the clients"
   echo "      default: $HOSTS"
   echo " -j   the filename containing the jobs"
   echo "      default: $JOBS"
   echo " -r   the file where to store the results to"
   echo "      default: $RESULTS"
   echo " -p   the port on which the client should listen (optional)"
   echo "      default: $PORT"
   echo " -o   the directory where to store the logfiles"
   echo "      default: $OUTPUT"
   echo
}

# counts the lines of the hosts file and returns the result in TMP
function count_hosts()
{
   TMP=`cat $HOSTS | grep -v "^$\|^#" | wc -l | sed s/" "*//g`
}

# returns the specified line (in LINE) from the hosts file in TMP
function get_line()
{
   TMP=`cat $HOSTS | grep -v "^$\|^#" | head -n $LINE | tail -n 1`
}

# returns the hosts from the specified line (in LINE) from the hosts file in TMP
function get_host()
{
   get_line
   TMP=`echo $TMP | cut -f1 -d";"`
}

# returns additional commands from the specified line (in LINE) from the hosts
# file in TMP
function get_additional()
{
   get_host
   TMP2=$TMP
   get_line
   TMP=`echo $TMP | sed s/"$TMP2;"//g`
}

# variables
ROOT=`expr "$0" : '\(.*\)/'`
HOSTS="$ROOT/../tmp/servers"
JOBS=$ROOT/jobs
RESULTS="$ROOT/../tmp/results.txt"
PORT=31415
OUTPUT="$ROOT/../tmp"
SCRIPT="$ROOT/server.sh"

# interprete parameters
while getopts ":hH:j:r:p:o:" flag
do
   case $flag in
      h) usage
         exit 0
         ;;
      H) HOSTS=$OPTARG
         ;;
      j) JOBS=$OPTARG
         ;;
      r) RESULTS=$OPTARG
         ;;
      p) PORT=$OPTARG
         ;;
      o) OUTPUT=$OPTARG
         ;;
      *) usage
         exit 1
         ;;
   esac
done

# start the servers
count_hosts;COUNT=$TMP

for ((i = 1; i <= $COUNT; i++))
do
   # get host
   LINE=$i;get_host;HOST=$TMP
   
   # was it a comment?
   HOST=`echo $HOST | sed s/#.*//g`
   if [ "$HOST" = "" ]
   then
      continue
   fi
   
   # additional parameters?
   get_additional

   # ssh
   echo $HOST
   ssh $HOST "bash --login -ic \"cd `pwd`; nohup nice -n 19 $SCRIPT2 -j $JOBS2 -r $RESULTS2 -p $PORT2 -o $OUTPUT2 $TMP\"" &
done

