#!/bin/bash
#
# This shell script prepares the data, s.t. Proper can handle it better
#
# use -help to see options
#
# FracPete

# the usage of this script
function usage()
{
   echo
   echo "usage: ${0##*/} -i <input-dir> -o <output-dir> [-h]"
   echo 
   echo "pastes the data for the frienfly instances into one file"
   echo "creates 2 files: friendly, unfriendly"
   echo "as well as the background knowledge"
   echo
   echo " -h   this help"
   echo " -i   <input-dir>"
   echo "      the directory where the original data is located"
   echo "      default: $SRC"
   echo " -o   <output-dir>"
   echo "      where to put the processed files"
   echo "      default: $DEST"
   echo
}

# variables
ROOT=`expr "$0" : '\(.*\)/'`
SRC="$ROOT/original"
DEST="$ROOT"

# interprete parameters
while getopts ":hi:o:" flag
do
   case $flag in
      i) SRC=$OPTARG
         ;;
      o) DEST=$OPTARG
         ;;
      h) usage
         exit 0
         ;;
      *) usage
         exit 1
         ;;
   esac
done

# remove former .pl files
echo "deleting old files..."
rm -f $DEST/*.pl

# create friendly file
echo "creating friendly file..."
TMP=$DEST/friendly.pl
rm -f $TMP
for i in $SRC/188/*.pl
do
   if [ ! -f $TMP ]
   then
      cat $i > $TMP
   else
      cat $i >> $TMP
   fi
done

# copy unfriendly file
echo "copy unfriendly file..."
TMP=$DEST/unfriendly.pl
cp $SRC/42/all.pl $TMP

# copy background knowledge
echo "copy background knowledge..."
for i in $SRC/common/*.pl
do
   cp $i $DEST/
done

