#!/bin/bash

# this scripts changes the hostname, port, user and password in the ant files
#
# $Revision: 1.2 $
# FracPete

# prints the usage of this script
function usage()
{
   echo
   echo "usage: ${0##*/} -F|-N [-b] [-h]"
   echo 
   echo "Sets the discovery of relations either to foreign keys of based on"
   echo "column names."
   echo 
   echo " -h   this help"
   echo " -F   use foreign keys for discovery"
   echo " -N   use column names for discovery"
   echo " -b   backup the files"
   echo 
}

# changes the property "TMP" in the XML file "FILE" and sets the value to 
# "VALUE"
function changeValue()
{
   cat $FILE | sed s/"property name=\"$TMP\".*value=\".*\""/"property name=\"$TMP\" value=\"$VALUE\""/g > _$FILE
   rm $FILE
   mv _$FILE $FILE
}

# variables
ROOT=`expr "$0" : '\(.*\)/'`
XMLDIR="$ROOT/../xml"
USE_FOREIGNKEYS="no"
USE_NAMES="no"
BACKUP="no"
SCRIPT="$ROOT/change_property.sh"

# interprete parameters
while getopts ":hbFN" flag
do
   case $flag in
      h) usage
         exit 0
         ;;
      F) USE_FOREIGNKEYS="yes"
         ;;
      N) USE_NAMES="yes"
         ;;
      b) BACKUP="yes"
         ;;
      *) usage
         exit 1
         ;;
   esac
done

# everything provided?
if [ "$USE_FOREIGNKEYS" = "$USE_NAMES" ]
then
   echo
   echo "ERROR: either '-F' or '-N' must be specified!"
   echo 
   usage
   exit 2
fi

if [ "$BACKUP" = "yes" ]
then
   BAK="-b"
else
   BAK=""
fi

# change the files
if [ "$USE_FOREIGNKEYS" = "yes" ]
then
   $SCRIPT -p "use_foreign_keys" -v "-use_foreign_keys" -d "$ROOT/.." $BAK
   $SCRIPT -p "use_foreign_keys" -v "-use_foreign_keys" -d "$XMLDIR" $BAK
else
   $SCRIPT -p "use_foreign_keys" -v " " -d "$ROOT/.." $BAK
   $SCRIPT -p "use_foreign_keys" -v " " -d "$XMLDIR" $BAK
fi

