/*
 * Decompiled with CFR 0.152.
 */
package model.inference.hc;

import data.aggregate.selection.SelectionWithFilters;
import data.catalog.Catalog;
import data.condition.FilterFeature;
import data.feature.AggregateFeature;
import data.feature.SimpleFeature;
import data.instance.Instance;
import data.instance.Instances;
import data.value.Value;
import java.util.ArrayList;
import java.util.Random;
import java.util.TreeSet;
import java.util.stream.Collectors;
import model.ModelOptions;
import model.NodeSplit;
import model.criterion.cancel.CancelCriterion;
import model.inference.hc.AggregateBase;
import model.inference.hc.HillClimbing;
import util.Logging;

public class OneHillClimbingRandom
extends HillClimbing {
    private int numIterations = 0;
    private int numIterationsWithoutImp;
    private AggregateBase ab;
    private AggregateFeature aggregate;
    private ArrayList<SimpleFeature> allFeatures;
    private ArrayList<SimpleFeature> presentFeatures;
    private ArrayList<SimpleFeature> absentFeatures;

    public OneHillClimbingRandom(ModelOptions opt, Random gr, AggregateBase abb, ArrayList<SimpleFeature> feats) {
        super(opt, gr);
        this.ab = abb;
        this.allFeatures = new ArrayList<SimpleFeature>(feats);
        this.absentFeatures = new ArrayList<SimpleFeature>(this.allFeatures);
        this.presentFeatures = new ArrayList();
    }

    @Override
    public NodeSplit run(Instances insts, Catalog cat, ArrayList<CancelCriterion> cancels) {
        long numSec = 0L;
        for (Instance inst : insts) {
            numSec += (long)this.ab.getLink().getLinkedElements(inst.getId(), cat).size();
        }
        this.numIterations = (int)Math.round(Math.sqrt((double)this.allFeatures.size() * (double)numSec));
        this.numIterationsWithoutImp = (int)Math.round((double)this.numIterations / 5.0);
        ArrayList<NodeSplit> bestSplits = new ArrayList<NodeSplit>();
        ArrayList<Value> ids = new ArrayList<Value>();
        for (Instance inst : insts) {
            ids.add(inst.getId());
        }
        AggregateFeature aggFeat = new AggregateFeature(this.ab.getFunction());
        aggFeat.setFeature(this.ab.getFeature());
        SelectionWithFilters swf = new SelectionWithFilters();
        swf.setSelection(this.ab.getLink());
        aggFeat.addToObjectSelection(swf);
        if (this.aggregate == null) {
            this.aggregate = aggFeat.clone();
        }
        this.evaluateAggregate(aggFeat, insts, cat, true, bestSplits, cancels);
        int countSinceLastImprovement = -1;
        int i = 0;
        while (i < this.numIterations && countSinceLastImprovement < this.numIterationsWithoutImp) {
            long t1 = System.currentTimeMillis();
            AggregateFeature copyAgg = this.aggregate.clone();
            SimpleFeature sfToModify = this.allFeatures.get(this.rt.nextInt(this.allFeatures.size()));
            boolean improved = false;
            if (this.absentFeatures.contains(sfToModify)) {
                if (sfToModify.getTypeOut().getKind() == 0) {
                    AggregateFeature toTry = copyAgg.clone();
                    toTry.addCondition(cat, sfToModify, new ArrayList<Value>(sfToModify.getTypeOut().getValues()), this.rt);
                    toTry.setFunction(this.ab.getFunction());
                    toTry.setFeature(this.ab.getFeature());
                    boolean imp = this.evaluateAggregate(toTry, insts, cat, true, bestSplits, cancels);
                    if (imp) {
                        this.aggregate = toTry.clone();
                    }
                    improved = improved || imp;
                } else if (sfToModify.getTypeOut().getKind() == 1) {
                    SelectionWithFilters swfCurrent = copyAgg.getObjectSelection().getSelections().get(0).clone();
                    TreeSet possibleValues = new TreeSet(ids.stream().flatMap(v -> swfCurrent.select((Value)v, cat)).map(sid -> sfToModify.result((Value)sid, cat)).filter(val -> val.getStringValue() != null).collect(Collectors.toSet()));
                    AggregateFeature toTry = copyAgg.clone();
                    toTry.addCondition(cat, sfToModify, new ArrayList<Value>(possibleValues), this.rt);
                    toTry.setFunction(this.ab.getFunction());
                    toTry.setFeature(this.ab.getFeature());
                    boolean imp = this.evaluateAggregate(toTry, insts, cat, true, bestSplits, cancels);
                    if (imp) {
                        this.aggregate = toTry.clone();
                    }
                    improved = improved || imp;
                }
            } else if (this.presentFeatures.contains(sfToModify)) {
                if (sfToModify.getTypeOut().getKind() == 0) {
                    AggregateFeature toTry = copyAgg.clone();
                    ArrayList<Value> valuesAttr = new ArrayList<Value>(sfToModify.getTypeOut().getValues());
                    toTry.applyMove(cat, ids, sfToModify, valuesAttr.get(this.rt.nextInt(valuesAttr.size())));
                    toTry.setFunction(this.ab.getFunction());
                    toTry.setFeature(this.ab.getFeature());
                    boolean imp = this.evaluateAggregate(toTry, insts, cat, toTry.complexity() >= copyAgg.complexity(), bestSplits, cancels);
                    if (imp) {
                        this.aggregate = toTry.clone();
                    }
                    improved = improved || imp;
                } else if (sfToModify.getTypeOut().getKind() == 1) {
                    TreeSet<Value> possibleValues;
                    SelectionWithFilters swfClone = copyAgg.getObjectSelection().getSelections().get(0).clone();
                    FilterFeature toRemove = null;
                    for (FilterFeature ff : swfClone.getFilters()) {
                        if (!ff.getFeature().equals(sfToModify)) continue;
                        toRemove = ff;
                        break;
                    }
                    if (toRemove != null) {
                        swfClone.getFilters().remove(toRemove);
                    }
                    if (!(possibleValues = new TreeSet<Value>(ids.stream().flatMap(v -> swfClone.select((Value)v, cat)).map(sid -> sfToModify.result((Value)sid, cat)).filter(val -> val.getStringValue() != null).collect(Collectors.toSet()))).isEmpty()) {
                        AggregateFeature toTry = copyAgg.getNeighbor(possibleValues, sfToModify, this.rt);
                        toTry.setFunction(this.ab.getFunction());
                        toTry.setFeature(this.ab.getFeature());
                        boolean imp = this.evaluateAggregate(toTry, insts, cat, toTry.complexity() >= copyAgg.complexity(), bestSplits, cancels);
                        if (imp) {
                            this.aggregate = toTry.clone();
                        }
                        boolean bl = improved = improved || imp;
                    }
                }
            }
            if (improved) {
                countSinceLastImprovement = -1;
                boolean simplification = true;
                while (simplification) {
                    simplification = false;
                    this.presentFeatures.clear();
                    this.absentFeatures.clear();
                    for (FilterFeature ff : this.aggregate.getObjectSelection().getSelections().get(0).getFilters()) {
                        this.presentFeatures.add((SimpleFeature)ff.getFeature());
                    }
                    for (SimpleFeature sf : this.allFeatures) {
                        boolean isPresent = this.presentFeatures.contains(sf);
                        if (isPresent) continue;
                        this.absentFeatures.add(sf);
                    }
                    AggregateFeature copyAggSimpl = this.aggregate.clone();
                    for (SimpleFeature sf : this.presentFeatures) {
                        AggregateFeature toTry = copyAggSimpl.clone();
                        toTry.removeCondition(sf);
                        toTry.setFunction(this.ab.getFunction());
                        toTry.setFeature(this.ab.getFeature());
                        boolean imp = this.evaluateAggregate(toTry, insts, cat, toTry.complexity() >= copyAgg.complexity(), bestSplits, cancels);
                        if (imp) {
                            this.aggregate = toTry.clone();
                        }
                        boolean bl = simplification = simplification || imp;
                    }
                }
                Logging.hc.info((Object)(String.valueOf(this.opts.name) + " - New best aggregate!\n" + bestSplits.get(0).toString()));
            }
            this.presentFeatures.clear();
            this.absentFeatures.clear();
            for (FilterFeature ff : this.aggregate.getObjectSelection().getSelections().get(0).getFilters()) {
                this.presentFeatures.add((SimpleFeature)ff.getFeature());
            }
            for (SimpleFeature sf : this.allFeatures) {
                boolean isPresent = this.presentFeatures.contains(sf);
                if (isPresent) continue;
                this.absentFeatures.add(sf);
            }
            long t2 = System.currentTimeMillis();
            Logging.hc.info((Object)(String.valueOf(this.opts.name) + " - " + i + "/" + this.numIterations + "\t" + (double)(t2 - t1) / 1000.0 + "s.\t" + ++countSinceLastImprovement + "/" + this.numIterationsWithoutImp));
            ++i;
        }
        Logging.hc.info((Object)(String.valueOf(this.opts.name) + " - HC finished. Best split(s) :\n" + bestSplits.toString()));
        return this.chooseBestSplit(bestSplits);
    }
}

