/*
 * Decompiled with CFR 0.152.
 */
package model.inference.hc;

import data.Type;
import data.aggregate.AggregateFunction;
import data.aggregate.Ratio;
import data.catalog.Catalog;
import data.feature.LinkFeature;
import data.feature.SimpleFeature;
import data.instance.Instance;
import data.instance.Instances;
import data.value.Value;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import model.ModelOptions;
import model.NodeSplit;
import model.criterion.cancel.CancelCriterion;
import model.inference.hc.AggregateBase;
import model.inference.hc.HillClimbing;
import model.inference.hc.OneHillClimbingRandom;
import util.Logging;

public class HillClimbingRandom
extends HillClimbing {
    private ArrayList<AggregateBase> abs;

    public HillClimbingRandom(ModelOptions opt, Random gr) {
        super(opt, gr);
    }

    @Override
    public NodeSplit run(Instances insts, Catalog cat, ArrayList<CancelCriterion> cancels) {
        ArrayList<NodeSplit> bestSplits = new ArrayList<NodeSplit>();
        this.abs = new ArrayList();
        Type ti = cat.getClassFeature().getTypeIn();
        ArrayList<LinkFeature> lfs = cat.getLinkFeatures(ti);
        if (!lfs.isEmpty()) {
            LinkFeature lf = lfs.get(0);
            ArrayList<SimpleFeature> sfs = cat.getSimpleFeatures(lf.getTypeOut());
            for (AggregateFunction<?> af : this.opts.aggFunctions) {
                if (af.isNeedsFeature()) {
                    for (SimpleFeature sf : sfs) {
                        if (af.getKindIn() != sf.getTypeOut().getKind()) continue;
                        if (af.getName().equals("ratio")) {
                            for (Value val : sf.getTypeOut().getValues()) {
                                AggregateBase ab = new AggregateBase(new Ratio(sf, val), lf, sf);
                                this.abs.add(ab);
                            }
                            continue;
                        }
                        AggregateBase ab = new AggregateBase(af, lf, sf);
                        this.abs.add(ab);
                    }
                    continue;
                }
                AggregateBase ab = new AggregateBase(af, lf, null);
                this.abs.add(ab);
            }
            ArrayList<Value> ids = new ArrayList<Value>();
            for (Instance inst : insts) {
                ids.add(inst.getId());
            }
            if (this.opts.treesInForest > 1) {
                Collections.shuffle(this.abs, this.rt);
                int toKeep = (int)Math.floor(Math.sqrt(this.abs.size()));
                int n = this.abs.size();
                int i = n - 1;
                while (i >= toKeep) {
                    this.abs.remove(i);
                    --i;
                }
            }
            for (AggregateBase ab : this.abs) {
                ArrayList<SimpleFeature> allFeatures = null;
                if (this.opts.treesInForest > 1) {
                    ArrayList<SimpleFeature> sfsCopy = new ArrayList<SimpleFeature>(sfs);
                    Collections.shuffle(sfsCopy, this.rt);
                    allFeatures = new ArrayList<SimpleFeature>(sfsCopy.subList(0, (1 + sfsCopy.size()) / 2));
                } else {
                    allFeatures = new ArrayList<SimpleFeature>(sfs);
                }
                OneHillClimbingRandom ohcr = new OneHillClimbingRandom(this.opts, this.rt, ab, allFeatures);
                NodeSplit ns = ohcr.run(insts, cat, cancels);
                this.updateBestSplits(ns, bestSplits, true, cancels);
            }
        }
        Logging.hc.info((Object)(String.valueOf(this.opts.name) + " - HC finished. Best split(s) :\n" + bestSplits.toString()));
        return this.chooseBestSplit(bestSplits);
    }
}

