/*
 * Decompiled with CFR 0.152.
 */
package model.inference;

import data.Type;
import data.aggregate.AggregateFunction;
import data.aggregate.selection.PipeSelectionFilters;
import data.aggregate.selection.SelectionWithFilters;
import data.catalog.Catalog;
import data.condition.FilterNumericFeature;
import data.condition.Operator;
import data.feature.AggregateFeature;
import data.feature.LinkFeature;
import data.feature.SimpleFeature;
import data.instance.Instance;
import data.instance.Instances;
import data.value.Value;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.TreeMap;
import java.util.stream.Collectors;
import model.ModelOptions;
import model.NodeSplit;
import model.criterion.cancel.CancelCriterion;
import model.inference.Inference;
import model.inference.SplitFinder;
import util.AggregatesRanking;
import util.Couple;

public class InferenceFirstLevelBeam
extends Inference {
    public InferenceFirstLevelBeam(ModelOptions opts) {
        super(opts);
    }

    @Override
    public NodeSplit infer(Instances insts, Catalog cat) {
        Type initialType = cat.getClassFeature().getTypeIn();
        ArrayList<LinkFeature> lfs = cat.getLinkFeatures(initialType);
        ArrayList<SimpleFeature> sfs = cat.getSimpleFeatures(initialType);
        ArrayList<NodeSplit> bestNodeSplits = new ArrayList<NodeSplit>();
        ArrayList<Value> ids = new ArrayList<Value>(insts.size());
        for (Instance inst : insts) {
            ids.add(inst.getId());
        }
        for (LinkFeature lf : lfs) {
            for (AggregateFunction<?> af : this.opts.aggFunctions) {
                AggregateFeature aggFeat = new AggregateFeature(af);
                Iterator swf = new SelectionWithFilters();
                ((SelectionWithFilters)((Object)swf)).setSelection(lf);
                aggFeat.addToObjectSelection((SelectionWithFilters)((Object)swf));
                AggregatesRanking bestAggregates = new AggregatesRanking(-1.7976931348623157E308, this.opts.beamSize, true);
                this.refineInsideAggregate(insts, cat, ids, aggFeat, aggFeat, bestAggregates);
                this.updateBestSplitsFromAggregate(bestAggregates, bestNodeSplits);
            }
        }
        for (SimpleFeature sf : sfs) {
            Value resForInst;
            HashMap<Value, Instances> decomposition;
            Type typeOutput = sf.getTypeOut();
            if (typeOutput.getKind() == 0) {
                decomposition = new HashMap<Value, Instances>();
                for (Value tyVal : typeOutput.getValues()) {
                    decomposition.put(tyVal, new Instances());
                }
                for (Instance inst : insts) {
                    resForInst = sf.result(inst.getId(), cat);
                    ((Instances)decomposition.get(resForInst)).add(inst);
                }
                NodeSplit bs = null;
                if (this.opts.mode.equals("classification")) {
                    bs = SplitFinder.inferNominalSplitOnNominalTarget(sf, decomposition, new Instances(), this.opts.complexity);
                } else if (this.opts.mode.equals("regression")) {
                    bs = SplitFinder.inferNominalSplitOnNumericTarget(sf, decomposition, new Instances(), this.opts.complexity);
                }
                this.updateBestSplits(bs, bestNodeSplits);
                continue;
            }
            if (typeOutput.getKind() != 1) continue;
            decomposition = new HashMap();
            for (Instance inst : insts) {
                resForInst = sf.result(inst.getId(), cat);
                if (!decomposition.containsKey(resForInst)) {
                    decomposition.put(resForInst, new Instances());
                }
                ((Instances)decomposition.get(resForInst)).add(inst);
            }
            TreeMap<Value, Instances> orderedInstances = new TreeMap<Value, Instances>(decomposition);
            NodeSplit bs = null;
            if (this.opts.mode.equals("classification")) {
                bs = SplitFinder.inferNumericSplitOnNominalTarget(sf, orderedInstances, new Instances(), this.opts.complexity);
            } else if (this.opts.mode.equals("regression")) {
                bs = SplitFinder.inferNumericSplitOnNumericTarget(sf, orderedInstances, new Instances(), this.opts.complexity);
            }
            this.updateBestSplits(bs, bestNodeSplits);
        }
        return this.chooseBestSplit(bestNodeSplits);
    }

    private void refineInsideAggregate(Instances insts, Catalog cat, ArrayList<Value> ids, AggregateFeature firstLevelAggregate, AggregateFeature toModify, AggregatesRanking bestAggregates) {
        this.testFeaturesToAggregate(firstLevelAggregate, insts, cat, toModify, bestAggregates);
        bestAggregates.pruneBeam();
        System.out.println(bestAggregates.toString());
        boolean keepLooking = true;
        while (keepLooking) {
            AggregatesRanking bestAggregates2 = new AggregatesRanking((Double)bestAggregates.firstKey(), this.opts.beamSize, false);
            boolean newKeepLooking = false;
            for (ArrayList listCoup : bestAggregates.values()) {
                ArrayList listCoup2 = new ArrayList(listCoup);
                for (Couple coup : listCoup2) {
                    toModify.setObjectSelection(((AggregateFeature)coup.getLeft()).getObjectSelection());
                    toModify.setFeature(((AggregateFeature)coup.getLeft()).getFeature());
                    AggregatesRanking bestAggregates3 = new AggregatesRanking(((NodeSplit)coup.getRight()).getScore(), this.opts.beamSize, true);
                    this.refineInsideAggregateOneStep(insts, cat, ids, firstLevelAggregate, toModify, bestAggregates3);
                    if (bestAggregates3.isEmpty()) {
                        bestAggregates2.insertInto(coup);
                        continue;
                    }
                    newKeepLooking = true;
                    bestAggregates2.merge(bestAggregates3);
                }
            }
            bestAggregates2.pruneBeam();
            keepLooking = newKeepLooking;
            if (!keepLooking) continue;
            bestAggregates.clear();
            bestAggregates.putAll(bestAggregates2);
            System.out.println(bestAggregates);
        }
    }

    private void refineInsideAggregateOneStep(Instances insts, Catalog cat, ArrayList<Value> ids, AggregateFeature firstLevelAggregate, AggregateFeature toModify, AggregatesRanking bestAggregates) {
        Operator[] ops = new Operator[]{Operator.GEQ, Operator.LT};
        long tBeg = System.currentTimeMillis();
        AggregateFeature toModifyOrigin = toModify.clone();
        PipeSelectionFilters selections = toModify.getObjectSelection().clone();
        int i = 0;
        while (i < selections.getSelections().size()) {
            int j = 0;
            while (j < selections.getSelections().get(i).getFilters().size()) {
                PipeSelectionFilters selectionsMinusOne = selections.clone();
                selectionsMinusOne.getSelections().get(i).getFilters().remove(j);
                toModify.setObjectSelection(selectionsMinusOne);
                this.testFeaturesToAggregate(firstLevelAggregate, insts, cat, toModify, bestAggregates);
                toModify.reinitialize(toModifyOrigin.clone());
                ++j;
            }
            ++i;
        }
        Type initialType = toModify.getLastSelection().getTypeOut();
        ArrayList<SimpleFeature> sfs = cat.getSimpleFeatures(initialType);
        for (SimpleFeature sf : sfs) {
            Type typeOutput = sf.getTypeOut();
            if (typeOutput.getKind() == 0) {
                ArrayList<Value> idsUsed = new ArrayList<Value>(ids.stream().flatMap(id -> toModify.getObjectSelection().select((Value)id, cat)).collect(Collectors.toList()));
                HashSet<Value> valuesUsed = sf.getTypeOut().getValues();
                for (Value tyVal : valuesUsed) {
                    toModify.applyMove(cat, idsUsed, sf, tyVal);
                    this.testFeaturesToAggregate(firstLevelAggregate, insts, cat, toModify, bestAggregates);
                    toModify.reinitialize(toModifyOrigin.clone());
                }
                continue;
            }
            if (typeOutput.getKind() != 1) continue;
            FilterNumericFeature filterNum = new FilterNumericFeature(sf, null, new Value(-1.7976931348623157E308));
            int i2 = 0;
            while (i2 < ops.length) {
                filterNum.setOperator(ops[i2]);
                AggregateFeature toModifyOriginFilterWise = toModify.clone();
                HashSet<Value> thresholds = new HashSet<Value>(ids.stream().flatMap(id -> toModify.getObjectSelection().select((Value)id, cat)).map(sid -> sf.result((Value)sid, cat)).collect(Collectors.toSet()));
                thresholds.add(new Value(-1.7976931348623157E308));
                thresholds.add(new Value((Double)Double.MAX_VALUE));
                for (Value thresh : thresholds) {
                    filterNum.setValue(thresh);
                    toModify.addToLastSelection(filterNum);
                    this.testFeaturesToAggregate(firstLevelAggregate, insts, cat, toModify, bestAggregates);
                    toModify.reinitialize(toModifyOriginFilterWise.clone());
                }
                toModify.reinitialize(toModifyOrigin.clone());
                ++i2;
            }
        }
        long tEnd = System.currentTimeMillis();
        System.out.println("One iteration in " + (double)(tEnd - tBeg) / 1000.0 + " s.");
    }

    private void testFeaturesToAggregate(AggregateFeature firstLevelAggregate, Instances insts, Catalog cat, AggregateFeature toModify, AggregatesRanking bestAggregates) {
        if (!toModify.getAggregateFunction().isNeedsFeature()) {
            toModify.setFeature(null);
            this.evaluateUpperAggregates(firstLevelAggregate, insts, cat, toModify, bestAggregates);
        } else {
            Type typeObject = toModify.getLastSelection().getTypeOut();
            ArrayList<SimpleFeature> sfs = cat.getSimpleFeatures(typeObject);
            for (SimpleFeature sf : sfs) {
                Type typeOutput = sf.getTypeOut();
                if (typeOutput.getKind() != toModify.getAggregateFunction().getKindIn()) continue;
                toModify.setFeature(sf);
                this.evaluateUpperAggregates(firstLevelAggregate, insts, cat, toModify, bestAggregates);
            }
        }
    }

    private void evaluateUpperAggregates(AggregateFeature firstLevelAggregate, Instances insts, Catalog cat, AggregateFeature toTry, AggregatesRanking bestAggregates) {
        if (firstLevelAggregate.getAggregateFunction().getKindIn() == 0) {
            ArrayList possibleValues = new ArrayList();
            for (Instance inst : insts) {
                Value val = firstLevelAggregate.result(inst.getId(), cat);
                if (possibleValues.contains(val)) continue;
                possibleValues.add(val);
            }
            HashMap<Value, Instances> decomposition = new HashMap<Value, Instances>();
            for (Value value : possibleValues) {
                decomposition.put(value, new Instances());
            }
            for (Instance instance : insts) {
                Value resForInst = firstLevelAggregate.result(instance.getId(), cat);
                ((Instances)decomposition.get(resForInst)).add(instance);
            }
            Instances instances = (Instances)decomposition.remove(new Value(null));
            NodeSplit bs = null;
            if (this.opts.mode.equals("classification")) {
                bs = SplitFinder.inferNominalSplitOnNominalTarget(firstLevelAggregate, decomposition, instances, this.opts.complexity);
            } else if (this.opts.mode.equals("regression")) {
                bs = SplitFinder.inferNominalSplitOnNumericTarget(firstLevelAggregate, decomposition, instances, this.opts.complexity);
            }
            bestAggregates.insertInto(new Couple<AggregateFeature, NodeSplit>(toTry.clone(), bs));
        } else if (firstLevelAggregate.getAggregateFunction().getKindIn() == 1) {
            HashMap<Value, Instances> decomposition = new HashMap<Value, Instances>();
            Instances noValue = new Instances();
            for (Instance instance : insts) {
                Value resForInst = firstLevelAggregate.result(instance.getId(), cat);
                if (resForInst.getStringValue() != null) {
                    if (!decomposition.containsKey(resForInst)) {
                        decomposition.put(resForInst, new Instances());
                    }
                    ((Instances)decomposition.get(resForInst)).add(instance);
                    continue;
                }
                noValue.add(instance);
            }
            TreeMap<Value, Instances> treeMap = new TreeMap<Value, Instances>(decomposition);
            Object bs = null;
            if (this.opts.mode.equals("classification")) {
                bs = SplitFinder.inferNumericSplitOnNominalTarget(firstLevelAggregate, treeMap, noValue, this.opts.complexity);
            } else if (this.opts.mode.equals("regression")) {
                bs = SplitFinder.inferNumericSplitOnNumericTarget(firstLevelAggregate, treeMap, noValue, this.opts.complexity);
            }
            Couple<AggregateFeature, Object> coupleToAdd = new Couple<AggregateFeature, Object>(toTry.clone(), bs);
            bestAggregates.insertInto(coupleToAdd);
        }
    }

    private void updateBestSplits(NodeSplit ns, ArrayList<NodeSplit> bestNodeSplits) {
        boolean cancelNow = false;
        for (CancelCriterion cancel : this.cancels) {
            boolean bl = cancelNow = cancelNow || cancel.cancelCriterion(ns);
        }
        if (!cancelNow) {
            if (bestNodeSplits.isEmpty() && ns.getScore() > this.opts.m.getMin()) {
                bestNodeSplits.add(ns);
            } else if (!bestNodeSplits.isEmpty() && ns.getScore() >= bestNodeSplits.get(0).getScore()) {
                if (ns.getScore() > bestNodeSplits.get(0).getScore()) {
                    bestNodeSplits.clear();
                }
                bestNodeSplits.add(ns);
            }
        }
    }

    private void updateBestSplitsFromAggregate(TreeMap<Double, ArrayList<Couple<AggregateFeature, NodeSplit>>> bestAggregates, ArrayList<NodeSplit> bestNodeSplits) {
        double bestScore = bestAggregates.lastKey();
        for (Couple<AggregateFeature, NodeSplit> coup : bestAggregates.get(bestScore)) {
            this.updateBestSplits(coup.getRight(), bestNodeSplits);
        }
    }

    private NodeSplit chooseBestSplit(ArrayList<NodeSplit> bestNodeSplits) {
        ArrayList<NodeSplit> candidates = new ArrayList<NodeSplit>();
        double bestScore = -1.7976931348623157E308;
        for (NodeSplit ns : bestNodeSplits) {
            if (!(ns.getScore() >= bestScore)) continue;
            if (ns.getScore() > bestScore) {
                bestScore = ns.getScore();
                candidates.clear();
            }
            candidates.add(ns);
        }
        if (candidates.isEmpty()) {
            return null;
        }
        Random r = new Random();
        return (NodeSplit)candidates.get(r.nextInt(candidates.size()));
    }
}

