/*
 * Decompiled with CFR 0.152.
 */
package model.criterion.stop;

import data.instance.Instance;
import data.instance.Instances;
import data.value.Value;
import java.util.HashMap;
import model.criterion.stop.StopCriterion;

public class ImpossiblePureLeaves
implements StopCriterion {
    private int minSize;

    public ImpossiblePureLeaves(int instPerLeaf) {
        this.minSize = instPerLeaf;
    }

    @Override
    public boolean stopCriterion(Instances insts) {
        if (insts.size() < 2 * this.minSize) {
            return true;
        }
        boolean res = false;
        HashMap<Value, Integer> counts = new HashMap<Value, Integer>();
        for (Instance inst : insts) {
            Value val = inst.getLabel();
            if (!counts.containsKey(val)) {
                counts.put(val, 0);
            }
            counts.put(val, (Integer)counts.get(val) + 1);
        }
        int countAboveNeeded = counts.size();
        for (Integer c : counts.values()) {
            if (c >= this.minSize) continue;
            --countAboveNeeded;
        }
        res = countAboveNeeded < 2;
        return res;
    }
}

