/*
 * Decompiled with CFR 0.152.
 */
package model;

import data.catalog.Catalog;
import data.instance.Instance;
import data.instance.Instances;
import data.parameter.NumericShiftFunction;
import data.value.Value;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import model.ModelOptions;
import model.tree.DecisionTree;
import model.tree.RandomForest;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import util.FileWrite;

public abstract class Model
implements Cloneable {
    protected ModelOptions opts;
    protected NumericShiftFunction shift;

    public abstract void build(Instances var1, Catalog var2);

    public abstract Value classify(Instance var1, Catalog var2);

    public String name() {
        return this.opts.name;
    }

    public abstract Model clone();

    public abstract String toString();

    public abstract HashSet<NumericShiftFunction> getParameters();

    public void addToName(String string) {
        this.opts.name = String.valueOf(this.opts.name) + string;
    }

    public void exportXML(String name) throws IOException {
        Document doc = new Document(this.toXMLElement());
        XMLOutputter xmlOutput = new XMLOutputter();
        xmlOutput.setFormat(Format.getPrettyFormat());
        xmlOutput.output(doc, (Writer)FileWrite.outputStream(name));
    }

    public abstract Element toXMLElement();

    public static Model fromXML(File file, ModelOptions opts, Catalog cat) throws JDOMException, IOException {
        SAXBuilder saxBuilder = new SAXBuilder();
        Document doc = saxBuilder.build(file);
        Element root = doc.getRootElement();
        opts.name = root.getAttributeValue("name");
        if (root.getName().equals("tree")) {
            return new DecisionTree(opts, root, cat);
        }
        if (root.getName().equals("forest")) {
            return new RandomForest(opts, root, cat);
        }
        return null;
    }

    public abstract HashMap<NumericShiftFunction, double[]> getShifts(Instances var1, Catalog var2);

    public abstract void initShifts(Instances var1, Catalog var2);

    public abstract void deployShifts(Instances var1, Catalog var2);

    public NumericShiftFunction getOutputShift() {
        return this.shift;
    }

    public abstract HashSet<NumericShiftFunction> getShifts();

    public void rebootShifts() {
        for (NumericShiftFunction sh : this.getShifts()) {
            sh.reboot();
        }
    }
}

