/*
 * Decompiled with CFR 0.152.
 */
package eval;

import data.catalog.Catalog;
import data.instance.Instance;
import data.instance.Instances;
import eval.Evaluation;
import java.io.IOException;
import java.util.Map;
import model.Model;
import util.FileWrite;

public class SimpleEvaluation
extends Evaluation {
    public SimpleEvaluation(String m) {
        super(m);
    }

    @Override
    public void evaluateModel(Model model, Instances insts, Catalog cat, boolean print) {
        for (Instance instance : insts) {
            this.predictions.put(instance, model.classify(instance, cat));
        }
        this.stats.computeStats(this.predictions);
        if (print) {
            try {
                model.exportXML(String.valueOf(model.name()) + ".xml");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            FileWrite.writeToFile(model.name(), model.toString());
            FileWrite.writeToFile(String.valueOf(model.name()) + "_eval", this.stats.toString());
            FileWrite.writeToFile(String.valueOf(model.name()) + "_predictions", "Id;Weight;Actual;Predicted\n");
            for (Map.Entry entry : this.getPredictions().entrySet()) {
                FileWrite.writeToFile(String.valueOf(model.name()) + "_predictions", ((Instance)entry.getKey()).getId() + ";" + ((Instance)entry.getKey()).getWeight() + ";" + ((Instance)entry.getKey()).getLabel() + ";" + entry.getValue() + "\n");
            }
        }
    }
}

