/*
 * Decompiled with CFR 0.152.
 */
package data.condition;

import data.catalog.Catalog;
import data.condition.FilterFeature;
import data.condition.Operator;
import data.feature.Feature;
import data.feature.SingleValueFeature;
import data.instance.Instance;
import data.parameter.NumericShiftFunction;
import data.value.Value;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Predicate;
import model.inference.ConditionApplication;
import org.jdom2.Content;
import org.jdom2.Element;

public class FilterNumericFeature
extends FilterFeature {
    private Operator operator;
    private Value value;

    public FilterNumericFeature(SingleValueFeature feat, Operator op, Value val) {
        this.feature = feat;
        this.value = val;
        this.operator = op;
    }

    public FilterNumericFeature(SingleValueFeature feat, NumericShiftFunction sh, Operator op, Value val) {
        super(sh);
        this.feature = feat;
        this.value = val;
        this.operator = op;
    }

    public FilterNumericFeature(Element condEl, Catalog cat) {
        this(Feature.fromXML(condEl.getChild("feature"), cat), Operator.getFromName(condEl.getChild("operator").getAttributeValue("type")), new Value(new Double(condEl.getChild("rhs").getChild("value").getAttributeValue("val"))));
    }

    public void setValue(Value val) {
        this.value = val;
    }

    @Override
    public FilterNumericFeature cloneCondition() {
        return new FilterNumericFeature(this.feature.clone(), this.shift.clone(), this.operator, this.value);
    }

    public void setOperator(Operator op) {
        this.operator = op;
    }

    public String toString() {
        return String.valueOf(this.feature.toString()) + " " + this.operator.toString() + " " + this.value;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public Value getValue() {
        return this.value;
    }

    @Override
    public HashMap<NumericShiftFunction, double[]> getShifts(ArrayList<Value> vals, Catalog cat) {
        HashMap<NumericShiftFunction, double[]> res = new HashMap<NumericShiftFunction, double[]>();
        res.putAll(super.getShifts(vals, cat));
        this.shift.setFeature(this.feature);
        if (!vals.isEmpty()) {
            res.put(this.shift, this.feature.range(vals, cat));
        }
        return res;
    }

    @Override
    public Predicate<Value> filter(Catalog cat) {
        return v -> {
            Value res = this.feature.result((Value)v, cat);
            return this.operator.apply(res, this.value);
        };
    }

    @Override
    public ConditionApplication apply(Instance id, Catalog cat) {
        Value mainRes = this.feature.result(id.getId(), cat);
        if (mainRes.getStringValue() == null) {
            return ConditionApplication.UNAPPLICABLE;
        }
        if (this.operator.apply(mainRes, this.value)) {
            return ConditionApplication.SUCCESS;
        }
        return ConditionApplication.FAILURE;
    }

    @Override
    public Element toXMLElement() {
        Element el = new Element("condition");
        el.setAttribute("type", "numeric");
        Element featEl = new Element("feature");
        featEl.addContent((Content)this.feature.toXMLElement());
        el.addContent((Content)featEl);
        Element opEl = new Element("operator");
        opEl.setAttribute("type", String.valueOf((Object)this.operator));
        el.addContent((Content)opEl);
        Element rhs = new Element("rhs");
        Element valEl = new Element("value");
        valEl.setAttribute("val", this.value.getStringValue());
        rhs.addContent((Content)valEl);
        el.addContent((Content)rhs);
        return el;
    }
}

