/*
 * Decompiled with CFR 0.152.
 */
package data.condition;

import data.catalog.Catalog;
import data.condition.Condition;
import data.condition.FilterFeature;
import data.parameter.NumericShiftFunction;
import data.value.Value;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.function.Predicate;
import org.jdom2.Content;
import org.jdom2.Element;

public class Conjunction
extends ArrayList<FilterFeature>
implements Condition {
    private static final long serialVersionUID = 7142363079932574155L;

    public Conjunction() {
    }

    public Conjunction(Element condEl, Catalog cat) {
        this();
        Element baseEl = condEl.getChild("bases");
        for (Element bcondEl : baseEl.getChildren("condition")) {
            this.add((FilterFeature)Condition.fromXML(bcondEl, cat));
        }
    }

    @Override
    public double complexity() {
        double res = 0.0;
        for (Condition cond : this) {
            res += cond.complexity();
        }
        return res;
    }

    @Override
    public Predicate<Value> filter(Catalog cat) {
        Predicate<Value> res = v -> true;
        for (Condition cond : this) {
            res = res.and(cond.filter(cat));
        }
        return res;
    }

    @Override
    public Conjunction cloneCondition() {
        Conjunction res = new Conjunction();
        for (FilterFeature cond : this) {
            res.add(cond.cloneCondition());
        }
        return res;
    }

    @Override
    public HashMap<NumericShiftFunction, double[]> getShifts(ArrayList<Value> vals, Catalog cat) {
        HashMap<NumericShiftFunction, double[]> shifts = new HashMap<NumericShiftFunction, double[]>();
        if (!vals.isEmpty()) {
            for (Condition cond : this) {
                shifts.putAll(cond.getShifts(vals, cat));
            }
        }
        return shifts;
    }

    @Override
    public Element toXMLElement() {
        Element el = new Element("condition");
        el.setAttribute("type", "conjunction");
        Element bases = new Element("bases");
        for (Condition cond : this) {
            bases.addContent((Content)cond.toXMLElement());
        }
        el.addContent((Content)bases);
        return el;
    }

    @Override
    public void initShifts(ArrayList<Value> vals, Catalog cat) {
        for (FilterFeature cond : this) {
            cond.initShifts(vals, cat);
        }
    }

    @Override
    public HashSet<NumericShiftFunction> getShifts() {
        HashSet<NumericShiftFunction> res = new HashSet<NumericShiftFunction>();
        for (FilterFeature cond : this) {
            res.addAll(cond.getShifts());
        }
        return res;
    }

    @Override
    public void deployShifts(ArrayList<Value> vals, Catalog cat) {
        for (FilterFeature cond : this) {
            cond.deployShifts(vals, cat);
        }
    }
}

