/*
 * Decompiled with CFR 0.152.
 */
package data.catalog;

import data.aggregate.selection.SelectionWithFilters;
import data.catalog.CatalogFile;
import data.catalog.CatalogID;
import data.catalog.CatalogIDNominal;
import data.catalog.CatalogIDNumeric;
import data.condition.FilterFeature;
import data.feature.LinkFeature;
import data.feature.SimpleFeature;
import data.value.Value;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import util.GlobalRandom;

public class CatalogLinks {
    private LinkFeature feature;
    private HashMap<Value, ArrayList<Value>> catalogById;
    private HashMap<Value, Value> permutation;
    private HashMap<Value, HashMap<SimpleFeature, CatalogID>> indexes;

    public CatalogLinks(LinkFeature bf) {
        this.feature = bf;
        this.catalogById = new HashMap();
        this.indexes = new HashMap();
        this.permutation = new HashMap();
    }

    public CatalogLinks clone() {
        CatalogLinks res = new CatalogLinks(this.feature);
        for (Map.Entry<Value, ArrayList<Value>> ent : this.catalogById.entrySet()) {
            for (Value out : ent.getValue()) {
                res.insert(ent.getKey(), out);
            }
        }
        return res;
    }

    public void insert(Value in, Value out) {
        if (!this.catalogById.containsKey(in)) {
            this.catalogById.put(in, new ArrayList());
        }
        this.catalogById.get(in).add(out);
    }

    public void createIndexes(CatalogFile cat) {
        ArrayList<SimpleFeature> sfs = cat.getSimpleFeatures(this.feature.getTypeOut());
        for (Map.Entry<Value, ArrayList<Value>> ent : this.catalogById.entrySet()) {
            HashMap<SimpleFeature, CatalogID> sortedArrays = new HashMap<SimpleFeature, CatalogID>();
            for (SimpleFeature sf : sfs) {
                if (sf.getTypeOut().getKind() == 1) {
                    CatalogIDNumeric catNom = new CatalogIDNumeric(sf);
                    for (Value rv : ent.getValue()) {
                        catNom.insert(rv, cat);
                    }
                    sortedArrays.put(sf, catNom);
                    continue;
                }
                if (sf.getTypeOut().getKind() != 0) continue;
                CatalogIDNominal catNum = new CatalogIDNominal(sf);
                for (Value rv : ent.getValue()) {
                    catNum.insert(rv, cat);
                }
                sortedArrays.put(sf, catNum);
            }
            this.indexes.put(ent.getKey(), sortedArrays);
        }
    }

    public LinkFeature getFeature() {
        return this.feature;
    }

    public HashMap<Value, ArrayList<Value>> getAllEntries() {
        return this.catalogById;
    }

    public ArrayList<Value> getEntries(Value id) {
        ArrayList res = this.catalogById.get(id);
        return res == null ? new ArrayList() : res;
    }

    public ArrayList<Value> getEntriesPermuted(Value id) {
        Value tid = this.permutation.containsKey(id) ? this.permutation.get(id) : id;
        ArrayList res = this.catalogById.get(tid);
        return res == null ? new ArrayList() : res;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Value id : this.catalogById.keySet()) {
            ArrayList<Value> entries = this.catalogById.get(id);
            for (Value out : entries) {
                sb.append(String.valueOf(this.feature.toString()) + "(" + id.getStringValue() + "," + out.getStringValue() + ").\n");
            }
        }
        return new String(sb);
    }

    public ArrayList<Value> useFilters(Value in, SelectionWithFilters swf) {
        HashSet<Value> res = new HashSet<Value>(this.getEntries(in));
        if (!res.isEmpty()) {
            HashMap<SimpleFeature, CatalogID> index = this.indexes.get(in);
            for (FilterFeature ff : swf.getFilters()) {
                if (res.isEmpty()) break;
                res.retainAll(new HashSet<Value>(index.get(ff.getFeature()).filter(ff)));
            }
        }
        return new ArrayList<Value>(res);
    }

    public void permute(ArrayList<Value> idsToPerm) {
        ArrayList<Value> perm = new ArrayList<Value>(idsToPerm);
        Collections.shuffle(perm, GlobalRandom.instance());
        int i = 0;
        while (i < idsToPerm.size()) {
            this.permutation.put(idsToPerm.get(i), perm.get(i));
            ++i;
        }
    }

    public void clearPermutation() {
        this.permutation.clear();
    }
}

