/*
 * Decompiled with CFR 0.152.
 */
package data.catalog;

import data.catalog.CatalogFile;
import data.catalog.CatalogID;
import data.condition.FilterFeature;
import data.condition.FilterInterval;
import data.feature.SimpleFeature;
import data.value.Value;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.TreeMap;

public class CatalogIDNumeric
extends CatalogID {
    private TreeMap<Value, HashSet<Value>> sortedIds = new TreeMap();

    public CatalogIDNumeric(SimpleFeature sfT) {
        super(sfT);
    }

    @Override
    public void insert(Value id, CatalogFile cat) {
        Value index = cat.getAttributeValue(this.sf, id);
        if (!this.sortedIds.containsKey(index)) {
            this.sortedIds.put(index, new HashSet());
        }
        this.sortedIds.get(index).add(id);
    }

    @Override
    public ArrayList<Value> filter(FilterFeature ff) {
        ArrayList<Value> res = new ArrayList<Value>();
        FilterInterval fi = (FilterInterval)ff;
        for (HashSet<Value> ent : this.sortedIds.subMap(fi.getValueLow(), fi.getValueHigh()).values()) {
            res.addAll(ent);
        }
        return res;
    }
}

