/*
 * Decompiled with CFR 0.152.
 */
package proper.util;

import proper.util.Cells;
import proper.util.ProperVector;
import proper.util.Strings;
import weka.classifiers.Classifier;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.filters.Filter;

public class WekaHelper {
    public static boolean setOptions(Object obj, String args) {
        if (args == null) {
            return false;
        }
        return WekaHelper.setOptions(obj, Strings.breakUp(args, " ", "\""));
    }

    public static boolean setOptions(Object obj, String[] args) {
        boolean result = false;
        if (args == null || args.length == 0) {
            return result;
        }
        if (obj == null) {
            return result;
        }
        if (!(obj instanceof OptionHandler)) {
            return result;
        }
        try {
            ((OptionHandler)obj).setOptions(args);
            result = true;
        }
        catch (Exception e) {
            System.out.println(e);
            result = false;
        }
        return result;
    }

    public static Classifier getClassifierInstance(String classname) {
        Classifier result = null;
        try {
            Class<?> cls = Class.forName(classname);
            result = (Classifier)cls.newInstance();
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return result;
    }

    public static Filter getFilterInstance(String classname) {
        Filter result = null;
        try {
            Class<?> cls = Class.forName(classname);
            result = (Filter)cls.newInstance();
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return result;
    }

    public static Cells toCells(Instances instances) {
        ProperVector names = new ProperVector();
        int i = 0;
        while (i < instances.numAttributes()) {
            names.add(instances.attribute(i).name());
            ++i;
        }
        Cells result = new Cells(instances.numInstances(), instances.numAttributes(), names);
        int n = 0;
        while (n < instances.numAttributes()) {
            Attribute att = instances.attribute(n);
            i = 0;
            while (i < instances.numInstances()) {
                Instance inst = instances.instance(i);
                if (att.isNumeric()) {
                    result.setCellAt(i, n, new Double(inst.value(n)));
                } else {
                    result.setCellAt(i, n, new String(inst.stringValue(n)));
                }
                ++i;
            }
            ++n;
        }
        return result;
    }
}

