/*
 * Decompiled with CFR 0.152.
 */
package proper.tester.engine;

import java.io.BufferedReader;
import java.io.InputStreamReader;

public class CommandLineRunner {
    private String command;
    private String output = "";
    private int exitValue;
    private boolean isExec = false;

    public CommandLineRunner(String command) {
        this.command = command;
        this.exitValue = 0;
    }

    public String getCommand() {
        return this.command;
    }

    public int getExitValue() {
        return this.exitValue;
    }

    public String getOutput() {
        return this.output;
    }

    public String getOutputLine(int l) {
        String[] tabLine = this.output.split("\n");
        return tabLine[l];
    }

    public String getOutputLine(String regex) {
        String[] tabLine = this.output.split("\n");
        String lineMatched = "";
        int i = 0;
        while (i < tabLine.length && lineMatched.equals("")) {
            if (tabLine[i].contains(regex)) {
                lineMatched = tabLine[i];
            }
            ++i;
        }
        return lineMatched;
    }

    public void run() {
        if (!this.isExec) {
            this.isExec = true;
            try {
                String x;
                Runtime r = Runtime.getRuntime();
                Process p = r.exec(this.command);
                BufferedReader r1 = new BufferedReader(new InputStreamReader(p.getInputStream()));
                while ((x = r1.readLine()) != null) {
                    this.output = String.valueOf(this.output) + x + "\n";
                }
                r1.close();
                p.waitFor();
                this.exitValue = p.exitValue();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("ERROR! \n" + e.getMessage());
            }
        }
    }

    public static void main(String[] args) {
        String cmd = "java -cp " + System.getProperty("user.dir") + "/jar/weka.jar weka.classifiers.trees.J48 -t /home/johnny/Eclipse_Project/properDecembre10/tmp/testjonathan/testjonathan-cardtest.arff -i";
        System.out.println(cmd);
        CommandLineRunner cmdWeka = new CommandLineRunner(cmd);
        cmdWeka.run();
        System.out.println(cmdWeka.getOutput());
        System.out.println(cmdWeka.getOutputLine("Correctly Classified Instances").replaceAll("\\s+", " ").split(" ")[4]);
    }
}

