/*
 * Decompiled with CFR 0.152.
 */
package proper.remote.messages;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Vector;
import proper.remote.messages.Message;
import proper.util.ProperVector;
import proper.xml.Element;

public class DataMessage
extends Message {
    public static final String DATA = "data";
    public static final String LINE = "line";

    public DataMessage() {
    }

    public DataMessage(Reader reader) {
        super(reader);
    }

    public DataMessage(Message msg) {
        super(msg);
    }

    @Override
    public boolean isOtherMessage(Message msg) {
        return this.getData() == null;
    }

    @Override
    public void clearBody() {
        super.clearBody();
        Element node = this.getBody();
        node.add(new Element(DATA));
    }

    public Element getData() {
        return this.getNode(this.getBody(), DATA);
    }

    public Vector getLines() {
        return this.getContent(this.getData(), ".//line", true);
    }

    public int getLineCount() {
        return this.getLines().size();
    }

    public String getLine(int index) {
        Vector lines = this.getLines();
        if (index >= 0 && index < lines.size()) {
            return (String)lines.get(index);
        }
        return "";
    }

    private String fixLine(String line) {
        while (line.endsWith("\r")) {
            line = line.substring(0, line.length() - 1);
        }
        while (line.endsWith("\n")) {
            line = line.substring(0, line.length() - 1);
        }
        return line;
    }

    public void setLines(Vector lines) {
        this.clearBody();
        Element node = this.getData();
        if (node != null) {
            int i = 0;
            while (i < lines.size()) {
                node.add(new Element(LINE, this.fixLine(lines.get(i).toString())));
                ++i;
            }
        }
    }

    public void setLines(String filename) {
        try {
            this.setLines(new BufferedReader(new FileReader(filename)));
        }
        catch (Exception e) {
            this.println(e);
        }
    }

    public void setLines(Reader reader) {
        ProperVector lines = new ProperVector();
        try {
            String line = "";
            boolean stored = false;
            while (reader.ready()) {
                int i = reader.read();
                if (i == -1) break;
                char c = (char)i;
                if (c == '\n') {
                    lines.add(line);
                    line = "";
                    stored = true;
                    continue;
                }
                line = String.valueOf(line) + c;
                stored = false;
            }
            if (!stored) {
                lines.add(line);
            }
        }
        catch (Exception e) {
            this.println(e);
        }
        this.setLines(lines);
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.out.println("Usage: DataMessage <filename>");
            System.exit(1);
        }
        DataMessage msg = new DataMessage();
        msg.setLines(new FileReader(args[0]));
        System.out.println("After loading file '" + args[0] + "' we get this:");
        System.out.println(msg);
        System.out.println("\nBack again:");
        Vector lines = msg.getLines();
        int i = 0;
        while (i < lines.size()) {
            System.out.println(lines.get(i));
            ++i;
        }
        System.out.println("\nNow with a StringReader:");
        msg.setLines(new StringReader("<?xml version=\"1.0\"?><message><header><header><body><data></data></body></message>"));
        System.out.println(msg);
    }
}

