/*
 * Decompiled with CFR 0.152.
 */
package proper.remote;

import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Stack;
import proper.remote.ClientList;
import proper.remote.JobServer;
import proper.remote.Processor;
import proper.remote.Server;
import proper.remote.messages.JobMessage;
import proper.util.Timer;
import proper.util.TimerInterface;

public class JobDistributor
extends Processor
implements TimerInterface {
    public static final int INTERVAL = 1000;
    private ClientList clients = this.getServer().getClientList(0);
    private ClientList available = this.getServer().getClientList(1);
    private ClientList pending = this.getServer().getClientList(2);
    private ClientList additional = this.getServer().getClientList(3);
    private Stack jobs = this.getServer().getJobs();
    private Timer timer = null;

    public JobDistributor(Server server, Socket client) {
        super(server, client);
    }

    private JobServer getServer() {
        return (JobServer)this.server;
    }

    private void sendJob() throws Exception {
        String job = (String)this.jobs.peek();
        InetSocketAddress jobAddr = this.available.pop();
        this.pending.add(jobAddr, job);
        this.jobs.pop();
        if (job.equals("")) {
            return;
        }
        JobMessage message = new JobMessage(this.createMessage("job"));
        message.setJobData(job);
        this.sender.send(jobAddr, message.toString());
        String msg = "Sent job to " + jobAddr;
        this.addToAccessLog(msg);
        this.server.println(msg);
        if (this.server.getVerbose()) {
            this.server.println(job);
        }
    }

    @Override
    protected void initialize() throws Exception {
        this.timer = new Timer(1000);
        this.timer.addListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean process() throws Exception {
        if (this.timer == null) {
            this.initialize();
        }
        JobDistributor jobDistributor = this;
        synchronized (jobDistributor) {
            while (this.getServer().isOperational()) {
                this.getServer().isSynchronizing();
                this.getServer().doDistributing();
                this.wait(1000L);
            }
        }
        this.getServer().checkClients();
        this.timer.stop();
        return true;
    }

    @Override
    public void timerEvent(Timer t) {
        this.getServer().checkClients();
        while (this.getServer().canSendJob()) {
            try {
                this.sendJob();
            }
            catch (Exception e) {
                this.server.println(e);
            }
        }
    }
}

