/*
 * Decompiled with CFR 0.152.
 */
package proper.relaggs;

import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import proper.database.Column;
import proper.database.Connector;
import proper.database.ConnectorObject;
import proper.database.Join;
import proper.relaggs.RelaggsAttribute;
import proper.relaggs.RelaggsConfig;
import proper.relaggs.RelaggsDate;
import proper.relaggs.RelaggsStructure;
import proper.relaggs.RelaggsTable;
import proper.util.Excluder;
import proper.util.TemporaryName;

public class SqlEngine
extends ConnectorObject {
    private boolean leftOuterJoin = false;
    private boolean useAnyIndex = false;
    private String useIndex = "";
    private HashSet excludedTables = new HashSet();
    private String excludedFields;
    private String targetTable = "";
    private String targetField = "";
    public static final String UNKNOWN_TYPE = "UNKNOWN";
    private int tmp_number = 1;
    private TemporaryName shortNames = new TemporaryName("t", false);

    public SqlEngine(Connector conn) {
        super(conn);
        try {
            this.getConnector().getConnection().createStatement(1004, 1008);
            this.println("Connection established.");
        }
        catch (Exception e) {
            this.println("SqlEngine.SqlEngine(): " + e);
        }
    }

    private void connect() throws Exception {
        if (!this.getConnector().isConnected()) {
            this.getConnector().connect();
        }
    }

    public void info() {
        try {
            this.connect();
            DatabaseMetaData md = this.getConnector().getConnection().getMetaData();
            this.println("DBMS: " + md.getDatabaseProductName() + " " + md.getDatabaseProductVersion());
            this.println("JDBC Driver: " + md.getDriverName() + " " + md.getDriverVersion());
            this.println("Database: " + md.getURL());
            this.println("User: " + md.getUserName());
        }
        catch (Exception e) {
            this.println("SqlEngine.info(): " + e);
        }
    }

    public void setTmpNumber(int value) {
        this.tmp_number = value;
    }

    public void incTmpNumber() {
        ++this.tmp_number;
    }

    public int getTmpNumber() {
        return this.tmp_number;
    }

    public void setLeftOuterJoin(boolean leftOuterJoin) {
        this.leftOuterJoin = leftOuterJoin;
        if (leftOuterJoin) {
            this.setUseAnyIndex(true);
        }
    }

    public boolean getLeftOuterJoin() {
        return this.leftOuterJoin;
    }

    public void setUseAnyIndex(boolean use) {
        this.useAnyIndex = use;
        if (this.getLeftOuterJoin() || !this.getUseIndex().equals("")) {
            this.useAnyIndex = true;
        }
    }

    public boolean getUseAnyIndex() {
        return this.useAnyIndex;
    }

    public void setUseForeignKeys(boolean use) {
        RelaggsConfig.dbuseforeignkeys = use;
    }

    public boolean getUseForeignKeys() {
        return RelaggsConfig.dbuseforeignkeys;
    }

    public void setUseIndex(String index) {
        this.useIndex = index;
        if (!this.useIndex.equals("")) {
            this.setUseAnyIndex(true);
        }
    }

    public String getUseIndex() {
        return this.useIndex;
    }

    public boolean indexMatches(String index) {
        return this.getUseIndex().equals("") || this.getUseIndex().equals(index);
    }

    public void setTargetTable(String targetTable) {
        this.targetTable = targetTable;
    }

    public String getTargetTable() {
        return this.targetTable;
    }

    public void setTargetField(String targetField) {
        this.targetField = targetField;
    }

    public String getTargetField() {
        return this.targetField;
    }

    public void setExcludedTables(String tables) {
        this.excludedTables.clear();
        StringTokenizer tok = new StringTokenizer(tables, ",");
        while (tok.hasMoreTokens()) {
            this.excludedTables.add(tok.nextToken().toLowerCase());
        }
    }

    public void setExcludedFields(String stringParameter) {
        this.excludedFields = stringParameter;
    }

    public int getMaxColumnCount() {
        int result = -1;
        try {
            this.connect();
            DatabaseMetaData meta = this.getConnector().getConnection().getMetaData();
            result = meta.getMaxColumnsInTable();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.println(e);
            result = -1;
        }
        return result;
    }

    public void setColumns(RelaggsTable table) {
        try {
            this.connect();
            DatabaseMetaData meta = this.getConnector().getConnection().getMetaData();
            ResultSet rs = meta.getColumns(null, null, table.getName(), null);
            table.getColumns().clear();
            while (rs.next()) {
                table.getColumns().add(rs.getString("COLUMN_NAME").toLowerCase());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.println(e);
        }
    }

    public String getLimit() {
        return RelaggsConfig.dblimit;
    }

    public String getLimit(int rows) {
        return RelaggsConfig.dblimit.replaceAll(RelaggsConfig.dblimit_rows, Integer.toString(rows));
    }

    public Vector getDatabases() {
        Vector<String> tmp = new Vector<String>();
        try {
            this.connect();
            DatabaseMetaData md = this.getConnector().getConnection().getMetaData();
            ResultSet rs = md.getCatalogs();
            while (rs.next()) {
                String value = rs.getString("TABLE_CAT");
                if (value == null) continue;
                tmp.add(value);
            }
        }
        catch (Exception e) {
            this.println("SqlEngine.getDatabases(): " + e);
        }
        return tmp;
    }

    public Vector getTables() {
        Vector<String> tmp = new Vector<String>();
        try {
            this.connect();
            DatabaseMetaData md = this.getConnector().getConnection().getMetaData();
            ResultSet rs = md.getTables(null, null, "%", new String[]{"TABLE"});
            while (rs.next()) {
                String value = rs.getString("TABLE_NAME");
                if (value == null || this.excludedTables.contains(value.trim().toLowerCase())) continue;
                tmp.add(value.trim());
            }
        }
        catch (Exception e) {
            this.println("SqlEngine.getTables(): " + e);
        }
        return tmp;
    }

    public Vector getPrimaryKeys(String table) {
        try {
            this.connect();
            DatabaseMetaData md = this.getConnector().getConnection().getMetaData();
            ResultSet rs = !this.getUseAnyIndex() ? md.getPrimaryKeys(null, null, table) : md.getIndexInfo(null, null, table, false, false);
            Vector<String> primary_keys = new Vector<String>();
            while (rs.next()) {
                String value = rs.getString("COLUMN_NAME");
                if (value == null || !this.indexMatches(value)) continue;
                primary_keys.add(value);
            }
            return primary_keys;
        }
        catch (Exception e) {
            this.println("SqlEngine.getPrimaryKeys(): " + e);
            return null;
        }
    }

    public RelaggsTable getTable(String name) {
        RelaggsTable table = new RelaggsTable(name);
        table.setMaxColumns(this.getMaxColumnCount());
        this.setColumns(table);
        table.setShortName(this.shortNames.next());
        try {
            this.connect();
            DatabaseMetaData md = this.getConnector().getConnection().getMetaData();
            ResultSet rs_attr = md.getColumns(null, null, table.getName(), "%");
            while (rs_attr.next()) {
                String val_attr_name = rs_attr.getString("COLUMN_NAME");
                String val_attr_type = rs_attr.getString("TYPE_NAME");
                String val_attr_jdbc = Integer.toString(rs_attr.getInt("DATA_TYPE"));
                int val_attr_size = rs_attr.getInt("COLUMN_SIZE");
                if (val_attr_name == null) continue;
                if (SqlEngine.getTypeString(Integer.parseInt(val_attr_jdbc), val_attr_size).equals(UNKNOWN_TYPE)) {
                    this.println("Ignored: " + table.getName() + "." + val_attr_name + " (" + val_attr_type + "/" + val_attr_size + " cannot be processed!)");
                    continue;
                }
                if (this.excludedFields != null) {
                    Excluder excluder = new Excluder(this.excludedFields);
                    if (excluder.contains(String.valueOf(table.getName()) + "." + val_attr_name)) continue;
                    table.addAttribute(new RelaggsAttribute(val_attr_name, val_attr_jdbc, val_attr_type, val_attr_size));
                    continue;
                }
                table.addAttribute(new RelaggsAttribute(val_attr_name, val_attr_jdbc, val_attr_type, val_attr_size));
            }
            ResultSet rs_primkeys = !this.getUseAnyIndex() ? md.getPrimaryKeys(null, null, table.getName()) : md.getIndexInfo(null, null, table.getName(), false, false);
            while (rs_primkeys.next()) {
                String val_prim = rs_primkeys.getString("COLUMN_NAME");
                if (val_prim == null || !this.indexMatches(val_prim)) continue;
                table.addPrimaryKey(val_prim);
            }
            ResultSet rs_foreignkeys = this.getConnector().getConnection().getMetaData().getImportedKeys(null, null, name);
            while (rs_foreignkeys.next()) {
                table.addForeignKey2(rs_foreignkeys.getString("FKCOLUMN_NAME"), rs_foreignkeys.getString("PKCOLUMN_NAME"));
            }
            ResultSet rs_rows = this.getConnector().getConnection().createStatement(1004, 1008).executeQuery("SELECT COUNT(*) AS number FROM " + name);
            if (rs_rows.next()) {
                table.setRowNumber(rs_rows.getInt("number"));
            }
        }
        catch (Exception e) {
            this.println(e);
        }
        return table;
    }

    public static String getTypeString(int type, int size) {
        Column col = new Column("dummy", type, size);
        String result = col.isBlob() ? UNKNOWN_TYPE : (type == 1 ? "CHAR(" + size + ")" : (type == 12 ? "VARCHAR(" + size + ")" : (col.isInteger() ? "INT" : (col.isDecimal() ? (type == 8 ? "double precision" : (type == 7 ? "REAL" : (type == 6 ? "FLOAT" : "NUMERIC"))) : (type == 91 ? "DATE" : (type == 92 ? "TIME" : (type == 93 ? "TIMESTAMP" : UNKNOWN_TYPE)))))));
        return result;
    }

    public String getTableCreateFromSelect(String table, String sql) throws Exception {
        this.connect();
        Statement st = this.getConnector().getConnection().createStatement(1004, 1008);
        sql = String.valueOf(sql) + " " + this.getLimit(1);
        if (!st.execute(sql)) {
            throw new Exception("Error executing: " + sql);
        }
        ResultSet rs = st.getResultSet();
        ResultSetMetaData meta = rs.getMetaData();
        String result = "CREATE TABLE " + table + " (";
        int ColumnDisplaySize = 20;
        int i = 1;
        while (i <= meta.getColumnCount()) {
            String typeStr;
            if (i > 1) {
                result = String.valueOf(result) + ", ";
            }
            result = String.valueOf(result) + meta.getColumnName(i) + " ";
            if (meta.getColumnDisplaySize(i) > 0) {
                ColumnDisplaySize = meta.getColumnDisplaySize(i);
            }
            result = !(typeStr = SqlEngine.getTypeString(meta.getColumnType(i), ColumnDisplaySize)).equals(UNKNOWN_TYPE) ? String.valueOf(result) + typeStr : String.valueOf(result) + meta.getColumnTypeName(i);
            ++i;
        }
        result = String.valueOf(result) + ")";
        return result;
    }

    public String aggregateAttributes(RelaggsTable main, RelaggsTable aggr, Join join, String tableTmpName, int number) {
        String table_name = tableTmpName;
        table_name = String.valueOf(table_name) + number;
        String sql = "";
        try {
            RelaggsAttribute attr;
            this.println("NEW TABLE: '" + table_name + "' for main='" + main.getName() + "' and aggr='" + aggr.getName() + "'" + " via '" + join.toStringJoin() + "'");
            this.connect();
            Statement stat = this.getConnector().getConnection().createStatement(1004, 1008);
            String select_str = "SELECT ";
            Enumeration enm = main.getAttributes();
            int i = 0;
            while (enm.hasMoreElements()) {
                if (i != 0) {
                    select_str = String.valueOf(select_str) + ", ";
                }
                attr = (RelaggsAttribute)enm.nextElement();
                select_str = String.valueOf(select_str) + main.getName() + "." + attr.getName();
                ++i;
            }
            enm = aggr.getAttributes();
            while (enm.hasMoreElements()) {
                attr = (RelaggsAttribute)enm.nextElement();
                if (main.isPrimaryKey(attr.getName()) || aggr.isPrimaryKey(attr.getName())) continue;
                if (i != 0) {
                    select_str = String.valueOf(select_str) + ", ";
                }
                select_str = attr.getName().equals(this.getTargetField()) ? String.valueOf(select_str) + aggr.getName() + "." + attr.getName() : String.valueOf(select_str) + attr.getAggregateFunctions(aggr.getName(), aggr.getShortName(), aggr.isPrimaryKey(attr.getName()));
                ++i;
            }
            select_str = this.getLeftOuterJoin() ? String.valueOf(select_str) + " FROM " + main.getName() + " LEFT OUTER JOIN " + aggr.getName() : String.valueOf(select_str) + " FROM " + main.getName() + ", " + aggr.getName();
            select_str = this.getLeftOuterJoin() ? String.valueOf(select_str) + " ON " : String.valueOf(select_str) + " WHERE ";
            select_str = String.valueOf(select_str) + join.getRight() + " = " + join.getLeft();
            enm = main.getAttributes();
            i = 0;
            String gr_by = "";
            while (enm.hasMoreElements()) {
                attr = (RelaggsAttribute)enm.nextElement();
                if (i != 0) {
                    gr_by = String.valueOf(gr_by) + ", ";
                }
                gr_by = String.valueOf(gr_by) + main.getName() + "." + attr.getName();
                ++i;
            }
            select_str = String.valueOf(select_str) + " GROUP BY " + gr_by;
            this.println("QUERY: '" + select_str + "'");
            this.println("Execute create table ...");
            sql = select_str;
            sql = this.getTableCreateFromSelect(table_name, select_str);
            stat.executeUpdate(sql);
            this.println("Execute create table finished.");
            this.println("Inserting into table ...");
            sql = "INSERT INTO " + table_name + " " + select_str;
            stat.executeUpdate(sql);
            this.println("Inserting into table finished.");
            sql = this.getUseAnyIndex() ? "CREATE INDEX " + table_name : "CREATE UNIQUE INDEX " + table_name;
            enm = main.getPrimaryKeys();
            while (enm.hasMoreElements()) {
                attr = (RelaggsAttribute)enm.nextElement();
                sql = String.valueOf(sql) + "_" + attr.getName();
            }
            sql = String.valueOf(sql) + " ON " + table_name + " (";
            enm = main.getPrimaryKeys();
            i = 0;
            while (enm.hasMoreElements()) {
                attr = (RelaggsAttribute)enm.nextElement();
                if (i != 0) {
                    sql = String.valueOf(sql) + ", ";
                }
                sql = String.valueOf(sql) + attr.getName();
                ++i;
            }
            sql = String.valueOf(sql) + ")";
            this.println("Adding index...");
            stat.executeUpdate(sql);
            this.println("Adding index finished.");
            this.setColumns(main);
            this.setColumns(aggr);
        }
        catch (Exception e) {
            this.println("SqlEngine.aggregateAttributes():\n" + sql + "\n" + e);
        }
        return table_name;
    }

    public static String getStddev(String colName) {
        String result = "STDDEV(" + colName + ")";
        return result;
    }

    public RelaggsStructure getAttributes(RelaggsTable table, RelaggsAttribute attribute) throws IllegalArgumentException {
        String sql = "";
        String coltype = "";
        String gbtype = "";
        try {
            sql = "SELECT ";
            Enumeration enm = table.getAttributes();
            int cnt = 0;
            Vector<RelaggsAttribute> sql_attr = new Vector<RelaggsAttribute>();
            sql = String.valueOf(sql) + attribute.getName();
            while (enm.hasMoreElements()) {
                RelaggsAttribute attr = (RelaggsAttribute)enm.nextElement();
                if (table.isPrimaryKey(attr.getName()) || table.isForeignKey(attr.getName()) || table.getName().equals(this.getTargetTable()) || attr.getName().equals(this.getTargetField())) continue;
                sql = String.valueOf(sql) + ", " + attr.getName();
                sql_attr.add(attr);
                ++cnt;
            }
            sql = String.valueOf(sql) + " FROM " + table.getName() + " ORDER BY " + attribute.getName();
            this.println("QUERY: " + sql);
            RelaggsStructure struct = new RelaggsStructure(this.getConnector());
            int i = 0;
            while (i < cnt) {
                RelaggsAttribute col = (RelaggsAttribute)sql_attr.get(i);
                struct.addAttribute(col);
                ++i;
            }
            this.connect();
            Statement stat = this.getConnector().getConnection().createStatement(1004, 1008);
            this.println("Execute query ...");
            ResultSet rs = stat.executeQuery(sql);
            this.println("Execute query finished.");
            int c = 0;
            while (rs.next()) {
                struct.addRecord();
                if (++c % 1000 == 0) {
                    this.println("Record: " + c);
                }
                int i2 = 0;
                while (i2 < cnt) {
                    RelaggsAttribute col = (RelaggsAttribute)sql_attr.get(i2);
                    switch (col.getType()) {
                        case 1: {
                            struct.addAttributeValue(col, rs.getInt(i2 + 2), rs.getObject(1));
                            break;
                        }
                        case 3: {
                            struct.addAttributeValue(col, rs.getString(i2 + 2), rs.getObject(1));
                            break;
                        }
                        case 5: {
                            struct.addAttributeValue(col, rs.getDate(i2 + 2), rs.getObject(1));
                            break;
                        }
                    }
                    ++i2;
                }
            }
            this.println("Get group attributes ...");
            Hashtable gb_attributes = struct.getGroupByAttributes();
            this.println("Get group attributes finished.");
            if (gb_attributes.size() > 0) {
                rs.beforeFirst();
                c = 0;
                switch (attribute.getType()) {
                    case 1: {
                        while (rs.next()) {
                            if (++c % 2000 == 0) {
                                this.println("GB - Record: " + c);
                            }
                            int i3 = 0;
                            while (i3 < cnt) {
                                RelaggsAttribute col = (RelaggsAttribute)sql_attr.get(i3);
                                if (struct.isAggregationValid(col)) {
                                    Enumeration enum_gb = gb_attributes.keys();
                                    block44: while (enum_gb.hasMoreElements()) {
                                        RelaggsAttribute gb_attr = (RelaggsAttribute)enum_gb.nextElement();
                                        if (col.equals(gb_attr)) continue;
                                        block9 : switch (col.getType()) {
                                            case 3: {
                                                RelaggsDate gb_value;
                                                Vector date_vec;
                                                coltype = "char";
                                                switch (gb_attr.getType()) {
                                                    case 1: {
                                                        gbtype = "int";
                                                        struct.addAttributeValueGroupBy(col, gb_attr, (Object)new Integer(rs.getInt(gb_attr.getName())), rs.getString(col.getName()), rs.getObject(1));
                                                        break;
                                                    }
                                                    case 3: {
                                                        gbtype = "char";
                                                        struct.addAttributeValueGroupBy(col, gb_attr, (Object)rs.getString(gb_attr.getName()), rs.getString(col.getName()), rs.getObject(1));
                                                        break;
                                                    }
                                                    case 5: {
                                                        gbtype = "date";
                                                        date_vec = (Vector)gb_attributes.get(gb_attr);
                                                        for (String date_str : date_vec) {
                                                            gb_value = null;
                                                            if (date_str.equals("YMD")) {
                                                                gb_value = new RelaggsDate(rs.getDate(gb_attr.getName()), 1);
                                                            } else if (date_str.equals("YM")) {
                                                                gb_value = new RelaggsDate(rs.getDate(gb_attr.getName()), 2);
                                                            } else if (date_str.equals("Y")) {
                                                                gb_value = new RelaggsDate(rs.getDate(gb_attr.getName()), 3);
                                                            }
                                                            struct.addAttributeValueGroupBy(col, gb_attr, (Object)gb_value, rs.getString(col.getName()), rs.getObject(1));
                                                        }
                                                        break;
                                                    }
                                                }
                                                continue block44;
                                            }
                                            case 1: {
                                                RelaggsDate gb_value;
                                                Vector date_vec;
                                                coltype = "int";
                                                switch (gb_attr.getType()) {
                                                    case 1: {
                                                        gbtype = "int";
                                                        struct.addAttributeValueGroupBy(col, gb_attr, new Integer(rs.getInt(gb_attr.getName())), new Integer(rs.getInt(col.getName())), "VALUES", rs.getObject(1));
                                                        break;
                                                    }
                                                    case 3: {
                                                        gbtype = "char";
                                                        struct.addAttributeValueGroupBy(col, gb_attr, rs.getString(gb_attr.getName()), new Integer(rs.getInt(col.getName())), "VALUES", rs.getObject(1));
                                                        break;
                                                    }
                                                    case 5: {
                                                        gbtype = "date";
                                                        date_vec = (Vector)gb_attributes.get(gb_attr);
                                                        for (String date_str : date_vec) {
                                                            gb_value = null;
                                                            if (date_str.equals("YMD")) {
                                                                gb_value = new RelaggsDate(rs.getDate(gb_attr.getName()), 1);
                                                            } else if (date_str.equals("YM")) {
                                                                gb_value = new RelaggsDate(rs.getDate(gb_attr.getName()), 2);
                                                            } else if (date_str.equals("Y")) {
                                                                gb_value = new RelaggsDate(rs.getDate(gb_attr.getName()), 3);
                                                            }
                                                            struct.addAttributeValueGroupBy(col, gb_attr, gb_value, new Integer(rs.getInt(col.getName())), "VALUES", rs.getObject(1));
                                                        }
                                                        break;
                                                    }
                                                }
                                                continue block44;
                                            }
                                            case 5: {
                                                RelaggsDate gb_value;
                                                Vector date_vec;
                                                coltype = "date";
                                                switch (gb_attr.getType()) {
                                                    case 1: {
                                                        gbtype = "int";
                                                        struct.addAttributeValueGroupBy(col, gb_attr, (Object)new Integer(rs.getInt(gb_attr.getName())), rs.getDate(col.getName()), rs.getObject(1));
                                                        break block9;
                                                    }
                                                    case 3: {
                                                        gbtype = "char";
                                                        struct.addAttributeValueGroupBy(col, gb_attr, (Object)rs.getString(gb_attr.getName()), rs.getDate(col.getName()), rs.getObject(1));
                                                        break block9;
                                                    }
                                                    case 5: {
                                                        gbtype = "date";
                                                        date_vec = (Vector)gb_attributes.get(gb_attr);
                                                        for (String date_str : date_vec) {
                                                            gb_value = null;
                                                            if (date_str.equals("YMD")) {
                                                                gb_value = new RelaggsDate(rs.getDate(gb_attr.getName()), 1);
                                                            } else if (date_str.equals("YM")) {
                                                                gb_value = new RelaggsDate(rs.getDate(gb_attr.getName()), 2);
                                                            } else if (date_str.equals("Y")) {
                                                                gb_value = new RelaggsDate(rs.getDate(gb_attr.getName()), 3);
                                                            }
                                                            struct.addAttributeValueGroupBy(col, gb_attr, (Object)gb_value, rs.getDate(col.getName()), rs.getObject(1));
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                                ++i3;
                            }
                        }
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Key must be INT.");
                    }
                }
                coltype = "";
                gbtype = "";
                Enumeration enum_gb = gb_attributes.keys();
                block48: while (enum_gb.hasMoreElements()) {
                    RelaggsAttribute gb_attr = (RelaggsAttribute)enum_gb.nextElement();
                    sql_attr = new Vector();
                    switch (gb_attr.getType()) {
                        case 1: 
                        case 3: {
                            sql = "SELECT " + attribute.getName() + ", " + gb_attr.getName();
                            enm = table.getAttributes();
                            while (enm.hasMoreElements()) {
                                RelaggsAttribute attr = (RelaggsAttribute)enm.nextElement();
                                if (table.isPrimaryKey(attr.getName()) || table.isForeignKey(attr.getName()) || attr.getType() != 1 || attr.equals(gb_attr)) continue;
                                sql = String.valueOf(sql) + ", COUNT(DISTINCT " + attr.getName() + ") AS " + attr.getName() + "_CNT_VAL, " + "SUM(" + attr.getName() + ") AS " + attr.getName() + "_SUM, " + "AVG(" + attr.getName() + ") AS " + attr.getName() + "_AVG, " + "MIN(" + attr.getName() + ") AS " + attr.getName() + "_MIN, " + "MAX(" + attr.getName() + ") AS " + attr.getName() + "_MAX, " + SqlEngine.getStddev(attr.getName()) + " AS " + attr.getName() + "_STDDEV";
                                sql_attr.add(attr);
                            }
                            sql = String.valueOf(sql) + " FROM " + table.getName() + " GROUP BY " + attribute.getName() + ", " + gb_attr.getName();
                            if (sql_attr.size() <= 0) break;
                            this.connect();
                            stat = this.getConnector().getConnection().createStatement(1004, 1008);
                            this.println("Execute group by query for " + gb_attr.getName() + " ...");
                            rs = stat.executeQuery(sql);
                            this.println("Execute query finished.");
                            c = 0;
                            while (rs.next()) {
                                for (RelaggsAttribute attr : sql_attr) {
                                    Object gb_value = null;
                                    switch (gb_attr.getType()) {
                                        case 3: {
                                            gb_value = rs.getString(gb_attr.getName());
                                            break;
                                        }
                                        case 1: {
                                            gb_value = new Integer(rs.getInt(gb_attr.getName()));
                                        }
                                    }
                                    struct.addAttributeValueGroupBy(attr, gb_attr, gb_value, new Integer(rs.getInt(String.valueOf(attr.getName()) + "_CNT_VAL")), "CNT_VAL", rs.getObject(attribute.getName()));
                                    struct.addAttributeValueGroupBy(attr, gb_attr, gb_value, new Integer(rs.getInt(String.valueOf(attr.getName()) + "_SUM")), "SUM", rs.getObject(attribute.getName()));
                                    struct.addAttributeValueGroupBy(attr, gb_attr, gb_value, new Double(rs.getDouble(String.valueOf(attr.getName()) + "_AVG")), "AVG", rs.getObject(attribute.getName()));
                                    struct.addAttributeValueGroupBy(attr, gb_attr, gb_value, new Integer(rs.getInt(String.valueOf(attr.getName()) + "_MIN")), "MIN", rs.getObject(attribute.getName()));
                                    struct.addAttributeValueGroupBy(attr, gb_attr, gb_value, new Integer(rs.getInt(String.valueOf(attr.getName()) + "_MAX")), "MAX", rs.getObject(attribute.getName()));
                                    struct.addAttributeValueGroupBy(attr, gb_attr, gb_value, new Double(rs.getDouble(String.valueOf(attr.getName()) + "_STDDEV")), "STDDEV", rs.getObject(attribute.getName()));
                                }
                                ++c;
                            }
                            continue block48;
                        }
                        case 5: {
                            Vector date_vec = (Vector)gb_attributes.get(gb_attr);
                            for (String date_str : date_vec) {
                                sql = "SELECT " + attribute.getName() + ", " + gb_attr.getName();
                                enm = table.getAttributes();
                                while (enm.hasMoreElements()) {
                                    RelaggsAttribute attr = (RelaggsAttribute)enm.nextElement();
                                    if (table.isPrimaryKey(attr.getName()) || table.isForeignKey(attr.getName()) || attr.getType() != 1 || attr.equals(gb_attr)) continue;
                                    sql = String.valueOf(sql) + ", COUNT(DISTINCT " + attr.getName() + ") AS " + attr.getName() + "_CNT_VAL, " + "SUM(" + attr.getName() + ") AS " + attr.getName() + "_SUM, " + "AVG(" + attr.getName() + ") AS " + attr.getName() + "_AVG, " + "MIN(" + attr.getName() + ") AS " + attr.getName() + "_MIN, " + "MAX(" + attr.getName() + ") AS " + attr.getName() + "_MAX, " + SqlEngine.getStddev(attr.getName()) + " AS " + attr.getName() + "_STDDEV";
                                    sql_attr.add(attr);
                                }
                                sql = String.valueOf(sql) + " FROM " + table.getName() + " GROUP BY " + attribute.getName() + ", ";
                                if (date_str.equals("YMD")) {
                                    sql = String.valueOf(sql) + gb_attr.getName();
                                } else if (date_str.equals("YM")) {
                                    sql = String.valueOf(sql) + "EXTRACT(YEAR_MONTH FROM " + gb_attr.getName() + ")";
                                } else if (date_str.equals("Y")) {
                                    sql = String.valueOf(sql) + "YEAR(" + gb_attr.getName() + ")";
                                }
                                if (sql_attr.size() <= 0) continue;
                                this.connect();
                                stat = this.getConnector().getConnection().createStatement(1004, 1008);
                                this.println("Execute group by query for " + gb_attr.getName() + " [" + date_str + "] ...");
                                rs = stat.executeQuery(sql);
                                this.println("Execute query finished.");
                                c = 0;
                                int date_type = 0;
                                if (date_str.equals("YMD")) {
                                    date_type = 1;
                                } else if (date_str.equals("YM")) {
                                    date_type = 2;
                                } else if (date_str.equals("Y")) {
                                    date_type = 3;
                                }
                                while (rs.next()) {
                                    for (RelaggsAttribute attr : sql_attr) {
                                        RelaggsDate gb_value = new RelaggsDate(rs.getDate(gb_attr.getName()), date_type);
                                        struct.addAttributeValueGroupBy(attr, gb_attr, gb_value, new Integer(rs.getInt(String.valueOf(attr.getName()) + "_CNT_VAL")), "CNT_VAL", rs.getObject(attribute.getName()));
                                        struct.addAttributeValueGroupBy(attr, gb_attr, gb_value, new Integer(rs.getInt(String.valueOf(attr.getName()) + "_SUM")), "SUM", rs.getObject(attribute.getName()));
                                        struct.addAttributeValueGroupBy(attr, gb_attr, gb_value, new Double(rs.getDouble(String.valueOf(attr.getName()) + "_AVG")), "AVG", rs.getObject(attribute.getName()));
                                        struct.addAttributeValueGroupBy(attr, gb_attr, gb_value, new Integer(rs.getInt(String.valueOf(attr.getName()) + "_MIN")), "MIN", rs.getObject(attribute.getName()));
                                        struct.addAttributeValueGroupBy(attr, gb_attr, gb_value, new Integer(rs.getInt(String.valueOf(attr.getName()) + "_MAX")), "MAX", rs.getObject(attribute.getName()));
                                        struct.addAttributeValueGroupBy(attr, gb_attr, gb_value, new Double(rs.getDouble(String.valueOf(attr.getName()) + "_STDDEV")), "STDDEV", rs.getObject(attribute.getName()));
                                    }
                                    ++c;
                                }
                            }
                            continue block48;
                        }
                    }
                }
            }
            this.println("Process attributes ...");
            struct.processAttributes();
            this.println("Process attributes finished.");
            return struct;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            this.println("getAttributes: Query: '" + sql + "'");
            this.println("getAttributes: " + exc);
            this.println("additional parametrs: \ncoltype = " + coltype + "\n" + "gbtype  = " + gbtype);
            return null;
        }
    }

    public void addAggregatedAttributes(RelaggsTable dest_table, RelaggsTable source_table, RelaggsStructure struct, Join join) {
        String sql = "";
        try {
            this.setColumns(source_table);
            this.setColumns(dest_table);
            struct.getColumns().clear();
            struct.getColumns().addAll(source_table.getColumns());
            struct.getColumns().addAll(dest_table.getColumns());
            String alter_cols = struct.getAlterTableColumns(source_table);
            if (alter_cols.length() != 0) {
                this.connect();
                Statement stat = this.getConnector().getConnection().createStatement(1004, 1008);
                this.println("Execute alter table ...");
                StringTokenizer tok = new StringTokenizer(alter_cols, ",");
                int colCount = tok.countTokens();
                int cnt = 0;
                while (tok.hasMoreTokens()) {
                    if (++cnt > 0 && cnt % 10 == 0) {
                        this.println(" adding column: " + cnt + "/" + colCount);
                    }
                    String token = tok.nextToken().trim();
                    String column = token.substring(0, token.indexOf(" "));
                    String columnType = token.replaceAll(" DEFAULT .*", "").trim();
                    String defaultValue = token.substring(token.lastIndexOf(" "), token.length());
                    sql = "ALTER TABLE " + dest_table.getName() + " ADD COLUMN " + columnType;
                    stat.executeUpdate(sql);
                    if (token.toUpperCase().indexOf(" DEFAULT ") <= -1) continue;
                    sql = "UPDATE " + dest_table.getName() + " SET " + column + " = " + defaultValue;
                    stat.executeUpdate(sql);
                    sql = "ALTER TABLE " + dest_table.getName() + " ALTER COLUMN " + column + " SET DEFAULT " + defaultValue;
                    stat.executeUpdate(sql);
                }
                this.println("Execute alter table finished.");
                Enumeration enum_keys = struct.getKeyValues();
                this.println("Execute update table ...");
                cnt = 0;
                while (enum_keys.hasMoreElements()) {
                    Object key = enum_keys.nextElement();
                    PreparedStatement ps = struct.getUpdateQuery(key, source_table, dest_table, join);
                    if (ps == null) continue;
                    if (++cnt % 200 == 0) {
                        this.println("  Updated Records: " + cnt);
                    }
                    ps.executeUpdate();
                }
                this.println("Execute update table finished.");
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
            this.println("addAggregatedAttributes: \n" + sql + "\n" + exc);
        }
        this.setColumns(dest_table);
    }

    public void dropTable(String table) {
        String sql = "DROP TABLE " + table;
        try {
            this.connect();
            Statement stat = this.getConnector().getConnection().createStatement(1004, 1008);
            this.println("Execute drop table (" + sql + ") ...");
            stat.executeUpdate(sql);
            this.println("Execute drop table finished.");
        }
        catch (Exception exc) {
            this.println("dropTable: " + exc);
        }
    }

    public void renameTable(String old_name, String new_name) {
        String sql = "ALTER TABLE " + old_name + " RENAME TO " + new_name;
        try {
            this.connect();
            Statement stat = this.getConnector().getConnection().createStatement(1004, 1008);
            this.println("Execute rename table (" + sql + ") ...");
            stat.executeUpdate(sql);
            this.println("Execute rename table finished.");
        }
        catch (Exception exc) {
            this.println("renameTable: " + exc);
        }
    }
}

