/*
 * Decompiled with CFR 0.152.
 */
package proper.imp;

import proper.imp.Parser;

public class PrologParser
extends Parser {
    @Override
    protected String nextClause() throws Exception {
        if (!this.reader.ready()) {
            return null;
        }
        super.nextClause();
        boolean finished = false;
        boolean isString = false;
        boolean isComment = false;
        int parenCount = 0;
        int brackCount = 0;
        String current = "";
        this.pos = -1;
        while (this.reader.ready() && !finished) {
            int i = this.reader.read();
            char c = (char)i;
            if (i == -1) {
                finished = true;
                continue;
            }
            boolean add = true;
            ++this.pos;
            switch (c) {
                case '(': {
                    if (isString) break;
                    ++parenCount;
                    break;
                }
                case ')': {
                    if (isString) break;
                    --parenCount;
                    break;
                }
                case '[': {
                    if (isString) break;
                    ++brackCount;
                    break;
                }
                case ']': {
                    if (isString) break;
                    --brackCount;
                    break;
                }
                case '%': {
                    if (isString) break;
                    isComment = true;
                    break;
                }
                case '\'': {
                    isString = !isString;
                    break;
                }
                case '\n': {
                    ++this.line;
                    if (isComment) {
                        isComment = false;
                        finished = true;
                    }
                }
                case '\t': 
                case '\f': 
                case '\r': 
                case ' ': {
                    if (isString || isComment) break;
                    add = false;
                    break;
                }
                case '.': {
                    if (isString || isComment || parenCount != 0) break;
                    if (parenCount == 0 && brackCount == 0) {
                        finished = true;
                        break;
                    }
                    throw new Exception("Malformed Prolog fact!");
                }
            }
            if (!add) continue;
            current = String.valueOf(current) + c;
        }
        return current;
    }

    @Override
    protected void parseClause(String clause) {
        if (clause.startsWith("%") || clause.startsWith("!") || clause.indexOf(":-dynamic") == 0) {
            if (this.getVerbose()) {
                this.println("Ignored: " + clause);
            }
            return;
        }
        clause = clause.replaceAll("''", "`");
        boolean finished = false;
        boolean isString = false;
        int parenCount = 0;
        int brackCount = 0;
        String str = "";
        this.current.clear();
        this.setIsNot(false);
        int i = 0;
        while (i < clause.length()) {
            char c = clause.charAt(i);
            int cNext = i < clause.length() - 1 ? (int)clause.charAt(i + 1) : 32;
            boolean add = true;
            switch (c) {
                case '(': {
                    if (isString) break;
                    this.newPredicate(str);
                    if (this.getVerbose()) {
                        this.print(String.valueOf(str) + "(");
                    }
                    ++parenCount;
                    add = false;
                    str = "";
                    break;
                }
                case ')': {
                    if (isString) break;
                    this.add(str, true);
                    this.removeCurrent();
                    if (this.getVerbose()) {
                        this.print(")");
                    }
                    --parenCount;
                    add = false;
                    str = "";
                    break;
                }
                case '[': {
                    if (isString) break;
                    this.newList();
                    if (this.getVerbose()) {
                        this.print("[");
                    }
                    ++brackCount;
                    add = false;
                    break;
                }
                case ']': {
                    if (isString) break;
                    this.add(str, true);
                    this.removeCurrent();
                    if (this.getVerbose()) {
                        this.print("]");
                    }
                    --brackCount;
                    add = false;
                    str = "";
                    break;
                }
                case '\'': {
                    if (isString) {
                        str = String.valueOf(str) + c;
                        this.add(str);
                        if (this.getVerbose()) {
                            this.print(str);
                        }
                        str = "";
                        add = false;
                    }
                    isString = !isString;
                    break;
                }
                case ',': {
                    if (isString) break;
                    this.add(str, true);
                    if (this.getVerbose()) {
                        this.print(",");
                    }
                    add = false;
                    str = "";
                    break;
                }
                case '.': {
                    if (isString || parenCount != 0) break;
                    this.addPredicate();
                    this.removeCurrent();
                    if (this.getVerbose()) {
                        this.println(".");
                    }
                    this.setIsNot(false);
                    add = false;
                }
            }
            if (add) {
                str = String.valueOf(str) + c;
            }
            if (str.equals(":-")) {
                str = "";
                this.setIsNot(true);
            }
            ++i;
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 0) {
            PrologParser s = new PrologParser();
            s.setVerbose(true);
            s.parse(args[0]);
            System.out.println(s);
        }
    }
}

