/*
 * Decompiled with CFR 0.152.
 */
package proper.imp;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.Stack;
import java.util.Vector;
import proper.core.ProperObject;
import proper.imp.Data;
import proper.imp.List;
import proper.imp.ParserInterface;
import proper.imp.Predicate;
import proper.util.ID;
import proper.util.ProperVector;

public abstract class Parser
extends ProperObject
implements ParserInterface {
    public static final boolean RELAGGS_FIX = true;
    private Vector predicates = new ProperVector();
    protected Reader reader;
    private boolean addClassLabel = false;
    private boolean onlyForSingles;
    private String classLabel = "";
    private boolean verbose = false;
    private ID id;
    protected Stack current = new Stack();
    private boolean isNot;
    protected int line;
    protected int pos;
    private String filename = "";

    public Parser() {
        this.id = new ID();
    }

    @Override
    public void setID(ID id) {
        this.id = id;
    }

    @Override
    public Vector getPredicates() {
        return this.predicates;
    }

    @Override
    public void setAddClassLabel(boolean addClassLabel) {
        this.addClassLabel = addClassLabel;
    }

    @Override
    public boolean getAddClassLabel() {
        return this.addClassLabel;
    }

    @Override
    public void setOnlyForSingles(boolean onlyForSingles) {
        this.onlyForSingles = onlyForSingles;
    }

    @Override
    public boolean getOnlyForSingles() {
        return this.onlyForSingles;
    }

    @Override
    public void setClassLabel(String classLabel) {
        this.classLabel = classLabel;
    }

    @Override
    public String getClassLabel() {
        return this.classLabel;
    }

    @Override
    public void setFilename(String filename) {
        this.filename = filename;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public void clear() {
        this.predicates.clear();
        this.current.clear();
        this.setIsNot(false);
        this.filename = "";
    }

    protected void parseError(Exception e) throws Exception {
        StackTraceElement[] elem = e.getStackTrace();
        String stack = "";
        int i = 0;
        while (i < elem.length) {
            if (i > 0) {
                stack = String.valueOf(stack) + "\n";
            }
            stack = String.valueOf(stack) + elem[i].toString();
            ++i;
        }
        throw new Exception("Parse Error at line " + (this.line + 1) + " at pos " + (this.pos + 1) + " with:" + "\n" + stack);
    }

    protected String nextClause() throws Exception {
        if (this.line > 0 && this.line % 1000 == 0) {
            this.println(this.line);
        }
        return null;
    }

    protected int nextID() {
        return this.id.next();
    }

    protected void setIsNot(boolean isNot) {
        this.isNot = isNot;
    }

    protected boolean getIsNot() {
        return this.isNot;
    }

    protected Data getCurrent() {
        return (Data)this.current.peek();
    }

    protected void newPredicate(String name) {
        Predicate p = new Predicate(name, this.nextID());
        if (this.current.empty()) {
            this.current.push(p);
        } else {
            p.setParent(this.getCurrent());
            this.getCurrent().add(p);
            this.current.push(p);
        }
    }

    protected void addPredicate() {
        Predicate p = (Predicate)this.current.pop();
        if (this.getAddClassLabel()) {
            String label = this.getClassLabel().equals("") ? (this.getIsNot() ? "neg" : "pos") : this.getClassLabel();
            if (!this.getOnlyForSingles() || this.getOnlyForSingles() && p.size() == 1) {
                p.add(label);
                p.setClassLabelAdded(true);
            }
        }
        this.predicates.add(p);
    }

    protected void newList() {
        List l = new List(this.nextID());
        if (this.current.empty()) {
            this.current.push(l);
        } else {
            l.setParent(this.getCurrent());
            this.getCurrent().add(l);
            this.current.push(l);
        }
    }

    protected void removeCurrent() {
        if (this.current.size() > 1) {
            this.current.pop();
        }
    }

    protected void add(Object o, boolean nonEmpty) {
        if (nonEmpty) {
            if (!o.toString().equals("")) {
                this.add(o);
            }
        } else {
            this.add(o);
        }
    }

    protected Object process(Object o) {
        String str = o.toString();
        boolean converted = false;
        if (str.equals("+")) {
            o = "pos";
            converted = true;
        } else if (o.toString().equals("-")) {
            o = "neg";
            converted = true;
        }
        if (!converted && Data.isNull(str)) {
            o = "NULL";
            converted = true;
        }
        if (!converted) {
            try {
                Integer i = new Integer(str);
                o = i;
                converted = true;
            }
            catch (Exception e) {
                converted = false;
            }
        }
        if (!converted) {
            try {
                Long l = new Long(str);
                o = l;
                converted = true;
            }
            catch (Exception e) {
                converted = false;
            }
        }
        if (!converted) {
            try {
                Double d = new Double(str);
                o = d;
                converted = true;
            }
            catch (Exception e) {
                converted = false;
            }
        }
        if (!converted) {
            try {
                java.util.Date dt;
                if (str.indexOf("-") > 0) {
                    SimpleDateFormat sdt = new SimpleDateFormat("yyyy-MM-dd");
                    dt = sdt.parse(str);
                } else if (str.indexOf("/") > 0) {
                    try {
                        SimpleDateFormat sdt = new SimpleDateFormat("yyyy/MM/dd");
                        dt = sdt.parse(str);
                    }
                    catch (Exception e1) {
                        try {
                            SimpleDateFormat sdt = new SimpleDateFormat("MM/dd/yyyy");
                            dt = sdt.parse(str);
                        }
                        catch (Exception e2) {
                            SimpleDateFormat sdt = new SimpleDateFormat("dd/MM/yyyy");
                            dt = sdt.parse(str);
                        }
                    }
                } else if (str.indexOf(".") > 0) {
                    SimpleDateFormat sdt = new SimpleDateFormat("dd.MM.yyyy");
                    dt = sdt.parse(str);
                } else {
                    dt = null;
                }
                if (dt != null) {
                    o = new Date(dt.getTime());
                    converted = true;
                }
            }
            catch (Exception e) {
                converted = false;
            }
        }
        if (!converted) {
            if (str.length() > 2) {
                if (str.startsWith("`") && str.endsWith("`")) {
                    o = str.substring(1, str.length() - 1);
                }
                if (str.startsWith("'") && str.endsWith("'")) {
                    o = str.substring(1, str.length() - 1);
                }
                if (str.startsWith("\"") && str.endsWith("\"")) {
                    o = str.substring(1, str.length() - 1);
                }
            } else {
                if (str.startsWith("`") && str.endsWith("`")) {
                    o = "";
                }
                if (str.startsWith("'") && str.endsWith("'")) {
                    o = "";
                }
                if (str.startsWith("\"") && str.endsWith("\"")) {
                    o = "";
                }
            }
            o = o.toString().replaceAll("''", "").replaceAll("'", "`");
        }
        return o;
    }

    protected void add(Object o) {
        this.getCurrent().add(this.process(o));
    }

    protected abstract void parseClause(String var1);

    @Override
    public void parse(String filename) throws Exception {
        File file = new File(filename);
        this.setFilename(file.getName());
        this.parse(new BufferedReader(new FileReader(filename)));
    }

    @Override
    public void parse(Reader reader) throws Exception {
        this.reader = reader;
        this.line = 0;
        String clause = null;
        do {
            try {
                clause = this.nextClause();
                if (clause == null) continue;
                this.parseClause(clause);
            }
            catch (Exception e) {
                this.parseError(e);
            }
        } while (clause != null);
    }

    @Override
    public String toString() {
        String result = "";
        int i = 0;
        while (i < this.predicates.size()) {
            if (i > 0) {
                result = String.valueOf(result) + "\n";
            }
            result = String.valueOf(result) + this.predicates.get(i).toString();
            ++i;
        }
        return result;
    }
}

