/*
 * Decompiled with CFR 0.152.
 */
package proper.imp;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import proper.core.ProperObject;
import proper.imp.CSVParser;
import proper.imp.Data;
import proper.imp.List;
import proper.imp.Predicate;
import proper.imp.Traverser;
import proper.util.ProperVector;

public class Indexer
extends ProperObject {
    private String indexes = "";
    private Traverser traverser = null;
    private Hashtable idIndexes = new Hashtable();
    private Hashtable classLabelAdded = new Hashtable();
    private Hashtable splitIndexesId = new Hashtable();
    private boolean initialized = false;

    private void initialize() {
        this.idIndexes.clear();
        if (this.traverser == null) {
            return;
        }
        this.initialized = true;
        Vector names = this.traverser.getPredicates();
        int i = 0;
        while (i < names.size()) {
            this.idIndexes.put(names.get(i), new ProperVector());
            ++i;
        }
        StringTokenizer tok = new StringTokenizer(this.indexes, ",");
        while (tok.hasMoreTokens()) {
            Vector ids;
            String item = tok.nextToken();
            if (item.indexOf(":") > -1) {
                StringTokenizer tok2 = new StringTokenizer(item, ":");
                String pred = tok2.nextToken();
                String index = tok2.nextToken();
                if (pred.startsWith("!")) {
                    if (this.idIndexes.get(pred = pred.substring(1, pred.length())) == null) {
                        this.idIndexes.put(pred, new ProperVector());
                    }
                    if (!(ids = (Vector)this.idIndexes.get(pred)).contains(index)) continue;
                    ids.remove(ids.indexOf(index));
                    continue;
                }
                if (this.idIndexes.get(pred) == null) {
                    this.idIndexes.put(pred, new ProperVector());
                }
                ids = (Vector)this.idIndexes.get(pred);
                ids.add(index);
                continue;
            }
            i = 0;
            while (i < names.size()) {
                ids = (Vector)this.idIndexes.get(names.get(i));
                ids.add(item);
                ++i;
            }
        }
    }

    public void setIndexes(String indexes) {
        this.indexes = indexes;
        this.initialized = false;
        if (!this.indexes.equals("")) {
            this.indexes = String.valueOf(this.indexes) + ",";
        }
        this.indexes = String.valueOf(this.indexes) + "!" + CSVParser.FILE_PREDICATE + ":first" + "," + "!" + CSVParser.IDENTIFIER_PREDICATE + ":first";
    }

    public String getIndexes() {
        return this.indexes;
    }

    public Vector getIndexes(String name) {
        return (Vector)this.idIndexes.get(name);
    }

    public String getProcessedIndexes() {
        String result = "";
        Vector names = this.getIndexNames();
        int i = 0;
        while (i < names.size()) {
            if (i > 0) {
                result = String.valueOf(result) + ",";
            }
            result = String.valueOf(result) + this.getProcessedIndexes((String)names.get(i));
            ++i;
        }
        return result;
    }

    public String getProcessedIndexes(String name) {
        String result = "";
        Vector indexes = this.getIndexes(name);
        int i = 0;
        while (i < indexes.size()) {
            if (i > 0) {
                result = String.valueOf(result) + ",";
            }
            result = String.valueOf(result) + name + ":" + indexes.get(i).toString();
            ++i;
        }
        return result;
    }

    public int getIndexCount(String name) {
        Vector indexes = this.getIndexes(name);
        if (indexes.size() == 0) {
            return 0;
        }
        return indexes.size();
    }

    public Vector getIndexNames() {
        ProperVector result = new ProperVector();
        Enumeration enm = this.idIndexes.keys();
        while (enm.hasMoreElements()) {
            String name = (String)enm.nextElement();
            if (this.getIndexCount(name) <= 0) continue;
            result.add(name);
        }
        return result;
    }

    public void setTraverser(Traverser traverser) {
        this.traverser = traverser;
        this.initialized = false;
    }

    public Traverser getTraverser() {
        return this.traverser;
    }

    public void setAddClassLabel(boolean addClassLabel, boolean onlyForSingles) {
        Vector names = this.traverser.getPredicates();
        int n = 0;
        while (n < names.size()) {
            String name = (String)names.get(n);
            Predicate p = this.traverser.findFirstPredicate(name);
            this.classLabelAdded.put(name, new Boolean(p.getClassLabelAdded()));
            ++n;
        }
    }

    public boolean isIndex(Data d, int index) {
        Vector ids;
        boolean result = false;
        if (!this.initialized) {
            this.initialize();
        }
        if (this.initialized && d instanceof Predicate && (ids = (Vector)this.idIndexes.get(d.getName())) != null) {
            int i = 0;
            while (i < ids.size()) {
                boolean bl = result = this.getIndex(d, (String)ids.get(i)) == index;
                if (result) break;
                ++i;
            }
        }
        return result;
    }

    public int getIndex(Data d, String indexStr) {
        int idIndex = -1;
        if (!this.initialized) {
            this.initialize();
        }
        if (this.initialized && d instanceof Predicate && !this.indexes.equals("")) {
            if (indexStr.equals("first")) {
                idIndex = 0;
            } else if (indexStr.equals("second")) {
                idIndex = 1;
            } else if (indexStr.equals("third")) {
                idIndex = 2;
            } else if (indexStr.equals("last")) {
                Boolean label;
                idIndex = d.size() - 1;
                if (this.classLabelAdded.containsKey(d.getName()) && (label = (Boolean)this.classLabelAdded.get(d.getName())).booleanValue()) {
                    --idIndex;
                }
            } else {
                idIndex = new Integer(indexStr);
            }
        }
        return idIndex;
    }

    public void removeNullIndexes() {
        this.println("Searching for predicates with NULL in index...");
        if (!this.initialized) {
            this.initialize();
        }
        Vector names = this.traverser.getPredicates();
        ProperVector list = new ProperVector();
        int i = 0;
        while (i < names.size()) {
            Vector preds = this.traverser.findAllPredicates((String)names.get(i));
            Vector idx = (Vector)this.idIndexes.get(names.get(i));
            int n = 0;
            while (n < preds.size()) {
                Predicate p = (Predicate)preds.get(n);
                int m = 0;
                while (m < idx.size()) {
                    int l = this.getIndex(p, (String)idx.get(m));
                    if (p.isNull(l)) {
                        list.add(p);
                    }
                    ++m;
                }
                ++n;
            }
            ++i;
        }
        if (list.size() > 0) {
            this.println("Removing " + list.size() + " predicates...");
            i = 0;
            while (i < list.size()) {
                this.traverser.remove((Data)list.get(i));
                ++i;
            }
        }
    }

    public boolean keyIsInt() throws Exception {
        boolean result = true;
        Vector names = this.traverser.getPredicates();
        int pos = -1;
        boolean hasIndex = false;
        int i = 0;
        while (i < names.size()) {
            String name = (String)names.get(i);
            Predicate p = this.traverser.findFirstPredicate(name);
            if (this.getVerboseLevel() >= 2) {
                this.println("Checking Predicate: " + p);
            }
            int n = 0;
            while (n < p.size()) {
                if (this.isIndex(p, n)) {
                    hasIndex = true;
                    try {
                        new Integer(p.get(n).toString());
                        result = true;
                    }
                    catch (Exception e) {
                        result = false;
                        pos = n;
                    }
                    if (this.getVerboseLevel() >= 2) {
                        this.println(" - " + n + ": " + result);
                    }
                }
                if (!result) break;
                ++n;
            }
            if (!result) {
                if (!this.getVerbose()) break;
                this.println("Predicate '" + name + "' has a non-Integer key at position " + pos + "!");
                break;
            }
            ++i;
        }
        if (!hasIndex) {
            throw new Exception("No Predicates with indexes!");
        }
        return result;
    }

    public Vector getListsWithIndex() {
        ProperVector result = new ProperVector();
        Vector names = this.traverser.getPredicates();
        int i = 0;
        while (i < names.size()) {
            String name = (String)names.get(i);
            Predicate p = this.traverser.findFirstPredicate(name);
            int n = 0;
            while (n < p.size()) {
                if (p.get(n) instanceof List && this.isIndex(p, n)) {
                    result.add(((List)p.get(n)).getName());
                }
                ++n;
            }
            ++i;
        }
        return result;
    }

    public void addSplitIndexId(Data d, int index) {
        Integer ind;
        Vector indexes;
        if (!this.splitIndexesId.containsKey(d.getName())) {
            this.splitIndexesId.put(d.getName(), new ProperVector());
        }
        if (!(indexes = (Vector)this.splitIndexesId.get(d.getName())).contains(ind = new Integer(index))) {
            indexes.add(ind);
        }
    }

    public boolean isSplitIndexId(Data d, int index) {
        boolean result = false;
        if (this.splitIndexesId.containsKey(d.getName())) {
            Vector indexes = (Vector)this.splitIndexesId.get(d.getName());
            result = indexes.contains(new Integer(index));
        }
        return result;
    }
}

