/*
 * Decompiled with CFR 0.152.
 */
package proper.gui.remote;

import proper.app.Jobs;
import proper.gui.core.frame.FrameThread;
import proper.gui.core.list.JListHelper;
import proper.gui.remote.Jobber;
import proper.io.AntTarget;
import proper.io.TextFile;
import proper.util.ProperVector;
import proper.util.Strings;

class Generator
extends FrameThread {
    private Jobber owner;

    public Generator(Jobber owner) {
        super(owner);
        this.owner = owner;
    }

    private int[] getFileChangeIndices(Object[] list) {
        ProperVector indices = new ProperVector();
        String filename = "";
        int i = 0;
        while (i < list.length) {
            if (list[i] instanceof AntTarget) {
                String filenameNew = ((AntTarget)list[i]).getAnt().getFilename();
                if (filename.equals("")) {
                    indices.add(new Integer(0));
                } else if (!filename.equals(filenameNew)) {
                    indices.add(new Integer(i));
                }
                filename = filenameNew;
            }
            ++i;
        }
        indices.add(new Integer(list.length));
        int[] result = new int[indices.size()];
        i = 0;
        while (i < indices.size()) {
            result[i] = (Integer)indices.get(i);
            ++i;
        }
        return result;
    }

    @Override
    public void run() {
        this.beforeRun();
        this.owner.exchange = this.owner.checkExchange.isSelected();
        this.owner.append = this.owner.checkAppend.isSelected();
        this.owner.jobfile = this.owner.textJobfile.getText();
        StringBuffer properties = new StringBuffer();
        Object[][] props = this.owner.tableProperties.getProperties();
        int i = 0;
        while (i < props.length) {
            if (i > 0) {
                properties.append(",");
            }
            String tmp = String.valueOf(props[i][0].toString().trim()) + "=" + props[i][1].toString().trim();
            if (props[i][1].toString().indexOf(",") > -1) {
                tmp = "\"" + tmp + "\"";
            }
            properties.append(tmp);
            ++i;
        }
        ProperVector data = new ProperVector();
        Object[] list = JListHelper.getAllListData(this.owner.listChosenTargets);
        int[] indices = this.getFileChangeIndices(list);
        int n = 0;
        while (n < indices.length - 1) {
            String targets = "";
            int antIndex = -1;
            i = indices[n];
            while (i < indices[n + 1]) {
                this.owner.showStatus(String.valueOf(i + 1) + "/" + list.length);
                if (list[i] instanceof AntTarget) {
                    if (!targets.equals("")) {
                        targets = String.valueOf(targets) + ",";
                    }
                    targets = String.valueOf(targets) + ((AntTarget)list[i]).getTarget();
                    if (antIndex == -1) {
                        antIndex = i;
                    }
                }
                if ((list[i] instanceof String || i == indices[n + 1] - 1) && !targets.equals("")) {
                    Jobs jobs = new Jobs();
                    ProperVector args = new ProperVector();
                    args.add("-input");
                    args.add(((AntTarget)list[antIndex]).getAnt().getFilename());
                    args.add("-output");
                    args.add(this.owner.jobfile);
                    args.add("-target");
                    args.add(targets);
                    if (this.owner.checkProperties.isSelected()) {
                        args.add("-properties");
                        args.add(properties.toString());
                    }
                    if (this.owner.append) {
                        args.add("-append");
                    }
                    if (this.owner.exchange) {
                        args.add("-exchange");
                    }
                    if (i > 0) {
                        args.add("-no_date");
                    }
                    try {
                        jobs.run(Strings.vectorToArray(args));
                    }
                    catch (Exception e) {
                        this.owner.println(e);
                    }
                    this.owner.append = true;
                }
                if (list[i] instanceof String) {
                    data.clear();
                    data.add(list[i].toString());
                    data.add("");
                    TextFile.save(this.owner.jobfile, data, this.owner.append);
                    this.owner.append = true;
                    this.owner.loadJobs();
                }
                if (!this.isRunning()) break;
                ++i;
            }
            if (!this.isRunning()) break;
            ++n;
        }
        this.afterRun();
        this.owner.loadJobs();
    }
}

