/*
 * Decompiled with CFR 0.152.
 */
package proper.gui.experiment;

import java.util.Vector;
import org.apache.tools.ant.Task;
import proper.app.Application;
import proper.gui.core.frame.FrameThread;
import proper.gui.core.list.JListHelper;
import proper.gui.experiment.ExperimentFrame;
import proper.util.Strings;

class ExperimentExecutor
extends FrameThread {
    private ExperimentFrame owner;

    public ExperimentExecutor(ExperimentFrame owner) {
        super(owner);
        this.owner = owner;
    }

    @Override
    public void run() {
        this.beforeRun();
        String[] targetNames = JListHelper.toStringArray(JListHelper.getListData(this.owner.listDatasets));
        int i = 0;
        while (i < targetNames.length) {
            this.owner.showStatus(String.valueOf(i + 1) + "/" + targetNames.length);
            Vector tasks = this.owner.ant.getJavaTasks(targetNames[i]);
            if (tasks != null && tasks.size() != 0) {
                int n = 0;
                while (n < tasks.size()) {
                    try {
                        Task task = (Task)tasks.get(n);
                        Application app = Application.createInstance(this.owner.ant.getClassname(task));
                        this.owner.addListener(app);
                        app.run(Strings.vectorToArray(this.owner.ant.getArguments(task)));
                        this.owner.removeListener(app);
                    }
                    catch (Exception e) {
                        this.owner.println(e);
                    }
                    this.owner.println("\n---\n");
                    if (!this.isRunning()) break;
                    ++n;
                }
                if (!this.isRunning()) break;
            }
            ++i;
        }
        this.afterRun();
    }
}

