/*
 * Decompiled with CFR 0.152.
 */
package proper.gui.core.text;

import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.filechooser.FileFilter;
import proper.gui.core.dialog.FileChooser;
import proper.gui.core.event.CurrentDirChangeEvent;
import proper.gui.core.event.CurrentDirChangeListener;
import proper.gui.core.frame.ProperFrame;
import proper.gui.core.text.ProperTextField;
import proper.util.Strings;

public class FileTextField
extends ProperTextField {
    private FileChooser dialog;
    private HashSet currentDirChangeListeners;

    public FileTextField(ProperFrame parent) {
        this(parent, 20);
    }

    public FileTextField(ProperFrame parent, int columns) {
        this(parent, "", columns);
    }

    public FileTextField(ProperFrame parent, String text, int columns) {
        this(parent, text, columns, false);
    }

    public FileTextField(ProperFrame parent, String text, int columns, boolean useIcon) {
        super(parent, text, columns, useIcon);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.dialog = new FileChooser(new File(System.getProperty("user.dir")));
        this.currentDirChangeListeners = new HashSet();
    }

    public void addCurrentDirChangeListener(CurrentDirChangeListener l) {
        this.currentDirChangeListeners.add(l);
    }

    public boolean removeCurrentDirChangeListener(CurrentDirChangeListener l) {
        return this.currentDirChangeListeners.remove(l);
    }

    private void notifyCurrentDirChangeListeners(CurrentDirChangeEvent e) {
        Iterator iter = this.currentDirChangeListeners.iterator();
        while (iter.hasNext()) {
            ((CurrentDirChangeListener)iter.next()).currentDirChanged(e);
        }
    }

    public String getFile() {
        return this.dialog.getSelectedFile().getAbsolutePath();
    }

    public void setFile(String file) {
        try {
            this.dialog.setSelectedFile(new File(file));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getFiles() {
        File[] files = this.dialog.getSelectedFiles();
        String[] filesStr = new String[files.length];
        int i = 0;
        while (i < files.length) {
            filesStr[i] = files[i].getAbsolutePath();
            ++i;
        }
        return Strings.toCommalist(filesStr);
    }

    public void setFiles(String filelist) {
        String[] filesStr = Strings.fromCommalist(filelist);
        File[] files = new File[filesStr.length];
        try {
            int i = 0;
            while (i < filesStr.length) {
                files[i] = new File(filesStr[i]);
                ++i;
            }
            this.dialog.setSelectedFiles(files);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setMultiSelectionEnabled(boolean b) {
        this.dialog.setMultiSelectionEnabled(b);
    }

    public boolean isMultiSelectionEnabled() {
        return this.dialog.isMultiSelectionEnabled();
    }

    public void setFileFilter(FileFilter filter) {
        this.dialog.setFileFilter(filter);
    }

    public FileFilter getFileFilter() {
        return this.dialog.getFileFilter();
    }

    public void addChoosableFileFilter(FileFilter filter) {
        this.dialog.addChoosableFileFilter(filter);
    }

    public FileFilter getAcceptAllFileFilter() {
        return this.dialog.getAcceptAllFileFilter();
    }

    public FileFilter[] getChoosableFileFilters() {
        return this.dialog.getChoosableFileFilters();
    }

    public boolean isAcceptAllFileFilterUsed() {
        return this.dialog.isAcceptAllFileFilterUsed();
    }

    public boolean removeChoosableFileFilter(FileFilter f) {
        return this.dialog.removeChoosableFileFilter(f);
    }

    public void resetChoosableFileFilters() {
        this.dialog.resetChoosableFileFilters();
    }

    public void setAcceptAllFileFilterUsed(boolean b) {
        this.dialog.setAcceptAllFileFilterUsed(b);
    }

    public void setCurrentDirectory(File dir) {
        this.dialog.setCurrentDirectory(dir);
    }

    public File getCurrentDirectory() {
        return this.dialog.getCurrentDirectory();
    }

    @Override
    protected void openDialog() {
        if (this.isMultiSelectionEnabled()) {
            this.setFiles(this.getText());
        } else {
            this.setFile(this.getText());
        }
        int retVal = this.dialog.showOpenDialog(this);
        if (retVal == 0) {
            if (this.isMultiSelectionEnabled()) {
                this.setText(this.getFiles());
            } else {
                this.setText(this.getFile());
            }
            this.notifyCurrentDirChangeListeners(new CurrentDirChangeEvent(this, this.dialog.getCurrentDirectory()));
        }
    }
}

