/*
 * Decompiled with CFR 0.152.
 */
package proper.gui.core.text;

import javax.swing.JOptionPane;
import proper.database.Connector;
import proper.gui.core.dialog.DataBaseConnectDialog;
import proper.gui.core.event.ConnectorChangeListener;
import proper.gui.core.frame.ProperFrame;
import proper.gui.core.text.ProperTextField;

public class DatabaseTextField
extends ProperTextField {
    public static final int TYPE_DATABASE = 0;
    public static final int TYPE_TABLE = 1;
    public static final int TYPE_COLUMN = 2;
    private int type;
    private DataBaseConnectDialog dialog;

    public DatabaseTextField(ProperFrame parent, int type) {
        this(parent, type, 20);
    }

    public DatabaseTextField(ProperFrame parent, int type, int columns) {
        this(parent, type, "", columns);
    }

    public DatabaseTextField(ProperFrame parent, int type, String text, int columns) {
        this(parent, type, text, columns, false);
    }

    public DatabaseTextField(ProperFrame parent, int type, String text, int columns, boolean useIcon) {
        super(parent, text, columns, useIcon);
        this.type = type == 0 || type == 1 || type == 2 ? type : 0;
    }

    public int getType() {
        return this.type;
    }

    public void setConnector(Connector conn) {
        if (this.dialog != null) {
            this.dialog.setConnector(conn);
        }
    }

    public Connector getConnector() {
        return this.dialog.getConnector();
    }

    public String getDatabase() {
        return this.dialog.getDatabase();
    }

    public String getTable() {
        return this.dialog.getTable();
    }

    public String getColumn() {
        return this.dialog.getColumn();
    }

    @Override
    protected void openDialog() {
        if (this.getType() == 0) {
            this.dialog = new DataBaseConnectDialog(this.getParentFrame());
            this.dialog.pack();
            this.dialog.show();
        } else if (this.getType() == 1) {
            this.dialog = new DataBaseConnectDialog(this.getParentFrame(), "Choose Table...");
            if (this.getConnector().getConnection() != null && !this.getConnector().getDatabase().equals("")) {
                this.dialog.pack();
                this.dialog.show();
            } else {
                JOptionPane.showMessageDialog(this, "No database choosen !", "Error", 0);
            }
        } else if (this.getType() == 2) {
            this.dialog = new DataBaseConnectDialog(this.getParentFrame(), "Choose Column...");
            if (this.getConnector().getConnection() != null && !this.getConnector().getDatabase().equals("") && !this.getConnector().getTable().equals("")) {
                this.dialog.pack();
                this.dialog.show();
            } else {
                JOptionPane.showMessageDialog(this, "No table choosen !", "Error", 0);
            }
        }
        if (this.dialog.isValidate()) {
            if (this.getType() == 0) {
                this.setText(this.dialog.getDatabase());
            } else if (this.getType() == 1) {
                this.setText(this.dialog.getTable());
            } else if (this.getType() == 2) {
                this.setText(this.dialog.getColumn());
            }
        }
    }

    public void removeConnectorChangeListener(ConnectorChangeListener listener) {
        this.dialog.removeConnectorChangeListener(listener);
    }

    public void addConnectorChangeListener(ConnectorChangeListener listener) {
        this.dialog.addConnectorChangeListener(listener);
    }
}

