/*
 * Decompiled with CFR 0.152.
 */
package proper.gui.core.panel;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import proper.database.ColumnLister;
import proper.database.Connector;
import proper.gui.core.dialog.DataBaseConnectDialog;
import proper.gui.core.dialog.ProperDialog;
import proper.gui.core.panel.ProperPanel;

public class ColumnChooserPanel
extends ProperPanel
implements ActionListener {
    private Connector conn;
    private ProperDialog parent;
    private JPanel jp_col;
    private JLabel jl_col;
    private JComboBox jcb_col;

    public ColumnChooserPanel(ProperDialog parent, Connector conn) {
        this.conn = conn;
        this.parent = parent;
        this.initComponent();
    }

    private void initComponent() {
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.jp_col = new JPanel(new FlowLayout(3));
        TitledBorder t1 = new TitledBorder("Select a column (class)");
        this.jp_col.setBorder(t1);
        this.jl_col = new JLabel("Columns : ");
        this.jcb_col = new JComboBox();
        this.jcb_col.addActionListener(this);
        this.jcb_col.addItem("Choose...");
        this.jcb_col.setSelectedIndex(0);
        this.jcb_col.setEditable(false);
        this.jp_col.add(this.jl_col);
        this.jp_col.add(this.jcb_col);
        this.add((Component)this.jp_col, "Center");
        if (this.conn.getConnection() != null) {
            this.listedColumn();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.jcb_col) {
            this.changeColumn();
        }
    }

    private void listedColumn() {
        if (this.conn != null) {
            try {
                ColumnLister lister = new ColumnLister(this.conn);
                lister.setTable(this.conn.getTable());
                lister.setSort(true);
                Vector list = lister.getList();
                int i = 0;
                while (i < list.size()) {
                    this.jcb_col.addItem(list.get(i).toString());
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void changeColumn() {
        if (this.jcb_col.getSelectedIndex() > 0) {
            ((DataBaseConnectDialog)this.parent).changeOkButtonStatus(true);
            this.conn.setColumn(this.jcb_col.getSelectedItem().toString());
        } else {
            ((DataBaseConnectDialog)this.parent).changeOkButtonStatus(false);
        }
    }
}

