/*
 * Decompiled with CFR 0.152.
 */
package proper.gui.core.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import proper.gui.core.dialog.ProperDialog;
import proper.gui.core.frame.DummyFrame;
import proper.gui.core.frame.ProperFrame;
import proper.gui.core.panel.OkCancelPanel;

public class EditDialog
extends ProperDialog {
    private JTextArea areaText;
    private JScrollPane paneText;
    private OkCancelPanel panelOkCancel;
    private String text;
    private boolean editable;

    public EditDialog() {
        this(new DummyFrame(), "Edit");
    }

    public EditDialog(ProperFrame parent) {
        this(parent, "Edit");
    }

    public EditDialog(String title) {
        this(new DummyFrame(), title);
    }

    public EditDialog(ProperFrame parent, String title) {
        super(parent, title);
        this.initialize();
        this.createDialog();
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.text = "";
        this.editable = false;
    }

    @Override
    protected void createDialog() {
        super.createDialog();
        this.setSize(600, 300);
        this.setCenteredLocation();
        this.getContentPane().setLayout(new BorderLayout());
        this.areaText = new JTextArea();
        this.areaText.setLineWrap(true);
        this.areaText.setFont(Font.decode(this.getCustomFont()));
        this.areaText.addKeyListener(this);
        this.paneText = new JScrollPane(this.areaText);
        this.getContentPane().add((Component)this.paneText, "Center");
        this.panelOkCancel = new OkCancelPanel(false);
        this.panelOkCancel.addActionListener(this);
        this.panelOkCancel.addKeyListener(this);
        this.getContentPane().add((Component)this.panelOkCancel, "East");
        this.getRootPane().setDefaultButton(this.panelOkCancel.buttonOK);
    }

    public void setText(String text) {
        this.text = text;
        this.areaText.setText(text);
    }

    public String getText() {
        return this.text;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
        this.areaText.setEnabled(editable);
    }

    public boolean getEditable() {
        return this.editable;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals("ok")) {
            this.approved = true;
            if (this.getEditable()) {
                this.text = this.areaText.getText();
            }
            this.close();
        } else if (action.equals("cancel")) {
            this.close();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            this.close();
        }
    }
}

