/*
 * Decompiled with CFR 0.152.
 */
package proper.engine;

import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Reader;
import proper.engine.Engine;
import proper.util.Strings;
import proper.util.WekaHelper;
import weka.classifiers.Classifier;
import weka.core.Instances;

public class WekaClassifier
extends Engine {
    public WekaClassifier() {
        this.setParameter("classifier", "weka.classifiers.trees.J48");
        this.setParameter("additional", "");
        this.setParameter("input", "tmp/input.arff");
        this.setParameter("unknown", "tmp/unknown.arff");
        this.setParameter("output", "tmp/output.arff");
    }

    @Override
    public boolean execute() {
        super.execute();
        try {
            Classifier classifier = WekaHelper.getClassifierInstance(this.getStringParameter("classifier"));
            String[] adds = Strings.breakUp(this.getStringParameter("additional"));
            WekaHelper.setOptions((Object)classifier, adds);
            Instances known = new Instances((Reader)new FileReader(this.getStringParameter("input")));
            known.setClassIndex(known.numAttributes() - 1);
            classifier.buildClassifier(known);
            Instances unknown = new Instances((Reader)new FileReader(this.getStringParameter("unknown")));
            unknown.setClassIndex(unknown.numAttributes() - 1);
            Instances classified = new Instances((Reader)new FileReader(this.getStringParameter("unknown")));
            classified.setClassIndex(classified.numAttributes() - 1);
            classified.setRelationName(classified.relationName().replaceAll("unclassified", "classified"));
            int i = 0;
            while (i < unknown.numInstances()) {
                this.print(".");
                unknown.instance(i).setClassMissing();
                classified.instance(i).setClassMissing();
                double classification = classifier.classifyInstance(unknown.instance(i));
                classified.instance(i).setClassValue(classification);
                ++i;
            }
            this.println();
            PrintWriter writer = new PrintWriter(new FileWriter(this.getStringParameter("output")));
            writer.print(classified.toString());
            writer.flush();
            writer.close();
            return true;
        }
        catch (Exception e) {
            this.println(e);
            return false;
        }
    }
}

