/*
 * Decompiled with CFR 0.152.
 */
package proper.database;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.Collections;
import java.util.Vector;
import proper.database.Connector;
import proper.database.Executor;
import proper.database.ExecutorObject;
import proper.database.Lister;
import proper.database.Table;
import proper.util.Excluder;
import proper.util.ProperVector;

public class TableLister
extends ExecutorObject
implements Lister {
    private boolean sort;
    private boolean sortByName;
    private Excluder excluder;

    public TableLister(Connector conn) {
        super(conn);
        this.clear();
    }

    @Override
    public void clear() {
        this.sort = false;
        this.sortByName = true;
        this.excluder = new Excluder("");
    }

    @Override
    public void setSort(boolean sort) {
        this.sort = sort;
    }

    @Override
    public boolean getSort() {
        return this.sort;
    }

    public void setSortByName(boolean sortByName) {
        this.sortByName = sortByName;
    }

    public boolean getSortByName() {
        return this.sortByName;
    }

    public void setExcludes(Vector excludes) {
        this.excluder = new Excluder(excludes);
    }

    public void setExcludes(String excludes) {
        this.excluder = new Excluder(excludes);
    }

    @Override
    public Vector getList() {
        Vector list = this.getList("%");
        if (list.size() == 0) {
            list = this.getList(null);
        }
        return list;
    }

    public Vector getList(String pattern) {
        ProperVector result = new ProperVector();
        try {
            Table t;
            int i;
            DatabaseMetaData meta = this.conn.getConnection().getMetaData();
            ResultSet rs = meta.getTables(null, null, pattern, new String[]{"TABLE"});
            int index = -1;
            while (rs.next()) {
                String name;
                if (index == -1) {
                    i = 1;
                    while (i <= rs.getMetaData().getColumnCount()) {
                        if (rs.getMetaData().getColumnName(i).equalsIgnoreCase("table_name")) {
                            index = i;
                            break;
                        }
                        ++i;
                    }
                }
                if (this.excluder.contains(name = rs.getString(index))) continue;
                t = new Table(name);
                t.setSortByName(this.getSortByName());
                result.add(t);
            }
            rs.close();
            Executor exec = new Executor(this.conn);
            i = 0;
            while (i < result.size()) {
                t = (Table)result.get(i);
                t.setSize(exec.getRecordCount(t.getName()));
                ++i;
            }
            if (this.getSort() && result.size() > 1) {
                Collections.sort(result);
            }
        }
        catch (Exception e) {
            this.println(e);
            result.clear();
        }
        if (this.getVerbose()) {
            this.println("Tables: " + result);
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 4) {
            System.out.println("Please provide url, database, user and password");
            System.exit(1);
        }
        Connector conn = new Connector(args[0], args[1], args[2], args[3]);
        TableLister lister = new TableLister(conn);
        Vector list = lister.getList();
        System.out.println("\nUnsorted");
        System.out.println(lister.getList());
        System.out.println("\nSorted by Name");
        lister.setSort(true);
        System.out.println(lister.getList());
        System.out.println("\nSorted by Size");
        lister.setSortByName(false);
        System.out.println(lister.getList());
        System.out.println("\nSorted by Name (again, but this time via Array-Sorting)");
        int i = 0;
        while (i < list.size()) {
            ((Table)list.get(i)).setSortByName(true);
            ++i;
        }
        Collections.sort(list);
        System.out.println(list);
        System.out.println("\nSorted by Size (again, but this time via Array-Sorting)");
        i = 0;
        while (i < list.size()) {
            ((Table)list.get(i)).setSortByName(false);
            ++i;
        }
        Collections.sort(list);
        System.out.println(list);
    }
}

