/*
 * Decompiled with CFR 0.152.
 */
package proper.database;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Collection;
import java.util.Collections;
import java.util.Vector;
import proper.database.Column;
import proper.database.Connector;
import proper.database.ConnectorObject;
import proper.util.ProperVector;

public class Executor
extends ConnectorObject {
    private Exception lastException = null;
    private String lastStatement = "";

    public Executor(Connector conn) {
        super(conn);
    }

    private Statement prepare() throws Exception {
        this.lastException = null;
        return this.conn.getConnection().createStatement(1004, 1008);
    }

    public ResultSet select(String sql) {
        ResultSet result;
        this.lastStatement = sql;
        try {
            Statement st = this.prepare();
            st.execute(sql);
            result = st.getResultSet();
        }
        catch (Exception e) {
            this.lastException = e;
            result = null;
        }
        if (this.getVerbose()) {
            this.println("Query: " + sql + " = " + (result != null));
        }
        return result;
    }

    public boolean update(String sql) {
        boolean result;
        this.lastStatement = sql;
        try {
            Statement st = this.prepare();
            st.executeUpdate(sql);
            result = true;
        }
        catch (Exception e) {
            this.lastException = e;
            result = false;
        }
        if (this.getVerbose()) {
            this.println("Query: " + sql + " = " + result);
        }
        return result;
    }

    public int count(String sql) {
        sql = sql.indexOf(" DISTINCT ") > -1 ? sql.replaceAll("SELECT ", "SELECT COUNT(").replaceAll(" FROM ", ") FROM ") : sql.replaceAll("SELECT .* FROM", "SELECT COUNT(*) FROM");
        ResultSet rs = this.select(sql);
        int result = -1;
        if (rs != null) {
            try {
                if (rs.first()) {
                    result = rs.getInt(1);
                }
                rs.close();
            }
            catch (Exception e) {
                this.println(e);
                result = -1;
            }
        }
        return result;
    }

    public int getRecordCount(String table) {
        return this.getRecordCount(table, "", false);
    }

    public int getRecordCount(String table, String column, boolean classified) {
        int cnt;
        String sql = "SELECT COUNT(*) FROM " + table;
        if (!column.equals("")) {
            sql = String.valueOf(sql) + " WHERE " + column;
            sql = classified ? String.valueOf(sql) + " IS NOT NULL" : String.valueOf(sql) + " IS NULL";
        }
        if ((cnt = this.count(sql)) == -1) {
            this.println("Error executing? " + sql + "\n" + this.getLastException());
        }
        return cnt;
    }

    public int getDistinctCount(String table, String column) {
        ProperVector columns = new ProperVector();
        columns.add(column);
        return this.getDistinctCount(table, columns);
    }

    public int getDistinctCount(String table, Vector columns) {
        int result = -1;
        String sql = "SELECT COUNT(DISTINCT ";
        sql = String.valueOf(sql) + new ProperVector((Collection)columns).toCommaList();
        ResultSet rs = this.select(sql = String.valueOf(sql) + ") FROM " + table);
        if (rs != null) {
            try {
                rs.first();
                result = rs.getInt(1);
                rs.close();
            }
            catch (Exception e) {
                this.println(e);
            }
        }
        return result;
    }

    public Vector getDistinctValues(String table, String column) {
        return this.getDistinctValues(table, column, false);
    }

    public Vector getDistinctValues(String table, String column, boolean classified) {
        ResultSet rs;
        ProperVector result = new ProperVector();
        String sql = "SELECT DISTINCT(" + column + ") FROM " + table;
        if (classified) {
            sql = String.valueOf(sql) + " IS NOT NULL";
        }
        if ((rs = this.select(sql)) != null) {
            try {
                Column col = new Column(column, rs.getMetaData().getColumnType(1));
                while (rs.next()) {
                    if (rs.wasNull()) {
                        result.add("NULL");
                    }
                    if (col.isNominal()) {
                        result.add(rs.getString(1));
                        continue;
                    }
                    if (col.isInteger()) {
                        result.add(new Integer(rs.getInt(1)));
                        continue;
                    }
                    if (col.isDecimal()) {
                        result.add(new Double(rs.getDouble(1)));
                        continue;
                    }
                    result.add(rs.getObject(1).toString());
                }
                rs.close();
            }
            catch (Exception e) {
                this.println(e);
            }
        }
        if (result.size() > 1) {
            Collections.sort(result);
        }
        return result;
    }

    public Exception getLastException() {
        return this.lastException;
    }

    public String getLastStatement() {
        return this.lastStatement;
    }
}

