/*
 * Decompiled with CFR 0.152.
 */
package proper.database;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import proper.core.ProperObject;
import proper.database.Connector;
import proper.database.Executor;

public class Creator
extends ProperObject {
    public static final String NAME = "%NAME%";
    private Connector conn;
    private Executor exec;
    private String createStr = "CREATE DATABASE %NAME%";

    public Creator() throws Exception {
    }

    public Creator(String url) throws Exception {
        this(url, "nobody");
    }

    public Creator(String url, String user) throws Exception {
        this(url, user, null);
    }

    public Creator(String url, String user, String password) throws Exception {
        this("org.gjt.mm.mysql.Driver", url, user, password);
    }

    public Creator(String driver, String url, String user, String password) throws Exception {
        this();
        this.connect(driver, url, user, password);
    }

    private boolean connect(String driver, String url, String user, String password) {
        boolean result;
        try {
            this.conn = new Connector(driver, url, "", user, password);
            this.addListener(this.conn);
            this.exec = new Executor(this.conn);
            result = true;
        }
        catch (Exception e) {
            this.println(e);
            result = false;
        }
        if (this.getVerbose()) {
            this.println("Connecting to " + url + " as User '" + user + "'" + " with Password '" + password.replaceAll(".", "*") + "'" + " with Driver '" + driver + "'" + " = " + result);
        }
        return result;
    }

    public void setCreateStatement(String statement) {
        this.createStr = statement;
    }

    public String getCreateStatement() {
        return this.createStr;
    }

    public boolean exists(String name) {
        boolean result;
        try {
            DatabaseMetaData meta = this.conn.getConnection().getMetaData();
            ResultSet rs = meta.getCatalogs();
            result = false;
            while (rs.next()) {
                if (!rs.getString("TABLE_CAT").equalsIgnoreCase(name)) continue;
                result = true;
                break;
            }
            rs.close();
        }
        catch (Exception e) {
            result = false;
        }
        if (this.getVerbose()) {
            this.println("Exists: " + name + " = " + result);
        }
        return result;
    }

    public boolean create(String name) {
        boolean result = this.exists(name);
        if (!result) {
            result = this.exec.update(this.getCreateStatement().replaceAll(NAME, name));
        }
        if (this.getVerbose()) {
            this.println("Create: " + this.exec.getLastStatement() + " = " + result);
        }
        return result;
    }

    public Exception getLastException() {
        return this.exec.getLastException();
    }

    public String getLastStatement() {
        return this.exec.getLastStatement();
    }
}

