/*
 * Decompiled with CFR 0.152.
 */
package proper.app;

import proper.app.DatabaseApplication;
import proper.engine.Engine;
import proper.engine.Relaggs;

public class RELAGGS
extends DatabaseApplication {
    private int maxDepth;

    @Override
    protected void defaultParameters() {
        super.defaultParameters();
        this.maxDepth = 1;
    }

    @Override
    protected void defineParameters() {
        super.defineParameters();
        this.addDefinition("table", "the table that contains the target", true, "<name>", false);
        this.addDefinition("result_table", "the table RELAGGS stores the propositionalized data", true, "<name>", false);
        this.addDefinition("field", "the field to use as class", true, "<name>", false);
        this.addDefinition("exclude_tables", "tables you want to exclude from the aggregation through Relaggs", true, "<name[,name...]>", true);
        this.addDefinition("join", "the type of join operation being performed during aggregation ('leftouter'\nimplies '-any_index')", true, "natural | leftouter", true);
        this.addDefinition("any_index", "whether to use any index or the primary key for aggregation", false, "", true);
        this.addDefinition("index", "specifies the index to use instead of the primary key (implies 'any_index')", true, "<name>", true);
        this.addDefinition("max_depth", "defines the maximal depth the search for relations does, -1 means unlimited\ndefault is: " + this.maxDepth, true, "<int>", true);
        this.addDefinition("use_foreign_keys", "uses foreign key relations to determine relations between tables rather \nthan matching column names", false, "", true);
        this.addDefinition("instead_null", "defines the values for columns (type is determined automatically) which is\nused instead of NULL values after a Join.", true, "<col=value[,col=value[,...]]>", true);
        this.addDefinition("tree", "instead of discovering the structure of the DB itself a tree structure can\nbe defined by the user. It starts with the root node, the children are\nseparated by ',' and a substree is surrounded by '[' and ']', e.g.:\na[b,c,d[e,f[g,h]]", true, "<tree-string>", true);
        this.addDefinition("properties", "comma-separated list of RELAGGS properties (key-valuye pairs)", true, "<key=value[,key=value[,...]]>", true);
    }

    @Override
    public void printDescription() {
        System.out.println("Performs propositionalization based on RELAGGS, developed by Mark-A. Krogel");
        System.out.println("(krogel@iws.cs.uni-magdeburg.de).");
        System.out.println();
    }

    @Override
    protected boolean process() throws Exception {
        this.println("\nRELAGGS\n=======\n");
        Relaggs engine = new Relaggs();
        this.initEngine(engine);
        engine.setParameter("table", this.cl.getValue("table"));
        engine.setParameter("result_table", this.cl.getValue("result_table"));
        engine.setParameter("field", this.cl.getValue("field"));
        engine.setParameter("join", this.cl.getValue("join"));
        engine.setParameter("index", this.cl.getValue("index"));
        engine.setParameter("exclude_tables", this.cl.getValue("exclude_tables"));
        engine.setParameter("exclude_fields", this.cl.getValue("exclude_fields"));
        engine.setParameter("associated_tables", this.cl.getValue("associated_tables"));
        engine.setParameter("max_depth", this.fixAdditionalArg(this.cl.getValue("max_depth", Integer.toString(this.maxDepth))));
        engine.setParameter("instead_null", this.cl.getValue("instead_null"));
        engine.setParameter("tree", this.cl.getValue("tree"));
        engine.setParameter("properties", this.cl.getValue("properties"));
        if (this.cl.exists("any_index")) {
            engine.setParameter("any_index", "yes");
        }
        if (this.cl.exists("use_foreign_keys")) {
            engine.setParameter("use_foreign_keys", "yes");
        }
        return ((Engine)engine).execute();
    }

    public static void main(String[] args) throws Exception {
        RELAGGS app = new RELAGGS();
        app.run(args);
    }
}

