/*
 * Decompiled with CFR 0.152.
 */
package proper.app;

import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tools.ant.Task;
import proper.app.Application;
import proper.app.Bagger;
import proper.app.Classifier;
import proper.app.Databases;
import proper.app.Experimenter;
import proper.app.Export;
import proper.app.Import;
import proper.app.MILK;
import proper.app.RELAGGS;
import proper.app.REMILK;
import proper.app.Tester;
import proper.io.Ant;
import proper.io.CommandLine;
import proper.io.TextFile;
import proper.util.Includer;
import proper.util.ProperVector;
import proper.util.Strings;

public class Jobs
extends Application {
    private Vector lines = new ProperVector();
    private Hashtable propsHash = new Hashtable();
    private Ant ant;
    private String currentFilename = "";

    @Override
    protected void defineParameters() {
        super.defineParameters();
        this.addDefinition("input", "a comma separated list of files to get the java calls from", true, "<filename(s)>", false);
        this.addDefinition("output", "the name of file to store the jobs in", true, "<filename>", false);
        this.addDefinition("append", "whether to append the jobs to the given file", false, "", true);
        this.addDefinition("url", "the url pointing to the host the database resides on", true, "<jdbc:subprotocol://host:port/>", true);
        this.addDefinition("exchange", "whether to add commands to retrieve and send files", false, "", true);
        this.addDefinition("target", "create the job files only for this target (comma separated list)", true, "<name[,name...]>", true);
        this.addDefinition("no_date", "this flag suppresses the output of the date comment in the job file", false, "", true);
    }

    @Override
    public void printDescription() {
        System.out.println("Extracts the Java calls from ANT files and creates jobs for the distributed");
        System.out.println("computing.");
        System.out.println();
    }

    private void initializeAnt(String filename) {
        if (!this.currentFilename.equals(filename)) {
            this.currentFilename = filename;
            this.ant = new Ant(filename);
        }
    }

    public String[][] getProperties(String filename) {
        this.initializeAnt(filename);
        Vector props = this.ant.getProperties(new Includer("output,datasets,doc,class,verbose,driver,url,user,password,sql_limit,sql_createdatabase,add_neg_class,max_depth,reduce_lists,classifier,additional,classifier-numerical,additional-numerical,milk-classifier,milk-additional,milk-classifier-numerical,milk-additional-numerical,groupby,join,validation-type,runs,folds,xterm,shell,nominal-filter,nominal-filter-additional,missing_binary_to_zero"));
        String[][] properties = new String[props.size()][2];
        int i = 0;
        while (i < properties.length) {
            properties[i][0] = (String)props.get(i);
            properties[i][1] = this.ant.getProperty(properties[i][0]);
            ++i;
        }
        i = 0;
        while (i < properties.length) {
            if (this.propsHash.containsKey(properties[i][0])) {
                properties[i][1] = (String)this.propsHash.get(properties[i][0]);
            }
            this.ant.setProperty(properties[i][0], properties[i][1]);
            ++i;
        }
        return properties;
    }

    private String getLogFilename(String classname, Vector args) {
        String result = "result.log";
        CommandLine cLine = new CommandLine(Strings.vectorToArray(args));
        if (classname.equals(Databases.class.getName())) {
            result = String.valueOf(this.ant.getProperty("output")) + "/" + cLine.getValue("database") + ".db";
        } else if (classname.equals(Import.class.getName())) {
            result = String.valueOf(this.ant.getProperty("output")) + "/" + cLine.getValue("database") + ".import";
        } else if (classname.equals(RELAGGS.class.getName())) {
            result = String.valueOf(this.ant.getProperty("output")) + "/" + cLine.getValue("database") + ".proper";
        } else if (classname.equals(MILK.class.getName())) {
            result = String.valueOf(this.ant.getProperty("output")) + "/" + cLine.getValue("database") + "-mi.proper";
        } else if (classname.equals(REMILK.class.getName())) {
            result = String.valueOf(this.ant.getProperty("output")) + "/" + cLine.getValue("database") + "-remi.proper";
        } else if (classname.equals(Export.class.getName())) {
            result = String.valueOf(this.ant.getProperty("output")) + "/" + cLine.getValue("database") + ".export";
        } else if (classname.equals(Bagger.class.getName())) {
            result = String.valueOf(this.ant.getProperty("output")) + "/" + cLine.getValue("database");
            result = cLine.getValue("table").equals("_remilk") || cLine.getValue("output").indexOf("-remi.arff") > -1 ? String.valueOf(result) + "-remi.export" : String.valueOf(result) + "-mi.export";
        } else if (classname.equals(Experimenter.class.getName())) {
            result = cLine.getValue("input").replaceAll("\\.arff", ".eval");
        } else if (classname.equals(Tester.class.getName())) {
            result = cLine.getValue("train").replaceAll("\\.arff", ".test");
        } else if (classname.equals(Classifier.class.getName())) {
            result = cLine.getValue("input").replaceAll("\\.arff", ".class");
        }
        return result;
    }

    public String[] getJobs(String filename) {
        this.initializeAnt(filename);
        ProperVector jobs = new ProperVector();
        String targetnames = this.cl.getValue("target");
        Vector targets = targetnames.equals("") ? this.ant.getTargets() : this.ant.getTargets(new Includer(targetnames));
        int i = 0;
        while (i < targets.size()) {
            Vector tasks = this.ant.getJavaTasks((String)targets.get(i));
            int n = 0;
            while (n < tasks.size()) {
                String job = this.ant.getClassname((Task)tasks.get(n));
                Vector args = this.ant.getArguments((Task)tasks.get(n));
                String previous = "";
                String arg = "";
                int m = 0;
                while (m < args.size()) {
                    if (m > 0) {
                        previous = arg;
                    }
                    arg = (String)args.get(m);
                    if (previous.equals("-log")) {
                        arg = this.getLogFilename(this.ant.getClassname((Task)tasks.get(n)), args);
                    }
                    if (previous.equals("-append_log")) {
                        arg = "no";
                    }
                    if (arg.indexOf(" ") > -1) {
                        arg = "\"" + arg + "\"";
                    }
                    job = String.valueOf(job) + " " + arg;
                    ++m;
                }
                jobs.add(job);
                ++n;
            }
            ++i;
        }
        return Strings.vectorToArray(jobs);
    }

    public String[] addAdditionalJobs(String[] jobs) {
        int i = 0;
        while (i < jobs.length) {
            if (jobs[i].indexOf("proper.app.Export") != -1 || jobs[i].indexOf("proper.app.Bagger") != -1 || jobs[i].indexOf("proper.app.Experimenter") != -1) {
                String tmp = jobs[i].replaceAll(".* -output ", "").replaceAll(" .*", "");
                jobs[i] = String.valueOf(jobs[i]) + ";" + "get_file" + " " + tmp + " " + tmp.replaceAll(".*/", "");
            }
            ++i;
        }
        return jobs;
    }

    public boolean process(String filename) {
        boolean result;
        System.out.println("Processing " + filename + "...");
        this.initializeAnt(filename);
        String[] jobs = null;
        String[][] properties = this.getProperties(filename);
        boolean bl = result = properties != null;
        if (result) {
            jobs = this.getJobs(filename);
            boolean bl2 = result = jobs != null;
        }
        if (result && this.cl.exists("exchange")) {
            jobs = this.addAdditionalJobs(jobs);
        }
        if (result) {
            this.lines.add("# ant -f " + filename + " " + this.cl.getValue("target").replaceAll(",", " "));
            int i = 0;
            while (i < jobs.length) {
                if (jobs[i] != null) {
                    this.lines.add(jobs[i]);
                }
                ++i;
            }
            this.lines.add("");
        }
        return result;
    }

    public boolean save(String filename) {
        System.out.println("Saving jobs to " + filename + "...");
        ProperVector data = new ProperVector();
        if (!this.cl.exists("no_date")) {
            data.add("# " + new Date());
            data.add("");
        }
        data.addAll(this.lines);
        return TextFile.save(filename, data, this.cl.exists("append"));
    }

    @Override
    protected boolean process() throws Exception {
        int i;
        boolean result = true;
        this.ant = null;
        this.lines.clear();
        this.propsHash.clear();
        if (!this.cl.getValue("properties").equals("")) {
            String[] tmp = Strings.breakUp(this.cl.getValue("properties"), ",", "\"");
            i = 0;
            while (i < tmp.length) {
                String[] prp = Strings.breakUp(tmp[i], "=", "\"", 1);
                if (prp.length == 2) {
                    this.propsHash.put(prp[0], prp[1]);
                }
                ++i;
            }
        }
        String[] files = Strings.fromCommalist(this.cl.getValue("input"));
        i = 0;
        while (i < files.length) {
            result = this.process(files[i]);
            if (!result) {
                System.out.println("Error processing '" + files[i] + "'!");
                break;
            }
            ++i;
        }
        if (result) {
            result = this.save(this.cl.getValue("output"));
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        Jobs app = new Jobs();
        app.run(args);
    }
}

