/*
 * Decompiled with CFR 0.152.
 */
package ida.utils.graphs;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class DirectedVertex {
    private Map<Integer, DirectedVertex> outVertices = new HashMap<Integer, DirectedVertex>();
    private Map<Integer, Integer> outDistances = new HashMap<Integer, Integer>();
    private Map<Integer, Integer> inDistances = new HashMap<Integer, Integer>();
    private Map<Integer, DirectedVertex> inVertices = new HashMap<Integer, DirectedVertex>();
    private Map<Integer, DirectedVertex> removedOutConnections = new HashMap<Integer, DirectedVertex>();
    private Map<Integer, DirectedVertex> removedInConnections = new HashMap<Integer, DirectedVertex>();
    private Object note;
    private int id;
    private int inDegree;
    private int outDegree;

    public DirectedVertex(int id) {
        this.id = id;
    }

    public Collection<DirectedVertex> inVertices() {
        return this.inVertices.values();
    }

    public Collection<DirectedVertex> outVertices() {
        return this.outVertices.values();
    }

    public int inDegree() {
        return this.inDegree;
    }

    public int outDegree() {
        return this.outDegree;
    }

    public int id() {
        return this.id;
    }

    public int hashCode() {
        return this.id;
    }

    public DirectedVertex reverseEdges() {
        DirectedVertex dv = new DirectedVertex(this.id);
        dv.inDegree = this.outDegree;
        dv.outDegree = this.inDegree;
        dv.outDistances.putAll(this.inDistances);
        dv.inVertices.putAll(this.outVertices);
        dv.outVertices.putAll(dv.inVertices);
        dv.outDistances.putAll(this.inDistances);
        return dv;
    }

    void disconnectFromOutVertices() {
        this.outDegree = 0;
        for (DirectedVertex adj : this.outVertices.values()) {
            adj.inVertices.remove(this.id());
            --adj.inDegree;
            this.removedOutConnections.put(adj.id(), adj);
        }
        this.outVertices.clear();
    }

    void disconnectFromInVertices() {
        this.inDegree = 0;
        for (DirectedVertex adj : this.inVertices.values()) {
            adj.outVertices.remove(this.id());
            --adj.outDegree;
            this.removedInConnections.put(adj.id(), adj);
        }
        this.inVertices.clear();
    }

    void restoreLinksToOutVertices() {
        for (DirectedVertex adj : this.removedOutConnections.values()) {
            this.inVertices.put(adj.id(), adj);
            adj.inVertices.put(this.id(), this);
            ++adj.inDegree;
        }
        this.removedOutConnections.clear();
    }

    void restoreLinksToInVertices() {
        for (DirectedVertex adj : this.removedInConnections.values()) {
            this.inVertices.put(adj.id(), adj);
            adj.outVertices.put(this.id(), this);
            ++adj.outDegree;
        }
        this.removedInConnections.clear();
    }

    public boolean equals(Object o) {
        if (o instanceof DirectedVertex) {
            return ((DirectedVertex)o).id == this.id;
        }
        return false;
    }

    public String toString() {
        return "[" + String.valueOf(this.id) + ", inDegree=" + this.inDegree + ", outDegree=" + this.outDegree + "]";
    }

    int outDistance(DirectedVertex v) {
        if (this.outDistances.containsKey(v.id())) {
            return this.outDistances.get(v.id());
        }
        return Integer.MAX_VALUE;
    }

    int inDistance(DirectedVertex v) {
        if (this.inDistances.containsKey(v.id())) {
            return this.inDistances.get(v.id());
        }
        return Integer.MAX_VALUE;
    }

    void setNote(Object note) {
        this.note = note;
    }

    Object getNote() {
        return this.note;
    }

    public static boolean areDirectlyConnected(DirectedVertex v1, DirectedVertex v2) {
        return v1.outVertices.containsKey(v2.id()) && v2.inVertices.containsKey(v1.id());
    }

    public static void connectDirected(DirectedVertex from, DirectedVertex to) {
        if (!from.equals(to) && !from.outVertices.containsKey(to.id())) {
            from.outVertices.put(to.id(), to);
            ++from.outDegree;
            to.inVertices.put(from.id(), from);
            ++to.inDegree;
        }
    }

    public static void connectDirected(DirectedVertex from, DirectedVertex to, int distance) {
        if (!from.equals(to) && !from.outVertices.containsKey(to.id())) {
            from.outVertices.put(to.id(), to);
            ++from.outDegree;
            from.outDistances.put(to.id(), distance);
            to.inVertices.put(from.id(), from);
            ++to.inDegree;
            to.inDistances.put(from.id(), distance);
        }
    }

    public static void disconnect(DirectedVertex from, DirectedVertex to) {
        if (from.outVertices.containsKey(to.id())) {
            from.outVertices.remove(to.id());
            --from.outDegree;
            if (from.outDistances.containsKey(to.id())) {
                from.outDistances.remove(to.id());
            }
            to.inVertices.remove(from.id());
            --to.inDegree;
            if (to.inDistances.containsKey(from.id())) {
                to.inDistances.remove(to.id());
            }
        }
    }
}

