/*
 * Decompiled with CFR 0.152.
 */
package ida.utils.collections;

import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class BigIntegerCounters<T> {
    private HashMap<T, BigInteger> map = new HashMap();

    public void add(T key, BigInteger value) {
        this.addPre(key, value);
    }

    public BigInteger addPre(T key, BigInteger value) {
        if (!this.map.containsKey(key)) {
            this.map.put(key, value);
        } else {
            this.map.put(key, this.map.get(key).add(value));
        }
        return this.map.get(key);
    }

    public BigInteger addPost(T key, BigInteger value) {
        BigInteger oldValue = BigInteger.ZERO;
        if (!this.map.containsKey(key)) {
            this.map.put(key, value);
        } else {
            oldValue = this.map.get(key);
            this.map.put(key, this.map.get(key).add(value));
        }
        return oldValue;
    }

    public void increment(T key) {
        this.incrementPre(key);
    }

    public void decrement(T key) {
        this.decrementPre(key);
    }

    public BigInteger get(T key) {
        if (!this.map.containsKey(key)) {
            return BigInteger.ZERO;
        }
        return this.map.get(key);
    }

    public BigInteger incrementPre(T key) {
        if (!this.map.containsKey(key)) {
            this.map.put(key, BigInteger.ONE);
        } else {
            this.map.put(key, this.map.get(key).add(BigInteger.ONE));
        }
        return this.map.get(key);
    }

    public BigInteger incrementPost(T key) {
        if (!this.map.containsKey(key)) {
            this.map.put(key, BigInteger.ONE);
        } else {
            this.map.put(key, this.map.get(key).add(BigInteger.ONE));
        }
        return this.map.get(key).subtract(BigInteger.ONE);
    }

    public BigInteger decrementPre(T key) {
        if (!this.map.containsKey(key)) {
            this.map.put(key, BigInteger.valueOf(-1L));
        } else {
            this.map.put(key, this.map.get(key).subtract(BigInteger.ONE));
        }
        return this.map.get(key);
    }

    public BigInteger decrementPost(T key) {
        if (!this.map.containsKey(key)) {
            this.map.put(key, BigInteger.valueOf(-1L));
        } else {
            this.map.put(key, this.map.get(key).subtract(BigInteger.ONE));
        }
        return this.map.get(key).add(BigInteger.ONE);
    }

    public Set<T> keySet() {
        return this.map.keySet();
    }

    public Collection<BigInteger> counts() {
        return this.map.values();
    }

    public void addAll(BigIntegerCounters<T> counters) {
        for (Map.Entry<T, BigInteger> entry : counters.map.entrySet()) {
            if (this.map.containsKey(entry.getKey())) {
                this.map.put(entry.getKey(), this.map.get(entry.getKey()).add(entry.getValue()));
                continue;
            }
            this.map.put(entry.getKey(), entry.getValue());
        }
    }

    public String toString() {
        return this.map.toString();
    }

    public Map<T, BigInteger> toMap() {
        HashMap<T, BigInteger> copy = new HashMap<T, BigInteger>();
        copy.putAll(this.map);
        return copy;
    }
}

