/*
 * Decompiled with CFR 0.152.
 */
package ida.utils;

import ida.utils.tuples.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Parallel {
    private boolean stop = false;
    private final List<WorkerThread> workers = Collections.synchronizedList(new ArrayList());
    private final List<Pair<Runnable, Int>> tasks = Collections.synchronizedList(new ArrayList());

    public Parallel(int threadCount) {
        for (int i = 0; i < threadCount; ++i) {
            WorkerThread worker = new WorkerThread();
            this.workers.add(worker);
            worker.start();
        }
    }

    public void stop() {
        this.stop = true;
        this.tasks.notifyAll();
    }

    public void runTasks(List<? extends Runnable> tasks) {
        Runnable[] ts = new Runnable[tasks.size()];
        int i = 0;
        Iterator<? extends Runnable> i$ = tasks.iterator();
        while (i$.hasNext()) {
            Runnable task;
            ts[i] = task = i$.next();
            ++i;
        }
        this.runTasks(ts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTasks(Runnable ... task) {
        Int counter = new Int(task.length);
        for (Runnable r : task) {
            List<Pair<Runnable, Int>> list = this.tasks;
            synchronized (list) {
                this.tasks.add(new Pair<Runnable, Int>(r, counter));
                this.tasks.notify();
            }
        }
        Int intVal = counter;
        synchronized (intVal) {
            while (counter.value > 0) {
                try {
                    counter.wait();
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                }
            }
        }
    }

    public void finalize() {
        this.stop = true;
    }

    private class WorkerThread
    extends Thread {
        public WorkerThread() {
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!Parallel.this.stop) {
                Pair task = null;
                Object object = Parallel.this.tasks;
                synchronized (object) {
                    if (Parallel.this.tasks.isEmpty()) {
                        try {
                            Parallel.this.tasks.wait();
                        }
                        catch (InterruptedException ie) {
                            ie.printStackTrace();
                        }
                    }
                    if (Parallel.this.tasks.size() > 0) {
                        task = (Pair)Parallel.this.tasks.remove(Parallel.this.tasks.size() - 1);
                    }
                }
                if (task == null) continue;
                ((Runnable)task.r).run();
                object = (Int)task.s;
                synchronized (object) {
                    --((Int)task.s).value;
                    ((Int)task.s).notify();
                }
            }
        }
    }

    private static class Int {
        int value;

        public Int() {
        }

        public Int(int value) {
            this.value = value;
        }
    }
}

