/*
 * Decompiled with CFR 0.152.
 */
package ida.ilp.treeLiker.impl;

import ida.ilp.treeLiker.PredicateDefinition;
import ida.utils.collections.MultiMap;
import ida.utils.collections.ValueToIndex;
import ida.utils.graphs.DirectedGraph;
import ida.utils.graphs.DirectedVertex;
import ida.utils.graphs.GraphAlgorithms;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FeatureSearchUtils {
    public static List<PredicateDefinition> buildPredicateList(Collection<PredicateDefinition> definitions) {
        List<PredicateDefinition> retVal = FeatureSearchUtils.topologicalOrderOnTypes(FeatureSearchUtils.buildPartialOrderOnTypes(definitions));
        for (PredicateDefinition def : definitions) {
            if (!FeatureSearchUtils.hasNoInputsAndOutputs(def)) continue;
            retVal.add(def);
        }
        return retVal;
    }

    private static boolean hasNoInputsAndOutputs(PredicateDefinition def) {
        for (int i = 0; i < def.arity(); ++i) {
            if (def.modes()[i] != 1 && def.modes()[i] != 2) continue;
            return false;
        }
        return true;
    }

    static List<PredicateDefinition> topologicalOrderOnTypes(MultiMap<PredicateDefinition, PredicateDefinition> prerequisities) {
        ValueToIndex<PredicateDefinition> definitions = new ValueToIndex<PredicateDefinition>();
        HashMap<Integer, DirectedVertex> map = new HashMap<Integer, DirectedVertex>();
        for (Map.Entry<PredicateDefinition, Set<PredicateDefinition>> entry : prerequisities.entrySet()) {
            int startVertexID = definitions.valueToIndex(entry.getKey());
            if (!map.containsKey(startVertexID)) {
                map.put(startVertexID, new DirectedVertex(startVertexID));
            }
            DirectedVertex start = (DirectedVertex)map.get(startVertexID);
            for (PredicateDefinition def : entry.getValue()) {
                int endVertexID = definitions.valueToIndex(def);
                if (!map.containsKey(endVertexID)) {
                    map.put(endVertexID, new DirectedVertex(endVertexID));
                }
                DirectedVertex end = (DirectedVertex)map.get(endVertexID);
                DirectedVertex.connectDirected(end, start);
            }
        }
        DirectedGraph graph = new DirectedGraph(map.values());
        List<DirectedVertex> ordered = GraphAlgorithms.topologicalOrder(graph);
        ArrayList<PredicateDefinition> list = new ArrayList<PredicateDefinition>();
        if (ordered != null) {
            for (DirectedVertex dv : ordered) {
                list.add((PredicateDefinition)definitions.indexToValue(dv.id()));
            }
        }
        return list;
    }

    static MultiMap<PredicateDefinition, PredicateDefinition> buildPartialOrderOnTypes(Collection<PredicateDefinition> definitions) {
        MultiMap<Integer, PredicateDefinition> defByType = new MultiMap<Integer, PredicateDefinition>();
        for (PredicateDefinition def : definitions) {
            int[] modes = def.modes();
            int[] types = def.types();
            for (int i = 0; i < def.types().length; ++i) {
                if (modes[i] != 1) continue;
                defByType.put(types[i], def);
            }
        }
        MultiMap<PredicateDefinition, PredicateDefinition> bag = new MultiMap<PredicateDefinition, PredicateDefinition>();
        for (PredicateDefinition def : definitions) {
            int[] modes = def.modes();
            int[] types = def.types();
            for (int i = 0; i < def.types().length; ++i) {
                if (modes[i] != 2) continue;
                for (PredicateDefinition prereq : defByType.get(types[i])) {
                    bag.put(def, prereq);
                }
            }
        }
        return bag;
    }
}

