/*
 * Decompiled with CFR 0.152.
 */
package ida.ilp.treeLiker.impl;

import ida.ilp.treeLiker.Dataset;
import ida.ilp.treeLiker.Domain;
import ida.ilp.treeLiker.Example;
import ida.ilp.treeLiker.HavingLiteralDomain;
import ida.ilp.treeLiker.HavingTermDomain;
import ida.utils.Sugar;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DomainComputing {
    private Dataset examples;

    public DomainComputing(Dataset examples) {
        this.examples = examples;
    }

    public Domain[] computeTermDomains(HavingTermDomain htd) {
        Domain[] domains = new Domain[this.examples.countExamples()];
        int index = 0;
        Dataset localExamples = this.examples.shallowCopy();
        localExamples.reset();
        while (localExamples.hasNextExample()) {
            Example example = localExamples.nextExample();
            domains[index] = htd.termDomain(example);
            ++index;
        }
        return domains;
    }

    public Domain[] computeLiteralDomains(HavingLiteralDomain hld) {
        Domain[] domains = new Domain[this.examples.countExamples()];
        int index = 0;
        Dataset localExamples = this.examples.shallowCopy();
        localExamples.reset();
        while (localExamples.hasNextExample()) {
            Example example = localExamples.nextExample();
            domains[index] = hld.literalDomain(example);
            ++index;
        }
        return domains;
    }

    public ConcurrentHashMap<Integer, Domain[]> computeTermDomainsInParallel(Collection<? extends HavingTermDomain> candidates) {
        Dataset[] datasetArray;
        ConcurrentHashMap<Integer, Domain[]> domains = new ConcurrentHashMap<Integer, Domain[]>();
        for (HavingTermDomain havingTermDomain : candidates) {
            domains.put(havingTermDomain.id(), new Domain[this.examples.countExamples()]);
        }
        ArrayList<TermDomainsComputation> tasks = new ArrayList<TermDomainsComputation>();
        for (Dataset es : datasetArray = this.examples.split(Runtime.getRuntime().availableProcessors())) {
            tasks.add(new TermDomainsComputation(candidates, es, domains));
        }
        Sugar.runInParallel(tasks);
        return domains;
    }

    public ConcurrentHashMap<Integer, Domain[]> computeLiteralDomainsInParallel(Collection<? extends HavingLiteralDomain> candidates) {
        Dataset[] datasetArray;
        ConcurrentHashMap<Integer, Domain[]> domains = new ConcurrentHashMap<Integer, Domain[]>();
        for (HavingLiteralDomain havingLiteralDomain : candidates) {
            domains.put(havingLiteralDomain.id(), new Domain[this.examples.countExamples()]);
        }
        ArrayList<LiteralDomainsComputation> tasks = new ArrayList<LiteralDomainsComputation>();
        for (Dataset es : datasetArray = this.examples.split(Runtime.getRuntime().availableProcessors())) {
            tasks.add(new LiteralDomainsComputation(candidates, es, domains));
        }
        Sugar.runInParallel(tasks);
        return domains;
    }

    private void computeTermDomains(Collection<? extends HavingTermDomain> candidates, Dataset examples, Map<Integer, Domain[]> domains) {
        Dataset localExamples = examples.shallowCopy();
        localExamples.reset();
        while (localExamples.hasNextExample()) {
            Example example = localExamples.nextExample();
            for (HavingTermDomain havingTermDomain : candidates) {
                Domain domain;
                if (domains.get(havingTermDomain.id())[localExamples.currentIndex()] != null) continue;
                domains.get((Object)Integer.valueOf((int)havingTermDomain.id()))[localExamples.currentIndex()] = domain = havingTermDomain.termDomain(example);
            }
        }
    }

    private void computeLiteralDomains(Collection<? extends HavingLiteralDomain> candidates, Dataset examples, Map<Integer, Domain[]> domains) {
        Dataset localExamples = examples.shallowCopy();
        localExamples.reset();
        while (localExamples.hasNextExample()) {
            Example example = localExamples.nextExample();
            for (HavingLiteralDomain havingLiteralDomain : candidates) {
                Domain domain;
                if (domains.get(havingLiteralDomain.id())[localExamples.currentIndex()] != null) continue;
                domains.get((Object)Integer.valueOf((int)havingLiteralDomain.id()))[localExamples.currentIndex()] = domain = havingLiteralDomain.literalDomain(example);
            }
        }
    }

    private class LiteralDomainsComputation
    implements Runnable {
        private Map<Integer, Domain[]> doms;
        private Collection<? extends HavingLiteralDomain> cands;
        private Dataset exs;

        public LiteralDomainsComputation(Collection<? extends HavingLiteralDomain> candidates, Dataset examples, Map<Integer, Domain[]> output) {
            this.cands = candidates;
            this.exs = examples;
            this.doms = output;
        }

        @Override
        public void run() {
            DomainComputing.this.computeLiteralDomains(this.cands, this.exs, this.doms);
        }
    }

    private class TermDomainsComputation
    implements Runnable {
        private Map<Integer, Domain[]> doms;
        private Collection<? extends HavingTermDomain> cands;
        private Dataset exs;

        public TermDomainsComputation(Collection<? extends HavingTermDomain> candidates, Dataset examples, Map<Integer, Domain[]> output) {
            this.cands = candidates;
            this.exs = examples;
            this.doms = output;
        }

        @Override
        public void run() {
            DomainComputing.this.computeTermDomains(this.cands, this.exs, this.doms);
        }
    }
}

