/*
 * Decompiled with CFR 0.152.
 */
package ida.ilp.treeLiker.aggregables;

import ida.ilp.treeLiker.Aggregable;
import ida.utils.Cache;
import ida.utils.VectorUtils;
import ida.utils.tuples.Pair;
import ida.utils.tuples.Tuple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class PolyAggregable
implements Aggregable {
    private int numVariables;
    private int maxDegree;
    private double samples;
    private double[] monomials;
    private int hashCode = -1;
    private static Cache<Pair<Integer, Integer>, List<Tuple<Integer>>> monomialCache = new Cache();

    public PolyAggregable(int numVariables, int maxDegree, double[] monomials, double samples) {
        this.numVariables = numVariables;
        this.maxDegree = maxDegree;
        this.monomials = monomials;
        this.samples = samples;
    }

    @Override
    public Aggregable cross(Aggregable agg) {
        PolyAggregable pa = (PolyAggregable)agg;
        if (pa.numVariables == 0) {
            return new PolyAggregable(this.numVariables, this.maxDegree, this.monomials, this.samples * pa.samples);
        }
        if (this.numVariables == 0) {
            return new PolyAggregable(pa.numVariables, pa.maxDegree, pa.monomials, this.samples * pa.samples);
        }
        HashMap<Tuple<Integer>, Double> values = new HashMap<Tuple<Integer>, Double>();
        List<Tuple<Integer>> myExponents = PolyAggregable.allMonomialExponents(this.numVariables, this.maxDegree);
        List<Tuple<Integer>> paExponents = PolyAggregable.allMonomialExponents(pa.numVariables, pa.maxDegree);
        for (int i = 0; i < this.monomials.length; ++i) {
            Tuple<Integer> myExponent = myExponents.get(i);
            for (int j = 0; j < pa.monomials.length; ++j) {
                Tuple<Integer> paExponent = paExponents.get(j);
                if (myExponent.getExtraInt() + paExponent.getExtraInt() > this.maxDegree) continue;
                values.put(Tuple.merge(myExponent, paExponent), this.monomials[i] * pa.monomials[j]);
            }
        }
        List<Tuple<Integer>> newExponents = PolyAggregable.allMonomialExponents(this.numVariables + pa.numVariables, pa.maxDegree);
        double[] newValues = new double[newExponents.size()];
        int index = 0;
        for (Tuple<Integer> e : newExponents) {
            newValues[index] = (Double)values.get(e);
            ++index;
        }
        return new PolyAggregable(pa.numVariables + this.numVariables, this.maxDegree, newValues, this.samples * pa.samples);
    }

    @Override
    public Aggregable plus(Aggregable agg) {
        PolyAggregable pa = (PolyAggregable)agg;
        if (this.numVariables != pa.numVariables || pa.maxDegree != this.maxDegree) {
            throw new IllegalArgumentException("The operations plus can be applied only to aggregables with equal numVariables and maxDegree");
        }
        double[] newMonomials = new double[this.monomials.length];
        for (int i = 0; i < newMonomials.length; ++i) {
            newMonomials[i] = (this.samples * this.monomials[i] + pa.samples * pa.monomials[i]) / (this.samples + pa.samples);
        }
        return new PolyAggregable(this.numVariables, this.maxDegree, newMonomials, this.samples + pa.samples);
    }

    public double samples() {
        return this.samples;
    }

    public double[] monomials() {
        return this.monomials;
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            int hash = 7;
            hash = 53 * hash + (int)(Double.doubleToLongBits(this.samples) ^ Double.doubleToLongBits(this.samples) >>> 32);
            this.hashCode = hash = 53 * hash + Arrays.hashCode(this.monomials);
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PolyAggregable other = (PolyAggregable)obj;
        if (this.hashCode() != other.hashCode()) {
            return false;
        }
        if (Double.doubleToLongBits(this.samples) != Double.doubleToLongBits(other.samples)) {
            return false;
        }
        return Arrays.equals(this.monomials, other.monomials);
    }

    public String toString() {
        return "PolyAggregable[monomials=" + VectorUtils.doubleArrayToString(this.monomials) + ", n = " + this.samples + "]";
    }

    public static List<Tuple<Integer>> allMonomialExponents(int numVariables, int maxDegree) {
        List<Tuple<Integer>> retVal = null;
        retVal = monomialCache.get(new Pair<Integer, Integer>(numVariables, maxDegree));
        if (retVal == null) {
            ArrayList<Tuple<Integer>> monomials = new ArrayList<Tuple<Integer>>();
            monomials.add(new Tuple<Integer>(new Integer[0]));
            for (int i = 0; i < numVariables; ++i) {
                ArrayList<Tuple<Integer>> newMonomials = new ArrayList<Tuple<Integer>>();
                for (Tuple tuple : monomials) {
                    for (int j = 1; j <= maxDegree - tuple.getExtraInt(); ++j) {
                        Tuple<Integer> newTuple = Tuple.append(tuple, j);
                        newTuple.setExtraInt(tuple.getExtraInt() + j);
                        newMonomials.add(newTuple);
                    }
                }
                monomials = newMonomials;
            }
            monomialCache.put(new Pair<Integer, Integer>(numVariables, maxDegree), monomials);
            retVal = monomials;
        }
        return retVal;
    }

    public int maxDegree() {
        return this.maxDegree;
    }
}

