/*
 * Decompiled with CFR 0.152.
 */
package ida.ilp.basic;

import ida.ilp.basic.Constant;
import ida.ilp.basic.ParserUtils;
import ida.ilp.basic.Term;
import ida.ilp.basic.Variable;
import ida.utils.tuples.Pair;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PrologList
implements Term {
    private int hashCode = -1;
    private Term[] items;
    private String toString;

    public PrologList(int itemsCount) {
        this.items = new Term[itemsCount];
    }

    public PrologList(List<Term> termList) {
        this(termList.size());
        int index = 0;
        Iterator<Term> i$ = termList.iterator();
        while (i$.hasNext()) {
            Term t;
            this.items[index] = t = i$.next();
            ++index;
        }
    }

    public Term get(int index) {
        return this.items[index];
    }

    public void set(Term term, int index) {
        this.items[index] = term;
    }

    public int countItems() {
        return this.items.length;
    }

    public boolean equals(Object o) {
        if (o instanceof PrologList) {
            PrologList pl = (PrologList)o;
            return pl.toString().equals(this.toString());
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = this.toString().hashCode();
        }
        return this.hashCode;
    }

    public String toString() {
        if (this.toString == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            for (int i = 0; i < this.items.length; ++i) {
                sb.append(this.items[i]);
                if (i >= this.items.length - 1) continue;
                sb.append(", ");
            }
            sb.append("]");
            this.toString = sb.toString();
        }
        return this.toString;
    }

    @Override
    public String name() {
        return this.toString();
    }

    public PrologList flatten() {
        ArrayList<Term> termList = new ArrayList<Term>();
        this.flatten(this, termList);
        return new PrologList(termList);
    }

    private void flatten(PrologList prologList, List<Term> termList) {
        for (Term t : prologList.items) {
            if (t instanceof PrologList) {
                this.flatten((PrologList)t, termList);
                continue;
            }
            termList.add(t);
        }
    }

    public static PrologList parseList(String str, Map<String, Variable> variables, Map<String, Constant> constants) {
        char[] c = str.toCharArray();
        ArrayList items = new ArrayList();
        for (int index = 1; index < c.length && c[index] != ']'; ++index) {
            if (c[index] == ' ') continue;
            Pair<Term, Integer> pair = ParserUtils.parseTerm(c, index, ']', variables, constants);
            items.add(pair.r);
            index = (Integer)pair.s;
        }
        PrologList retVal = new PrologList(items.size());
        for (int i = 0; i < items.size(); ++i) {
            retVal.set((Term)items.get(i), i);
        }
        return retVal;
    }
}

