/*
 * Decompiled with CFR 0.152.
 */
package ida.ilp.basic;

import ida.ilp.basic.Constant;
import ida.ilp.basic.Literal;
import ida.ilp.basic.Term;
import ida.ilp.basic.Variable;
import ida.utils.Sugar;
import ida.utils.collections.MultiMap;
import ida.utils.tuples.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class Clause {
    private LinkedHashSet<Literal> literals = new LinkedHashSet();
    private MultiMap<String, Literal> literalsByName;
    private MultiMap<Term, Literal> literalsByTerms;
    private int hashCode = -1;

    public Clause(Collection<Literal> literals) {
        for (Literal l : literals) {
            l.allowModifications(false);
            this.addLiteral(l);
        }
    }

    public void addLiterals(Collection<Literal> c) {
        this.hashCode = -1;
        for (Literal l : c) {
            this.addLiteral(l);
        }
    }

    public void addLiteral(Literal literal) {
        this.hashCode = -1;
        if (!this.literals.contains(literal)) {
            this.literals.add(literal);
        }
        if (this.literalsByName != null) {
            this.literalsByName.put(literal.predicate(), literal);
        }
        if (this.literalsByTerms != null) {
            for (int i = 0; i < literal.arity(); ++i) {
                this.literalsByTerms.put(literal.get(i), literal);
            }
        }
    }

    private void initLiteralsByTerms() {
        this.literalsByTerms = new MultiMap();
        for (Literal literal : this.literals) {
            for (int i = 0; i < literal.arity(); ++i) {
                this.literalsByTerms.put(literal.get(i), literal);
            }
        }
    }

    private void initLiteralsByName() {
        this.literalsByName = new MultiMap();
        for (Literal literal : this.literals) {
            this.literalsByName.put(literal.predicate(), literal);
        }
    }

    public boolean isSubsetOf(Clause clause) {
        HashSet<Literal> set = new HashSet<Literal>();
        set.addAll(clause.literals);
        for (Literal l : this.literals) {
            if (set.contains(l)) continue;
            return false;
        }
        return true;
    }

    public int countLiterals() {
        return this.literals.size();
    }

    public Map<Term, Integer> termFrequenciesModLiterals() {
        if (this.literalsByTerms == null) {
            this.initLiteralsByTerms();
        }
        HashMap<Term, Integer> frequencies = new HashMap<Term, Integer>();
        for (Map.Entry<Term, Set<Literal>> entry : this.literalsByTerms.entrySet()) {
            frequencies.put(entry.getKey(), entry.getValue().size());
        }
        return frequencies;
    }

    public Map<Variable, Integer> variableFrequenciesModLiterals() {
        if (this.literalsByTerms == null) {
            this.initLiteralsByTerms();
        }
        HashMap<Variable, Integer> frequencies = new HashMap<Variable, Integer>();
        for (Map.Entry<Term, Set<Literal>> entry : this.literalsByTerms.entrySet()) {
            if (!(entry.getKey() instanceof Variable)) continue;
            frequencies.put((Variable)entry.getKey(), entry.getValue().size());
        }
        return frequencies;
    }

    public LinkedHashSet<Literal> literals() {
        return this.literals;
    }

    public Set<String> predicates() {
        if (this.literalsByName == null) {
            this.initLiteralsByName();
        }
        return this.literalsByName.keySet();
    }

    public Collection<Literal> getLiteralsByPredicate(String predicate) {
        if (this.literalsByName == null) {
            this.initLiteralsByName();
        }
        return this.literalsByName.get(predicate);
    }

    public Collection<Literal> getLiteralsByTerm(Term term) {
        if (this.literalsByTerms == null) {
            this.initLiteralsByTerms();
        }
        return this.literalsByTerms.get(term);
    }

    public boolean containsLiteral(Literal literal) {
        return this.literals.contains(literal);
    }

    public Set<Variable> variables() {
        if (this.literalsByTerms == null) {
            this.initLiteralsByTerms();
        }
        HashSet<Variable> set = new HashSet<Variable>();
        for (Map.Entry<Term, Set<Literal>> entry : this.literalsByTerms.entrySet()) {
            if (!(entry.getKey() instanceof Variable) || entry.getValue().size() <= 0) continue;
            set.add((Variable)entry.getKey());
        }
        return set;
    }

    public Set<Term> terms() {
        if (this.literalsByTerms == null) {
            this.initLiteralsByTerms();
        }
        return this.literalsByTerms.keySet();
    }

    public static Clause parse(String str) {
        if ((str = str.trim()).charAt(str.length() - 1) == '.') {
            str = str.substring(0, str.length() - 1);
        }
        str = str + ", ";
        int brackets = 0;
        boolean inQuotes = false;
        boolean ignoreNext = false;
        ArrayList<String> splitted = new ArrayList<String>();
        char[] chars = str.toCharArray();
        StringBuilder sb = new StringBuilder();
        int index1 = 0;
        for (char c : chars) {
            if (ignoreNext) {
                sb.append(c);
                ignoreNext = false;
            } else if (inQuotes) {
                sb.append(c);
                if (c == '\'') {
                    inQuotes = false;
                }
            } else {
                switch (c) {
                    case '\\': {
                        ignoreNext = true;
                        break;
                    }
                    case '\t': 
                    case '\n': 
                    case ' ': {
                        break;
                    }
                    case '\'': {
                        inQuotes = !inQuotes;
                        sb.append(c);
                        break;
                    }
                    case '(': {
                        ++brackets;
                        sb.append(c);
                        break;
                    }
                    case ')': {
                        --brackets;
                        sb.append(c);
                        break;
                    }
                    case ',': {
                        if (brackets == 0) {
                            splitted.add(sb.toString());
                            sb = new StringBuilder();
                            break;
                        }
                        sb.append(c);
                        break;
                    }
                    default: {
                        sb.append(c);
                    }
                }
            }
            ++index1;
        }
        HashMap<String, Variable> variables = new HashMap<String, Variable>();
        HashMap<String, Constant> constants = new HashMap<String, Constant>();
        ArrayList<Literal> parsedLiterals = new ArrayList<Literal>();
        for (String s : splitted) {
            if (s.trim().length() <= 0) continue;
            parsedLiterals.add(Literal.parseLiteral(s.trim(), variables, constants));
        }
        int anonymousIndex = 1;
        for (Literal l : parsedLiterals) {
            for (int i = 0; i < l.arity(); ++i) {
                if (!l.get(i).name().equals("_")) continue;
                Variable an = Variable.construct("_" + anonymousIndex++);
                while (variables.containsKey(an.name())) {
                    an = Variable.construct("_" + anonymousIndex++);
                }
                l.set((Term)an, i);
                variables.put(an.name(), an);
            }
        }
        return new Clause(parsedLiterals);
    }

    public String toString() {
        return this.toPrologLikeString();
    }

    private String toPrologLikeString() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        int numLiterals = this.literals.size();
        for (Literal l : this.literals) {
            sb.append(l.toString());
            if (i < numLiterals - 1) {
                sb.append(", ");
            }
            ++i;
        }
        return sb.toString();
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = this.toString().hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o instanceof Clause) {
            Clause c = (Clause)o;
            return this.isSubsetOf(c) && c.isSubsetOf(this);
        }
        return false;
    }

    public Collection<Clause> connectedComponents() {
        return this.connectedComponents(false);
    }

    public Collection<Clause> connectedComponents(boolean justVariables) {
        if (this.literalsByTerms == null) {
            this.initLiteralsByTerms();
        }
        Collection<Term> remainingTerms = justVariables ? this.variables() : this.literalsByTerms.keySet();
        ArrayList<Clause> components = new ArrayList<Clause>();
        while (remainingTerms.size() > 0) {
            Pair<Clause, Set<? extends Term>> pair = this.connectedComponent(Sugar.chooseOne(remainingTerms), justVariables);
            components.add((Clause)pair.r);
            remainingTerms = Sugar.collectionDifference(remainingTerms, (Collection)pair.s);
        }
        if (justVariables) {
            for (Literal l : this.literals) {
                if (l.containsVariable()) continue;
                components.add(new Clause(Sugar.set(l)));
            }
        }
        return components;
    }

    private Pair<Clause, Set<? extends Term>> connectedComponent(Term termInComponent, boolean justVariables) {
        int i;
        HashSet<Term> closed = new HashSet<Term>();
        Stack<Term> open = new Stack<Term>();
        HashSet<Term> openSet = new HashSet<Term>();
        for (Literal literal : this.getLiteralsByTerm(termInComponent)) {
            for (int i2 = 0; i2 < literal.arity(); ++i2) {
                if (justVariables && !(literal.get(i2) instanceof Variable)) continue;
                open.push(literal.get(i2));
            }
        }
        while (!open.isEmpty()) {
            Term term = (Term)open.pop();
            if (closed.contains(term)) continue;
            for (Literal literal : this.getLiteralsByTerm(term)) {
                for (i = 0; i < literal.arity(); ++i) {
                    if (closed.contains(literal.get(i)) || openSet.contains(literal.get(i)) || justVariables && !(literal.get(i) instanceof Variable)) continue;
                    open.push(literal.get(i));
                    openSet.add(literal.get(i));
                }
            }
            closed.add(term);
        }
        HashSet<Literal> lits = new HashSet<Literal>();
        block5: for (Literal literal : this.literals()) {
            for (i = 0; i < literal.arity(); ++i) {
                if (justVariables && !(literal.get(i) instanceof Variable) || !closed.contains(literal.get(i))) continue;
                lits.add(literal);
                continue block5;
            }
        }
        return new Pair<Clause, Set<? extends Term>>(new Clause(lits), closed);
    }
}

