# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['mcpack']

package_data = \
{'': ['*']}

install_requires = \
['nbtlib>=1.4,<2.0']

setup_kwargs = {
    'name': 'mcpack',
    'version': '0.3.9',
    'description': 'A python library for programmatically creating and editing Minecraft data packs',
    'long_description': '<h3 align="center">⚠️ THIS PROJECT IS DEPRECATED ⚠️</h3>\n<h3 align="center">Please migrate to <a href="https://github.com/vberlier/beet">https://github.com/vberlier/beet</a></h3>\n\n---\n\n# mcpack\n\n[![Build Status](https://travis-ci.com/vberlier/mcpack.svg?branch=master)](https://travis-ci.com/vberlier/mcpack)\n[![PyPI](https://img.shields.io/pypi/v/mcpack.svg)](https://pypi.org/project/mcpack/)\n[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mcpack.svg)](https://pypi.org/project/mcpack/)\n\n> A python library for programmatically creating and editing [Minecraft data packs](https://minecraft.gamepedia.com/Data_pack). Requires python 3.7.\n\n```py\nfrom mcpack import DataPack, Function\n\npack = DataPack(\'My cool pack\', \'This is the description of my pack.\')\n\npack[\'my_cool_pack:hello\'] = Function(\n    \'say Hello, world!\\n\'\n    \'give @s minecraft:dead_bush\\n\'\n)\n\npack.dump(\'.minecraft/saves/New World/datapacks\')\n```\n\n## Installation\n\nMake sure that you\'re using python 3.7 or above. The package can be installed with `pip`.\n\n```sh\n$ pip install mcpack\n```\n\n## Using mcpack\n\n> Check out the [examples](https://github.com/vberlier/mcpack/tree/master/examples) for a quick overview.\n\n### Creating a data pack\n\nThe `DataPack` class represents a minecraft data pack.\n\n```py\nfrom mcpack import DataPack\n\npack = DataPack(\'Test\', \'Test description.\')\n\nprint(pack.name)  # \'Test\'\nprint(pack.description)  # \'Test description.\'\nprint(pack.pack_format)  # 1\nprint(pack.namespaces)  # defaultdict(<class \'mcpack.Namespace\'>, {})\n```\n\nYou can load already existing data packs using the `load` class method.\n\n```py\nfrom mcpack import DataPack\n\npack = DataPack.load(\'.minecraft/save/New World/datapacks/Test\')\n```\n\nThe `dump` method allows you to generate the actual Minecraft data pack. The method will raise a `ValueError` if the data pack already exists. You can explicitly overwrite the existing data pack by setting the `overwrite` argument to `True`.\n\n```py\nfrom mcpack import DataPack\n\npack = DataPack(\'Test\', \'Test description.\')\n\npack.dump(\'.minecraft/save/New World/datapacks\')\npack.dump(\'.minecraft/save/New World/datapacks\', overwrite=True)\n```\n\n### Namespaces\n\n`Namespace` objects hold references to data pack items using a separate dictionary for each type of item.\n\n```py\nfrom mcpack import Namespace\n\nnamespace = Namespace()\n\nprint(namespace.advancements)  # {}\nprint(namespace.functions)  # {}\nprint(namespace.loot_tables)  # {}\nprint(namespace.recipes)  # {}\nprint(namespace.structures)  # {}\nprint(namespace.block_tags)  # {}\nprint(namespace.item_tags)  # {}\nprint(namespace.fluid_tags)  # {}\nprint(namespace.function_tags)  # {}\nprint(namespace.entity_type_tags)  # {}\n```\n\nYou can add namespaces to `DataPack` objects using the `namespaces` attribute. Note that you won\'t usually need to create namespaces yourself. If you want to edit a namespace, you just need to retrieve it and the `defaultdict` will create an empty namespace for you if it doesn\'t already exist.\n\n```py\nfrom mcpack import DataPack\n\npack = DataPack(\'Test\', \'Test description.\')\n\nprint(pack.namespaces[\'test\'])  # Namespace(...)\n```\n\nTo make things even more convenient, the `__getitem__` and `__setitem__` methods of `DataPack` objects are mapped to the `namespaces` attribute. It means that you can access namespaces directly from the `DataPack` object.\n\n```py\nprint(pack[\'test\'])  # Namespace(...)\n```\n\nAdding items to namespaces is pretty straight-forward. Simply add them to their respective dictionaries.\n\n```py\nfrom mcpack import (DataPack, Advancement, Function, LootTable, Recipe,\n                    Structure, BlockTag, ItemTag, FluidTag, FunctionTag,\n                    EntityTypeTag)\n\npack = DataPack(\'Test\', \'Test description.\')\n\npack[\'test\'].advancements[\'foo\'] = Advancement(...)\npack[\'test\'].functions[\'foo/spam\'] = Function(...)\npack[\'test\'].loot_tables[\'foo/egg\'] = LootTable(...)\npack[\'test\'].recipes[\'bar\'] = Recipe(...)\npack[\'test\'].structures[\'bar/spam\'] = Structure(...)\npack[\'test\'].block_tags[\'bar/egg\'] = BlockTag(...)\npack[\'test\'].item_tags[\'baz\'] = ItemTag(...)\npack[\'test\'].fluid_tags[\'baz/spam\'] = FluidTag(...)\npack[\'test\'].function_tags[\'baz/egg\'] = FunctionTag(...)\npack[\'test\'].entity_type_tags[\'qux\'] = EntityTypeTag(...)\n```\n\nYou can also use the `DataPack` object directly. The `__setitem__` method actually checks if the key looks like `namespace:path` and dispatches the item automatically. We can now simplify the previous piece of code quite a bit.\n\n```py\nfrom mcpack import (DataPack, Advancement, Function, LootTable, Recipe,\n                    Structure, BlockTag, ItemTag, FluidTag, FunctionTag,\n                    EntityTypeTag)\n\npack = DataPack(\'Test\', \'Test description.\')\n\npack[\'test:foo\'] = Advancement(...)\npack[\'test:foo/spam\'] = Function(...)\npack[\'test:foo/egg\'] = LootTable(...)\npack[\'test:bar\'] = Recipe(...)\npack[\'test:bar/spam\'] = Structure(...)\npack[\'test:bar/egg\'] = BlockTag(...)\npack[\'test:baz\'] = ItemTag(...)\npack[\'test:baz/spam\'] = FluidTag(...)\npack[\'test:baz/egg\'] = FunctionTag(...)\npack[\'test:qux\'] = EntityTypeTag(...)\n```\n\n### Advancements\n\n`Advancement` objects represent Minecraft advancements.\n\n```py\nfrom mcpack import DataPack, Advancement\n\npack = DataPack(\'Test\', \'Test description.\')\npack[\'test:foo\'] = Advancement()\n\nadvancement = pack[\'test\'].advancements[\'foo\']\n\nprint(advancement.display)  # None\nprint(advancement.parent)  # None\nprint(advancement.criteria)  # {}\nprint(advancement.requirements)  # None\nprint(advancement.rewards)  # None\n```\n\nAll the attributes can be set in the constructor. They mirror the root properties of the advancement JSON file format.\n\n> Check out the [wiki](https://minecraft.gamepedia.com/Advancements) for further details.\n\n### Functions\n\n`Function` objects represent Minecraft functions.\n\n```py\nfrom mcpack import DataPack, Function\n\npack = DataPack(\'Test\', \'Test description.\')\npack[\'test:foo\'] = Function()\n\nfunction = pack[\'test\'].functions[\'foo\']\n\nprint(function.body)  # \'\'\n```\n\nThe `body` attribute can be set in the constructor. The body of the function corresponds to the content of the actual `.mcfunction` file.\n\n> Check out the [wiki](https://minecraft.gamepedia.com/Function) for further details.\n\n### Loot tables\n\n`LootTable` objects represent Minecraft loot tables.\n\n```py\nfrom mcpack import DataPack, LootTable\n\npack = DataPack(\'Test\', \'Test description.\')\npack[\'test:foo\'] = LootTable()\n\nloot_table = pack[\'test\'].loot_tables[\'foo\']\n\nprint(loot_table.pools)  # []\nprint(loot_table.type)  # \'generic\'\nprint(loot_table.functions) # None\n```\n\nAll the attributes can be set in the constructor. They mirror the root properties of the loot table JSON file format.\n\n> Check out the [wiki](https://minecraft.gamepedia.com/Loot_table) for further details.\n\n### Recipes\n\n`Recipe` objects represent Minecraft recipes.\n\n```py\nfrom mcpack import DataPack, Recipe\n\npack = DataPack(\'Test\', \'Test description.\')\npack[\'test:foo\'] = Recipe()\n\nrecipe = pack[\'test\'].recipes[\'foo\']\n\nprint(recipe.type)  # \'crafting_shaped\'\nprint(recipe.group)  # None\nprint(recipe.pattern)  # []\nprint(recipe.key)  # {}\nprint(recipe.ingredient)  # None\nprint(recipe.ingredients)  # None\nprint(recipe.result)  # {}\nprint(recipe.experience)  # None\nprint(recipe.cookingtime)  # None\nprint(recipe.count)  # None\n```\n\nAll the attributes can be set in the constructor. They mirror the root properties of the recipe JSON file format.\n\n> Check out the [wiki](https://minecraft.gamepedia.com/Recipe) for further details.\n\n### Structures\n\n`Structure` objects represent Minecraft structures.\n\n```py\nfrom mcpack import DataPack, Structure\n\npack = DataPack(\'Test\', \'Test description.\')\npack[\'test:foo\'] = Structure()\n\nstructure = pack[\'test\'].structures[\'foo\']\n\nprint(structure.data_version)  # Int(1503)\nprint(structure.author)  # String(\'\')\nprint(structure.size)  # List[Int]([0, 0, 0])\nprint(structure.palette)  # List[State]([])\nprint(structure.palettes)  # List[List[State]]([])\nprint(structure.blocks)  # List[Block]([])\nprint(structure.entities)  # List[Entity]([])\n```\n\nAll the attributes can be set in the constructor. They mirror the root properties of the structure NBT file format. `mcpack` uses [`nbtlib`](https://github.com/vberlier/nbtlib) to manipulate nbt data. The `Structure` class inherits from an `nbtlib` schema that takes care of wrapping python values with the appropriate nbt tags.\n\n> Check out the [wiki](https://minecraft.gamepedia.com/Structure_block_file_format) for further details.\n\n### Tags\n\n`BlockTag`, `ItemTag`, `FluidTag`, `FunctionTag` and `EntityTypeTag` objects represent Minecraft block, item, fluid, function and entity type tags respectively. They are all identical in structure, the only difference between them is the namespace directory they get written to.\n\n```py\nfrom mcpack import DataPack, BlockTag\n\npack = DataPack(\'Test\', \'Test description.\')\npack[\'test:foo\'] = BlockTag()\n\nblock_tag = pack[\'test\'].block_tags[\'foo\']\n\nprint(block_tag.values)  # []\nprint(block_tag.replace)  # False\n```\n\nThe `values` and `replace` attributes can be set in the constructor. They mirror the root properties of the tag JSON file format.\n\n> Check out the [wiki](https://minecraft.gamepedia.com/Tag) for further details.\n\n## Contributing\n\nContributions are welcome. This project uses [`poetry`](https://poetry.eustace.io/) so you\'ll need to install it first if you want to be able to work with the project locally.\n\n```sh\n$ curl -sSL https://raw.githubusercontent.com/sdispater/poetry/master/get-poetry.py | python\n```\n\nYou should now be able to install the required dependencies.\n\n```sh\n$ poetry install\n```\n\nYou can run the tests with `poetry run pytest`.\n\n```sh\n$ poetry run pytest\n```\n\nThe project can also download the latest minecraft releases and run tests against the vanilla data pack. You can enable these tests by using the `--vanilla` flag.\n\n```sh\n$ poetry run pytest --vanilla\n```\n\n---\n\nLicense - [MIT](https://github.com/vberlier/mcpack/blob/master/LICENSE)\n',
    'author': 'Valentin Berlier',
    'author_email': 'berlier.v@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/vberlier/mcpack',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
