"use strict";
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// In order to confirm that we avoid name collisions on the event binding with both multiple constructs and multiple stacks,
// launch two stacks with two constructs at the same time using
//  cdk-integ integ.second-long-stack-name.js integ.long-stack-name.js --no-clean
// and confirm that all topics are publishing messages.
const aws_cdk_lib_1 = require("aws-cdk-lib");
const lib_1 = require("../lib");
const events = require("aws-cdk-lib/aws-events");
const aws_cdk_lib_2 = require("aws-cdk-lib");
const core_1 = require("@aws-solutions-constructs/core");
const integ_tests_alpha_1 = require("@aws-cdk/integ-tests-alpha");
const app = new aws_cdk_lib_2.App();
const stackTwo = new aws_cdk_lib_2.Stack(app, (0, core_1.generateIntegStackName)(__filename) + 'ThisIsTheLongestNameForAStackItMustBeGreaterThanSixtyFourCharactersLongAndThisShouldJustAboutDoItNoItMustBeABitLessShort');
const propsTwo = {
    eventRuleProps: {
        schedule: events.Schedule.rate(aws_cdk_lib_1.Duration.minutes(1))
    }
};
new lib_1.EventbridgeToSns(stackTwo, 'test-construct', propsTwo);
new lib_1.EventbridgeToSns(stackTwo, 'second-construct', propsTwo);
new integ_tests_alpha_1.IntegTest(stackTwo, 'Integ', { testCases: [
        stackTwo
    ] });
//# sourceMappingURL=data:application/json;base64,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