"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ContentfulWebhook = void 0;
const path = require("path");
const core_1 = require("@aws-cdk/core");
const aws_lambda_1 = require("@aws-cdk/aws-lambda");
class ContentfulWebhook extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const handler = new aws_lambda_1.SingletonFunction(this, 'CustomResourceHandler', {
            uuid: '91f2075f-b950-4743-a66b-ee0f6febf50d',
            runtime: aws_lambda_1.Runtime.NODEJS_12_X,
            code: aws_lambda_1.Code.fromAsset(path.join(__dirname, 'lambdas', 'contentful-webhook')),
            handler: 'index.handler',
            lambdaPurpose: 'Custom::ContentfulWebhook',
            timeout: core_1.Duration.minutes(15),
        });
        new core_1.CustomResource(this, 'CustomResource', {
            serviceToken: handler.functionArn,
            resourceType: 'Custom::ContentfulWebhook',
            pascalCaseProperties: true,
            properties: {
                ...props,
            },
        });
    }
}
exports.ContentfulWebhook = ContentfulWebhook;
//# sourceMappingURL=data:application/json;base64,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