from ig_api import markets
from ig_api.datasets.market_history import MarketHistory
from ig_api.datasets.resolutions import Resolutions


def add_averaging(cboe_history: MarketHistory) -> None:
    """ Used specifically to adapt CBOE .vix data to expected prices offered by IG.com

    See plots generated by ./visualize/cboe_vs_ig.py
    """

    dataset = list(cboe_history)

    days_fast = 15
    beta_fast = 1 - 0.6 / days_fast
    avg_fast = sum((l + h) / 2 for l, h, _ in dataset[:100]) / 100

    days_slow = 90
    beta_slow = 1 - 0.6 / days_slow
    avg_slow = sum((l + h) / 2 for l, h, _ in dataset[:500]) / 500

    for date, (low, high, delta) in cboe_history._data.items():
        cur_val = (low + high)
        avg_fast = avg_fast * beta_fast + (low + high) / 2 * (1 - beta_fast)
        avg_slow = avg_slow * beta_slow + 1.14 * (low + high) / 2 * (1 - beta_slow)

        if (rel := (cur_val / avg_slow)) > 2.5:
            cv_coef = (2.5 + rel) / 2
        else:
            cv_coef = 2.5

        cboe_history._data[date] = (
            (cv_coef * low + avg_fast + 2 * avg_slow) / (3 + cv_coef),
            (cv_coef * high + avg_fast + 2 * avg_slow) / (3 + cv_coef),
            delta,
        )

ig_vix = MarketHistory.from_csv(markets.vix, Resolutions.HOUR_2)
ig_vix_eu = MarketHistory.from_csv(markets.vix_eu, Resolutions.HOUR_2)
cboe_vix = MarketHistory.from_csv(markets.cboe_vix, Resolutions.DAY)
add_averaging(cboe_vix)


