# Most things have moved to base's `templates.py` now. This exists
# as an alias module to ease transition.

import dataclasses
import importlib
import logging
from typing import *  # noqa

import hippolyzer.lib.base.templates

try:
    # Most of our templates come from here, so we need to
    # reload this to pull in fresh templates with `import *`
    importlib.reload(hippolyzer.lib.base.templates)  # type: ignore
except:
    logging.exception("Failed to reload base templates lib")


from hippolyzer.lib.base.templates import *


@dataclasses.dataclass
class CAPTemplate:
    cap_name: str
    method: str
    body: Any
    query: Set[str] = dataclasses.field(default_factory=set)
    path: str = ""


# Cap request templates for message builder prefills
CAP_TEMPLATES: List[CAPTemplate] = [
    CAPTemplate(cap_name='Seed', method='POST', body=b'<?xml version="1.0" ?>\n<llsd>\n<array>\n    <string></string>\n  </array>\n</llsd>\n', query=set()),
    CAPTemplate(cap_name='SimulatorFeatures', method='GET', body=b'', query=set()),
    CAPTemplate(cap_name='EventQueueGet', method='POST', body=b'<?xml version="1.0" ?>\n<llsd>\n<map>\n    <key>ack</key>\n    <undef />\n    <key>done</key>\n    <boolean></boolean>\n  </map>\n</llsd>\n', query=set()),
    CAPTemplate(cap_name='NavMeshGenerationStatus', method='GET', body=b'', query=set()),
    CAPTemplate(cap_name='AgentState', method='GET', body=b'', query=set()),
    CAPTemplate(cap_name='AgentPreferences', method='POST', body=b'<?xml version="1.0" ?>\n<llsd>\n<map>\n    <key>default_object_perm_masks</key>\n    <map>\n      <key>Everyone</key>\n      <integer></integer>\n      <key>Group</key>\n      <integer></integer>\n      <key>NextOwner</key>\n      <integer></integer>\n    </map>\n  </map>\n</llsd>\n', query=set()),
    CAPTemplate(cap_name='ExtEnvironment', method='GET', body=b'', query={'parcelid'}),
    CAPTemplate(cap_name='UpdateAgentLanguage', method='POST', body=b'<?xml version="1.0" ?>\n<llsd>\n<map>\n    <key>language</key>\n    <string>en</string>\n    <key>language_is_public</key>\n    <integer>1</integer>\n  </map>\n</llsd>\n', query=set()),
    CAPTemplate(cap_name='DirectDelivery', method='GET', body=b'', query=set(), path="/listings"),
    CAPTemplate(cap_name='ViewerStats', method='POST', body=b'<?xml version="1.0" ?>\n<llsd>\n<map>\n    <key>AgentPositionSnaps</key>\n    <real></real>\n    <key>DisplayNamesEnabled</key>\n    <integer></integer>\n    <key>DisplayNamesShowUsername</key>\n    <integer></integer>\n    <key>MinimalSkin</key>\n    <boolean></boolean>\n    <key>agent</key>\n    <map>\n      <key>agents_in_view</key>\n      <integer></integer>\n      <key>fps</key>\n      <real></real>\n      <key>language</key>\n      <string></string>\n      <key>mem_use</key>\n      <real></real>\n      <key>meters_traveled</key>\n      <real></real>\n      <key>ping</key>\n      <real></real>\n      <key>regions_visited</key>\n      <integer></integer>\n      <key>run_time</key>\n      <real></real>\n      <key>sim_fps</key>\n      <real></real>\n      <key>start_time</key>\n      <integer></integer>\n      <key>version</key>\n      <string></string>\n    </map>\n    <key>downloads</key>\n    <map>\n      <key>mesh_kbytes</key>\n      <real></real>\n      <key>object_kbytes</key>\n      <real></real>\n      <key>texture_kbytes</key>\n      <real></real>\n      <key>world_kbytes</key>\n      <real></real>\n    </map>\n    <key>misc</key>\n    <map>\n      <key>Version</key>\n      <integer></integer>\n      <key>Vertex Buffers Enabled</key>\n      <real></real>\n    </map>\n    <key>session_id</key>\n    <uuid></uuid>\n    <key>stats</key>\n    <map>\n      <key>failures</key>\n      <map>\n        <key>dropped</key>\n        <integer></integer>\n        <key>failed_resends</key>\n        <integer></integer>\n        <key>invalid</key>\n        <integer></integer>\n        <key>missing_updater</key>\n        <integer></integer>\n        <key>off_circuit</key>\n        <integer></integer>\n        <key>resent</key>\n        <integer></integer>\n        <key>send_packet</key>\n        <integer></integer>\n      </map>\n      <key>misc</key>\n      <map>\n        <key>int_1</key>\n        <integer></integer>\n        <key>int_2</key>\n        <integer></integer>\n        <key>string_1</key>\n        <string></string>\n        <key>string_2</key>\n        <string></string>\n      </map>\n      <key>net</key>\n      <map>\n        <key>in</key>\n        <map>\n          <key>compressed_packets</key>\n          <integer></integer>\n          <key>kbytes</key>\n          <real></real>\n          <key>packets</key>\n          <integer></integer>\n          <key>savings</key>\n          <real></real>\n        </map>\n        <key>out</key>\n        <map>\n          <key>compressed_packets</key>\n          <integer></integer>\n          <key>kbytes</key>\n          <real></real>\n          <key>packets</key>\n          <integer></integer>\n          <key>savings</key>\n          <real></real>\n        </map>\n      </map>\n      <key>voice</key>\n      <map>\n        <key>connect_attempts</key>\n        <integer></integer>\n        <key>connect_cycles</key>\n        <integer></integer>\n        <key>connect_time</key>\n        <real></real>\n        <key>establish_attempts</key>\n        <integer></integer>\n        <key>establish_time</key>\n        <real></real>\n        <key>provision_attempts</key>\n        <integer></integer>\n        <key>provision_time</key>\n        <real></real>\n      </map>\n    </map>\n    <key>system</key>\n    <map>\n      <key>address_size</key>\n      <integer></integer>\n      <key>cpu</key>\n      <string></string>\n      <key>gl</key>\n      <map>\n        <key>ati_offset_vertical_lines</key>\n        <integer></integer>\n        <key>ati_old_driver</key>\n        <integer></integer>\n        <key>debug_gpu</key>\n        <integer></integer>\n        <key>gl_renderer</key>\n        <string></string>\n        <key>gpu_vendor</key>\n        <string></string>\n        <key>gpu_version</key>\n        <string></string>\n        <key>has_anisotropic</key>\n        <integer></integer>\n        <key>has_arb_env_combine</key>\n        <integer></integer>\n        <key>has_ati_mem_info</key>\n        <integer></integer>\n        <key>has_blend_func_separate</key>\n        <integer></integer>\n        <key>has_compressed_textures</key>\n        <integer></integer>\n        <key>has_cube_map</key>\n        <integer></integer>\n        <key>has_debug_output</key>\n        <integer></integer>\n        <key>has_depth_clamp</key>\n        <integer></integer>\n        <key>has_draw_buffers</key>\n        <integer></integer>\n        <key>has_flush_buffer_range</key>\n        <integer></integer>\n        <key>has_fragment_shader</key>\n        <integer></integer>\n        <key>has_framebuffer_object</key>\n        <integer></integer>\n        <key>has_map_buffer_range</key>\n        <integer></integer>\n        <key>has_mip_map_generation</key>\n        <integer></integer>\n        <key>has_multitexture</key>\n        <integer></integer>\n        <key>has_nvx_mem_info</key>\n        <integer></integer>\n        <key>has_occlusion_query</key>\n        <integer></integer>\n        <key>has_occlusion_query2</key>\n        <integer></integer>\n        <key>has_pbuffer</key>\n        <integer></integer>\n        <key>has_point_parameters</key>\n        <integer></integer>\n        <key>has_requirements</key>\n        <integer></integer>\n        <key>has_separate_specular_color</key>\n        <integer></integer>\n        <key>has_shader_objects</key>\n        <integer></integer>\n        <key>has_srgb_framebuffer</key>\n        <integer></integer>\n        <key>has_srgb_texture</key>\n        <integer></integer>\n        <key>has_sync</key>\n        <integer></integer>\n        <key>has_texture_multisample</key>\n        <integer></integer>\n        <key>has_texture_rectangle</key>\n        <integer></integer>\n        <key>has_texture_srgb_decode</key>\n        <integer></integer>\n        <key>has_timer_query</key>\n        <integer></integer>\n        <key>has_transform_feedback</key>\n        <integer></integer>\n        <key>has_vertex_array_object</key>\n        <integer></integer>\n        <key>has_vertex_buffer_object</key>\n        <integer></integer>\n        <key>has_vertex_shader</key>\n        <integer></integer>\n        <key>is_ati</key>\n        <integer></integer>\n        <key>is_gf2or4mx</key>\n        <integer></integer>\n        <key>is_gf3</key>\n        <integer></integer>\n        <key>is_gf_gfx</key>\n        <integer></integer>\n        <key>is_intel</key>\n        <integer></integer>\n        <key>is_nvidia</key>\n        <integer></integer>\n        <key>max_color_texture_samples</key>\n        <integer></integer>\n        <key>max_depth_texture_samples</key>\n        <integer></integer>\n        <key>max_index_range</key>\n        <integer></integer>\n        <key>max_integer_samples</key>\n        <integer></integer>\n        <key>max_sample_mask_words</key>\n        <integer></integer>\n        <key>max_samples</key>\n        <integer></integer>\n        <key>max_texture_size</key>\n        <integer></integer>\n        <key>max_vertex_range</key>\n        <integer></integer>\n        <key>num_texture_image_units</key>\n        <integer></integer>\n        <key>num_texture_units</key>\n        <integer></integer>\n        <key>opengl_version</key>\n        <string></string>\n        <key>vram</key>\n        <integer></integer>\n      </map>\n      <key>gpu</key>\n      <string></string>\n      <key>gpu_class</key>\n      <integer></integer>\n      <key>gpu_vendor</key>\n      <string></string>\n      <key>gpu_version</key>\n      <string></string>\n      <key>mac_address</key>\n      <string></string>\n      <key>opengl_version</key>\n      <string></string>\n      <key>os</key>\n      <string></string>\n      <key>ram</key>\n      <integer></integer>\n      <key>serial_number</key>\n      <string></string>\n      <key>shader_level</key>\n      <integer></integer>\n    </map>\n  </map>\n</llsd>\n', query=set()),
    CAPTemplate(cap_name='GetDisplayNames', method='GET', body=b'', query={'ids'}),
    CAPTemplate(cap_name='FetchInventory2', method='POST', body=b'<?xml version="1.0" ?>\n<llsd>\n<map>\n    <key>agent_id</key>\n    <uuid><!HIPPOREPL[[AGENT_ID]]></uuid>\n    <key>cap_name</key>\n    <string></string>\n    <key>items</key>\n    <array>\n      <map>\n        <key>item_id</key>\n        <uuid></uuid>\n        <key>owner_id</key>\n        <uuid><!HIPPOREPL[[AGENT_ID]]></uuid>\n      </map>\n    </array>\n  </map>\n</llsd>\n', query=set()),
    CAPTemplate(cap_name='FetchLib2', method='POST', body=b'<?xml version="1.0" ?>\n<llsd>\n<map>\n    <key>agent_id</key>\n    <uuid></uuid>\n    <key>cap_name</key>\n    <string></string>\n    <key>items</key>\n    <array>\n      <map>\n        <key>item_id</key>\n        <uuid></uuid>\n        <key>owner_id</key>\n        <uuid></uuid>\n      </map>\n    </array>\n  </map>\n</llsd>\n', query=set()),
    CAPTemplate(cap_name='FetchInventoryDescendents2', method='POST', body=b'<?xml version="1.0" ?>\n<llsd>\n<map>\n    <key>folders</key>\n    <array>\n      <map>\n        <key>fetch_folders</key>\n        <boolean></boolean>\n        <key>fetch_items</key>\n        <boolean></boolean>\n        <key>folder_id</key>\n        <string></string>\n        <key>owner_id</key>\n        <uuid><!HIPPOREPL[[AGENT_ID]]></uuid>\n        <key>sort_order</key>\n        <integer></integer>\n      </map>\n    </array>\n  </map>\n</llsd>\n', query=set()),
    CAPTemplate(cap_name='ProvisionVoiceAccountRequest', method='POST', body=b'<?xml version="1.0" ?>\n<llsd>\n<undef />\n</llsd>\n', query=set()),
    CAPTemplate(cap_name='AvatarRenderInfo', method='GET', body=b'', query=set()),
    CAPTemplate(cap_name='ReadOfflineMsgs', method='GET', body=b'', query=set()),
    CAPTemplate(cap_name='MapImageService', method='GET', body=b'', query=set()),
    CAPTemplate(cap_name='RenderMaterials', method='GET', body=b'', query=set()),
    CAPTemplate(cap_name='AvatarRenderInfo', method='POST', body=b'<?xml version="1.0" ?>\n<llsd>\n<map>\n    <key>agents</key>\n    <map>\n      <key><!HIPPOREPL[[AGENT_ID]]></key>\n      <map>\n        <key>tooComplex</key>\n        <boolean></boolean>\n        <key>weight</key>\n        <integer></integer>\n      </map>\n    </map>\n  </map>\n</llsd>\n', query=set()),
    CAPTemplate(cap_name='ParcelVoiceInfoRequest', method='POST', body=b'<?xml version="1.0" ?>\n<llsd>\n<undef />\n</llsd>\n', query=set()),
    CAPTemplate(cap_name='ProductInfoRequest', method='GET', body=b'', query=set()),
    CAPTemplate(cap_name='ObjectMedia', method='POST', body=b'<?xml version="1.0" ?>\n<llsd>\n<map>\n    <key>object_id</key>\n    <uuid><!HIPPOREPL[[SELECTED_FULL]]></uuid>\n    <key>verb</key>\n    <string>GET</string>\n  </map>\n</llsd>\n', query=set()),
    CAPTemplate(cap_name='GetObjectCost', method='POST', body=b'<?xml version="1.0" ?>\n<llsd>\n<map>\n    <key>object_ids</key>\n    <array>\n      <uuid><!HIPPOREPL[[SELECTED_FULL]]></uuid>\n    </array>\n  </map>\n</llsd>\n', query=set()),
    CAPTemplate(cap_name='GetObjectPhysicsData', method='POST', body=b'<?xml version="1.0" ?>\n<llsd>\n<map>\n    <key>object_ids</key>\n    <array>\n      <uuid><!HIPPOREPL[[SELECTED_FULL]]></uuid>\n    </array>\n  </map>\n</llsd>\n', query=set()),
    CAPTemplate(cap_name='RenderMaterials', method='PUT', body=b'<?xml version="1.0" ?>\n<llsd>\n<map>\n    <key>Zipped</key>\n    <binary></binary>\n  </map>\n</llsd>\n', query=set()),
    CAPTemplate(cap_name='RenderMaterials', method='POST', body=b'<?xml version="1.0" ?>\n<llsd>\n<map>\n    <key>Zipped</key>\n    <binary></binary>\n  </map>\n</llsd>\n', query=set()),
    CAPTemplate(cap_name='GetExperienceInfo', method='GET', body=b'', query={'public_id', 'page_size'}, path="/id/"),
    CAPTemplate(cap_name='LSLSyntax', method='GET', body=b'', query=set()),
    CAPTemplate(cap_name='GetCreatorExperiences', method='GET', body=b'', query=set()),
    CAPTemplate(cap_name='GetMetadata', method='POST', body=b'<?xml version="1.0" ?>\n<llsd>\n<map>\n    <key>fields</key>\n    <array>\n      <string>experience</string>\n    </array>\n    <key>item-id</key>\n    <uuid><!HIPPOREPL[[SELECTED_SCRIPT_ITEM]]></uuid>\n    <key>object-id</key>\n    <uuid><!HIPPOREPL[[SELECTED_FULL]]></uuid>\n  </map>\n</llsd>\n', query=set()),
    CAPTemplate(cap_name='UpdateScriptTask', method='POST', body=b'<?xml version="1.0" ?>\n<llsd>\n<map>\n    <key>experience</key>\n    <uuid></uuid>\n    <key>is_script_running</key>\n    <integer>1</integer>\n    <key>item_id</key>\n    <uuid><!HIPPOREPL[[SELECTED_SCRIPT_ITEM]]></uuid>\n    <key>target</key>\n    <string>mono</string>\n    <key>task_id</key>\n    <uuid><!HIPPOREPL[[SELECTED_FULL]]></uuid>\n  </map>\n</llsd>\n', query=set()),
    CAPTemplate(cap_name='EstateAccess', method='GET', body=b'', query=set()),
    CAPTemplate(cap_name='RegionExperiences', method='GET', body=b'', query=set()),
    CAPTemplate(cap_name='SimConsoleAsync', method='POST', body=b'<?xml version="1.0" ?>\n<llsd>\n<string></string>\n</llsd>\n', query=set()),
    CAPTemplate(cap_name='FindExperienceByName', method='GET', body=b'', query={'query', 'page', 'page_size'}),
    CAPTemplate(cap_name='ViewerMetrics', method='POST', body=b'<?xml version="1.0" ?>\n<llsd>\n<map>\n    <key>agent_id</key>\n    <uuid></uuid>\n    <key>break</key>\n    <boolean></boolean>\n    <key>duration</key>\n    <real></real>\n    <key>initial</key>\n    <boolean></boolean>\n    <key>message</key>\n    <string></string>\n    <key>nearby</key>\n    <map>\n      <key>cloud</key>\n      <integer></integer>\n      <key>downloading</key>\n      <integer></integer>\n      <key>full</key>\n      <integer></integer>\n      <key>gray</key>\n      <integer></integer>\n    </map>\n    <key>rez_status</key>\n    <string></string>\n    <key>sequence</key>\n    <integer></integer>\n    <key>session_id</key>\n    <uuid></uuid>\n    <key>timers</key>\n    <array>\n      <map>\n        <key>central_bake_version</key>\n        <integer></integer>\n        <key>completed</key>\n        <boolean></boolean>\n        <key>grid_x</key>\n        <integer></integer>\n        <key>grid_y</key>\n        <integer></integer>\n        <key>is_self</key>\n        <boolean></boolean>\n        <key>is_using_server_bakes</key>\n        <boolean></boolean>\n        <key>stats</key>\n        <map>\n          <key>count</key>\n          <integer></integer>\n          <key>max</key>\n          <real></real>\n          <key>mean</key>\n          <real></real>\n          <key>min</key>\n          <real></real>\n          <key>std_dev</key>\n          <real></real>\n        </map>\n        <key>timer_name</key>\n        <string></string>\n      </map>\n      <map>\n        <key>central_bake_version</key>\n        <integer></integer>\n        <key>completed</key>\n        <boolean></boolean>\n        <key>grid_x</key>\n        <integer></integer>\n        <key>grid_y</key>\n        <integer></integer>\n        <key>is_self</key>\n        <boolean></boolean>\n        <key>is_using_server_bakes</key>\n        <boolean></boolean>\n        <key>stats</key>\n        <map>\n          <key>count</key>\n          <integer></integer>\n          <key>max</key>\n          <real></real>\n          <key>mean</key>\n          <real></real>\n          <key>min</key>\n          <real></real>\n          <key>std_dev</key>\n          <real></real>\n        </map>\n        <key>timer_name</key>\n        <string></string>\n      </map>\n      <map>\n        <key>central_bake_version</key>\n        <integer></integer>\n        <key>completed</key>\n        <boolean></boolean>\n        <key>grid_x</key>\n        <integer></integer>\n        <key>grid_y</key>\n        <integer></integer>\n        <key>is_self</key>\n        <boolean></boolean>\n        <key>is_using_server_bakes</key>\n        <boolean></boolean>\n        <key>stats</key>\n        <map>\n          <key>count</key>\n          <integer></integer>\n          <key>max</key>\n          <real></real>\n          <key>mean</key>\n          <real></real>\n          <key>min</key>\n          <real></real>\n          <key>std_dev</key>\n          <real></real>\n        </map>\n        <key>timer_name</key>\n        <string></string>\n      </map>\n      <map>\n        <key>central_bake_version</key>\n        <integer></integer>\n        <key>completed</key>\n        <boolean></boolean>\n        <key>grid_x</key>\n        <integer></integer>\n        <key>grid_y</key>\n        <integer></integer>\n        <key>is_self</key>\n        <boolean></boolean>\n        <key>is_using_server_bakes</key>\n        <boolean></boolean>\n        <key>stats</key>\n        <map>\n          <key>count</key>\n          <integer></integer>\n          <key>max</key>\n          <real></real>\n          <key>mean</key>\n          <real></real>\n          <key>min</key>\n          <real></real>\n          <key>std_dev</key>\n          <real></real>\n        </map>\n        <key>timer_name</key>\n        <string></string>\n      </map>\n      <map>\n        <key>central_bake_version</key>\n        <integer></integer>\n        <key>completed</key>\n        <boolean></boolean>\n        <key>grid_x</key>\n        <integer></integer>\n        <key>grid_y</key>\n        <integer></integer>\n        <key>is_self</key>\n        <boolean></boolean>\n        <key>is_using_server_bakes</key>\n        <boolean></boolean>\n        <key>stats</key>\n        <map>\n          <key>count</key>\n          <integer></integer>\n          <key>max</key>\n          <real></real>\n          <key>mean</key>\n          <real></real>\n          <key>min</key>\n          <real></real>\n          <key>std_dev</key>\n          <real></real>\n        </map>\n        <key>timer_name</key>\n        <string></string>\n      </map>\n      <map>\n        <key>central_bake_version</key>\n        <integer></integer>\n        <key>completed</key>\n        <boolean></boolean>\n        <key>grid_x</key>\n        <integer></integer>\n        <key>grid_y</key>\n        <integer></integer>\n        <key>is_self</key>\n        <boolean></boolean>\n        <key>is_using_server_bakes</key>\n        <boolean></boolean>\n        <key>stats</key>\n        <map>\n          <key>count</key>\n          <integer></integer>\n          <key>max</key>\n          <real></real>\n          <key>mean</key>\n          <real></real>\n          <key>min</key>\n          <real></real>\n          <key>std_dev</key>\n          <real></real>\n        </map>\n        <key>timer_name</key>\n        <string></string>\n      </map>\n      <map>\n        <key>central_bake_version</key>\n        <integer></integer>\n        <key>completed</key>\n        <boolean></boolean>\n        <key>grid_x</key>\n        <integer></integer>\n        <key>grid_y</key>\n        <integer></integer>\n        <key>is_self</key>\n        <boolean></boolean>\n        <key>is_using_server_bakes</key>\n        <boolean></boolean>\n        <key>stats</key>\n        <map>\n          <key>count</key>\n          <integer></integer>\n          <key>max</key>\n          <real></real>\n          <key>mean</key>\n          <real></real>\n          <key>min</key>\n          <real></real>\n          <key>std_dev</key>\n          <real></real>\n        </map>\n        <key>timer_name</key>\n        <string></string>\n      </map>\n      <map>\n        <key>central_bake_version</key>\n        <integer></integer>\n        <key>completed</key>\n        <boolean></boolean>\n        <key>grid_x</key>\n        <integer></integer>\n        <key>grid_y</key>\n        <integer></integer>\n        <key>is_self</key>\n        <boolean></boolean>\n        <key>is_using_server_bakes</key>\n        <boolean></boolean>\n        <key>stats</key>\n        <map>\n          <key>count</key>\n          <integer></integer>\n          <key>max</key>\n          <real></real>\n          <key>mean</key>\n          <real></real>\n          <key>min</key>\n          <real></real>\n          <key>std_dev</key>\n          <real></real>\n        </map>\n        <key>timer_name</key>\n        <string></string>\n      </map>\n      <map>\n        <key>central_bake_version</key>\n        <integer></integer>\n        <key>completed</key>\n        <boolean></boolean>\n        <key>grid_x</key>\n        <integer></integer>\n        <key>grid_y</key>\n        <integer></integer>\n        <key>is_self</key>\n        <boolean></boolean>\n        <key>is_using_server_bakes</key>\n        <boolean></boolean>\n        <key>stats</key>\n        <map>\n          <key>count</key>\n          <integer></integer>\n          <key>max</key>\n          <real></real>\n          <key>mean</key>\n          <real></real>\n          <key>min</key>\n          <real></real>\n          <key>std_dev</key>\n          <real></real>\n        </map>\n        <key>timer_name</key>\n        <string></string>\n      </map>\n      <map>\n        <key>central_bake_version</key>\n        <integer></integer>\n        <key>completed</key>\n        <boolean></boolean>\n        <key>grid_x</key>\n        <integer></integer>\n        <key>grid_y</key>\n        <integer></integer>\n        <key>is_self</key>\n        <boolean></boolean>\n        <key>is_using_server_bakes</key>\n        <boolean></boolean>\n        <key>stats</key>\n        <map>\n          <key>count</key>\n          <integer></integer>\n          <key>max</key>\n          <real></real>\n          <key>mean</key>\n          <real></real>\n          <key>min</key>\n          <real></real>\n          <key>std_dev</key>\n          <real></real>\n        </map>\n        <key>timer_name</key>\n        <string></string>\n      </map>\n      <map>\n        <key>central_bake_version</key>\n        <integer></integer>\n        <key>completed</key>\n        <boolean></boolean>\n        <key>grid_x</key>\n        <integer></integer>\n        <key>grid_y</key>\n        <integer></integer>\n        <key>is_self</key>\n        <boolean></boolean>\n        <key>is_using_server_bakes</key>\n        <boolean></boolean>\n        <key>stats</key>\n        <map>\n          <key>count</key>\n          <integer></integer>\n          <key>max</key>\n          <real></real>\n          <key>mean</key>\n          <real></real>\n          <key>min</key>\n          <real></real>\n          <key>std_dev</key>\n          <real></real>\n        </map>\n        <key>timer_name</key>\n        <string></string>\n      </map>\n      <map>\n        <key>central_bake_version</key>\n        <integer></integer>\n        <key>completed</key>\n        <boolean></boolean>\n        <key>grid_x</key>\n        <integer></integer>\n        <key>grid_y</key>\n        <integer></integer>\n        <key>is_self</key>\n        <boolean></boolean>\n        <key>is_using_server_bakes</key>\n        <boolean></boolean>\n        <key>stats</key>\n        <map>\n          <key>count</key>\n          <integer></integer>\n          <key>max</key>\n          <real></real>\n          <key>mean</key>\n          <real></real>\n          <key>min</key>\n          <real></real>\n          <key>std_dev</key>\n          <real></real>\n        </map>\n        <key>timer_name</key>\n        <string></string>\n      </map>\n      <map>\n        <key>central_bake_version</key>\n        <integer></integer>\n        <key>completed</key>\n        <boolean></boolean>\n        <key>grid_x</key>\n        <integer></integer>\n        <key>grid_y</key>\n        <integer></integer>\n        <key>is_self</key>\n        <boolean></boolean>\n        <key>is_using_server_bakes</key>\n        <boolean></boolean>\n        <key>stats</key>\n        <map>\n          <key>count</key>\n          <integer></integer>\n          <key>max</key>\n          <real></real>\n          <key>mean</key>\n          <real></real>\n          <key>min</key>\n          <real></real>\n          <key>std_dev</key>\n          <real></real>\n        </map>\n        <key>timer_name</key>\n        <string></string>\n      </map>\n    </array>\n  </map>\n</llsd>\n', query=set()),
    CAPTemplate(cap_name='InventoryAPIv3', method='PATCH', body=b'<?xml version="1.0" ?>\n<llsd>\n<map>\n    <key>name</key>\n    <string></string>\n  </map>\n</llsd>\n', query={'tid'}, path="/item/SOME_ID"),
    CAPTemplate(cap_name='RemoteParcelRequest', method='POST', body=b'<?xml version="1.0" ?>\n<llsd>\n<map>\n    <key>location</key>\n    <array>\n      <real></real>\n      <real></real>\n      <real></real>\n    </array>\n    <key>region_handle</key>\n    <binary></binary>\n    <key>region_id</key>\n    <uuid></uuid>\n  </map>\n</llsd>\n', query=set()),
    CAPTemplate(cap_name='ParcelPropertiesUpdate', method='POST', body=b'<?xml version="1.0" ?>\n<llsd>\n  <map>\n   <key>local_id</key>\n    <integer><!HIPPOREPL[[SELECTED_PARCEL_LOCAL]]></integer>\n   <key>any_av_sounds</key>\n    <boolean>true</boolean>\n   <key>auth_buyer_id</key>\n    <uuid></uuid>\n   <key>auto_scale</key>\n    <integer>0</integer>\n   <key>category</key>\n    <integer>0</integer>\n   <key>description</key>\n    <string></string>\n   <key>flags</key>\n    <binary>AAAAAQ==</binary>\n   <key>group_av_sounds</key>\n    <boolean>true</boolean>\n   <key>group_id</key>\n    <uuid></uuid>\n   <key>landing_type</key>\n    <integer>2</integer>\n   <key>media_allow_navigate</key>\n    <integer>1</integer>\n   <key>media_current_url</key>\n    <string></string>\n   <key>media_desc</key>\n    <string></string>\n   <key>media_height</key>\n    <integer>0</integer>\n   <key>media_id</key>\n    <uuid></uuid>\n   <key>media_loop</key>\n    <integer>0</integer>\n   <key>media_prevent_camera_zoom</key>\n    <integer>0</integer>\n   <key>media_type</key>\n    <string>none/none</string>\n   <key>media_url</key>\n    <string></string>\n   <key>media_url_timeout</key>\n    <real>0.0</real>\n   <key>media_width</key>\n    <integer>0</integer>\n   <key>music_url</key>\n    <string></string>\n   <key>name</key>\n    <string></string>\n   <key>obscure_media</key>\n    <boolean>false</boolean>\n   <key>obscure_music</key>\n    <boolean>false</boolean>\n   <key>parcel_flags</key>\n    <binary>fiQASw==</binary>\n   <key>pass_hours</key>\n    <real>1.0</real>\n   <key>pass_price</key>\n    <integer>10</integer>\n   <key>sale_price</key>\n    <integer>10000</integer>\n   <key>see_avs</key>\n    <boolean>true</boolean>\n   <key>snapshot_id</key>\n    <uuid></uuid>\n   <key>user_location</key>\n    <array>\n      <real>0.0</real>\n      <real>0.0</real>\n      <real>0.0</real>\n    </array>\n   <key>user_look_at</key>\n    <array>\n      <real>0.0</real>\n      <real>0.0</real>\n      <real>0.0</real>\n    </array>\n  </map>\n</llsd>\n', query=set()),
    CAPTemplate(cap_name='UpdateScriptAgent', method='POST', body=b'<?xml version="1.0" ?>\n<llsd>\n<map>\n    <key>item_id</key>\n    <uuid></uuid>\n    <key>target</key>\n    <string>mono</string>\n  </map>\n</llsd>\n', query=set()),
    CAPTemplate(cap_name='NewFileAgentInventory', method='POST', body=b'<?xml version="1.0" ?>\n<llsd>\n<map>\n    <key>asset_type</key>\n    <string></string>\n    <key>description</key>\n    <string></string>\n    <key>everyone_mask</key>\n    <integer></integer>\n    <key>folder_id</key>\n    <uuid></uuid>\n    <key>group_mask</key>\n    <integer></integer>\n    <key>inventory_type</key>\n    <string></string>\n    <key>name</key>\n    <string></string>\n    <key>next_owner_mask</key>\n    <integer></integer>\n  </map>\n</llsd>\n', query=set()),
    CAPTemplate(cap_name='UpdateNotecardAgentInventory', method='POST', body=b'<?xml version="1.0" ?>\n<llsd>\n<map>\n    <key>item_id</key>\n    <uuid></uuid>\n  </map>\n</llsd>\n', query=set()),
    CAPTemplate(cap_name='UpdateNotecardTaskInventory', method='POST', body=b'<?xml version="1.0" ?>\n<llsd>\n<map>\n    <key>item_id</key>\n    <uuid><!HIPPOREPL[[SELECTED_TASK_ITEM]]></uuid>\n    <key>task_id</key>\n    <uuid><!HIPPOREPL[[SELECTED_FULL]]></uuid>\n  </map>\n</llsd>\n', query=set()),
    CAPTemplate(cap_name='UpdateGestureAgentInventory', method='POST', body=b'<?xml version="1.0" ?>\n<llsd>\n<map>\n    <key>item_id</key>\n    <uuid></uuid>\n  </map>\n</llsd>\n', query=set()),
    CAPTemplate(cap_name='UpdateGestureTaskInventory', method='POST', body=b'<?xml version="1.0" ?>\n<llsd>\n<map>\n    <key>item_id</key>\n    <uuid><!HIPPOREPL[[SELECTED_TASK_ITEM]]></uuid>\n    <key>task_id</key>\n    <uuid><!HIPPOREPL[[SELECTED_FULL]]></uuid>\n  </map>\n</llsd>\n', query=set()),
    CAPTemplate(cap_name='MeshUploadFlag', method='GET', body=b'', query=set()),
    CAPTemplate(cap_name='UntrustedSimulatorMessage', method='POST', body=b'<?xml version="1.0" ?>\n<llsd>\n<map>\n   <key>message</key>\n    <string>ChatFromViewer</string>\n   <key>body</key>\n    <map>\n     <key>AgentData</key>\n      <array>\n        <map>\n         <key>AgentID</key>\n          <uuid><!HIPPOREPL[[AGENT_ID]]></uuid>\n         <key>SessionID</key>\n          <uuid><!HIPPOREPL[[SESSION_ID]]></uuid>\n        </map>\n      </array>\n     <key>ChatData</key>\n      <array>\n        <map>\n         <key>Channel</key>\n          <integer>0</integer>\n         <key>Message</key>\n          <string>test <!HIPPOEVAL[[\n            1 + 1\n          ]]></string>\n         <key>Type</key>\n          <integer>1</integer>\n        </map>\n      </array>\n    </map>\n  </map>\n</llsd>\n', query=set()),
    CAPTemplate(cap_name='UpdateAvatarAppearance', method='POST', body=b'<?xml version="1.0" ?>\n<llsd>\n<map>\n    <key>cof_version</key>\n    <integer></integer>\n  </map>\n</llsd>\n', query=set()),
    CAPTemplate(cap_name='ServerReleaseNotes', method='GET', body=b'', query=set()),
    CAPTemplate(cap_name='UserInfo', method='GET', body=b'', query=set()),
    CAPTemplate(cap_name='SendPostcard', method='POST', body=b'<?xml version="1.0" ?>\n<llsd>\n<map>\n    <key>msg</key>\n    <string></string>\n    <key>name</key>\n    <string></string>\n    <key>pos-global</key>\n    <array>\n      <real></real>\n      <real></real>\n      <real></real>\n    </array>\n    <key>subject</key>\n    <string></string>\n    <key>to</key>\n    <string></string>\n  </map>\n</llsd>\n', query=set()),
    CAPTemplate(cap_name='GetAdminExperiences', method='GET', body=b'', query=set()),
    CAPTemplate(cap_name='GetExperiences', method='GET', body=b'', query=set()),
    CAPTemplate(cap_name='AgentExperiences', method='GET', body=b'', query=set()),
    CAPTemplate(cap_name='ExperiencePreferences', method='GET', body=b'', query={'SOME_ID'}),
    CAPTemplate(cap_name='IsExperienceAdmin', method='GET', body=b'', query={'experience_id'}),
    CAPTemplate(cap_name='UpdateExperience', method='POST', body=b'<?xml version="1.0" ?>\n<llsd>\n<map>\n    <key>description</key>\n    <string></string>\n    <key>extended_metadata</key>\n    <string></string>\n    <key>group_id</key>\n    <uuid></uuid>\n    <key>slurl</key>\n    <string></string>\n  </map>\n</llsd>\n', query=set()),
    CAPTemplate(cap_name='AttachmentResources', method='GET', body=b'', query=set()),
    CAPTemplate(cap_name='DispatchRegionInfo', method='POST', body=b'<?xml version="1.0" ?>\n<llsd>\n<map>\n    <key>agent_limit</key>\n    <real></real>\n    <key>allow_damage</key>\n    <integer></integer>\n    <key>allow_land_resell</key>\n    <integer></integer>\n    <key>allow_parcel_changes</key>\n    <integer></integer>\n    <key>block_fly</key>\n    <integer></integer>\n    <key>block_fly_over</key>\n    <integer></integer>\n    <key>block_parcel_search</key>\n    <integer></integer>\n    <key>block_terraform</key>\n    <integer></integer>\n    <key>prim_bonus</key>\n    <real></real>\n    <key>restrict_pushobject</key>\n    <integer></integer>\n    <key>sim_access</key>\n    <string></string>\n  </map>\n</llsd>\n', query=set()),
    CAPTemplate(cap_name='AvatarPickerSearch', method='GET', body=b'', query={'names', 'page_size'}),
    CAPTemplate(cap_name='LandResources', method='POST', body=b'<?xml version="1.0" ?>\n<llsd>\n<map>\n    <key>parcel_id</key>\n    <uuid><!HIPPOREPL[[SELECTED_PARCEL_FULL]]></uuid>\n  </map>\n</llsd>\n', query=set()),
    CAPTemplate(cap_name='ResourceCostSelected', method='POST', body=b'<?xml version="1.0" ?>\n<llsd>\n<map>\n    <key>selected_roots</key>\n    <array>\n      <uuid><!HIPPOREPL[[SELECTED_FULL]]></uuid>\n    </array>\n  </map>\n</llsd>\n', query=set()),
    CAPTemplate(cap_name='GroupMemberData', method='POST', body=b'<?xml version="1.0" ?>\n<llsd>\n<map>\n    <key>group_id</key>\n    <uuid />\n  </map>\n</llsd>\n', query=set()),
    CAPTemplate(cap_name='GroupExperiences', method='GET', body=b'', query={'SOME_ID'}),
    CAPTemplate(cap_name='CopyInventoryFromNotecard', method='POST', body=b'<?xml version="1.0" ?>\n<llsd>\n<map>\n    <key>callback-id</key>\n    <integer></integer>\n    <key>folder-id</key>\n    <uuid></uuid>\n    <key>item-id</key>\n    <uuid></uuid>\n    <key>notecard-id</key>\n    <uuid></uuid>\n    <key>object-id</key>\n    <uuid />\n  </map>\n</llsd>\n', query=set()),
    CAPTemplate(cap_name='HomeLocation', method='POST', body=b'<?xml version="1.0" ?>\n<llsd>\n<map>\n    <key>HomeLocation</key>\n    <map>\n      <key>LocationId</key>\n      <integer>1</integer>\n      <key>LocationLookAt</key>\n      <map>\n        <key>X</key>\n        <real></real>\n        <key>Y</key>\n        <real></real>\n        <key>Z</key>\n        <real></real>\n      </map>\n      <key>LocationPos</key>\n      <map>\n        <key>X</key>\n        <real></real>\n        <key>Y</key>\n        <real></real>\n        <key>Z</key>\n        <real></real>\n      </map>\n    </map>\n  </map>\n</llsd>\n', query=set()),
    CAPTemplate(cap_name='CharacterProperties', method='GET', body=b'', query=set()),
    CAPTemplate(cap_name='ObjectNavMeshProperties', method='GET', body=b'', query=set()),
    CAPTemplate(cap_name='TerrainNavMeshProperties', method='GET', body=b'', query=set()),
    CAPTemplate(cap_name='ObjectNavMeshProperties', method='PUT', body=b'<?xml version="1.0" ?>\n<llsd>\n<map>\n    <key><!HIPPOREPL[[SELECTED_FULL]]></key>\n    <map>\n      <key>A</key>\n      <integer></integer>\n      <key>B</key>\n      <integer></integer>\n      <key>C</key>\n      <integer></integer>\n      <key>D</key>\n      <integer></integer>\n      <key>navmesh_category</key>\n      <integer></integer>\n      <key>phantom</key>\n      <boolean></boolean>\n    </map>\n  </map>\n</llsd>\n', query=set()),
    CAPTemplate(cap_name='RetrieveNavMeshSrc', method='POST', body=b'<?xml version="1.0" ?>\n<llsd>\n<undef />\n</llsd>\n', query=set()),
    CAPTemplate(cap_name='MapLayer', method='POST', body=b'<?xml version="1.0" ?>\n<llsd>\n<undef />\n</llsd>\n', query=set()),
    CAPTemplate(cap_name='GroupAPIv1', method='GET', body=b'', query={'group_id'}),
    CAPTemplate(cap_name='ChatSessionRequest', method='POST', body=b'<?xml version="1.0" ?>\n<llsd>\n<map>\n    <key>method</key>\n    <string></string>\n    <key>session-id</key>\n    <uuid></uuid>\n  </map>\n</llsd>\n', query=set()),
    CAPTemplate(cap_name='ViewerBenefits', method='GET', body=b'', query=set(), path=''),
    CAPTemplate(cap_name='SetDisplayName', method='POST', body=b'<?xml version="1.0" ?>\n<llsd>\n<map>\n    <key>display_name</key>\n    <array>\n      <string>OLD_DISPLAY_NAME</string>\n      <string>NEW_DISPLAY_NAME</string>\n    </array>\n  </map>\n</llsd>\n', query=set(), path=''),
    CAPTemplate(cap_name='ObjectMediaNavigate', method='POST', body=b'<?xml version="1.0" ?>\n<llsd>\n<map>\n    <key>current_url</key>\n    <string></string>\n    <key>object_id</key>\n    <uuid><!HIPPOREPL[[SELECTED_FULL]]></uuid>\n    <key>texture_index</key>\n    <integer></integer>\n  </map>\n</llsd>\n', query=set(), path=''),
]
