"""Gravity term for Kinova Gen3 robot

Functions
---------
gravity(joint_position)

"""

import math
import numpy as np


def gravity(joint_position):
    """The gravity term of the Kinova Gen3 robot

    Arguments
    ---------
    joint_position (array_like): The joint angles of the robot [rad]

    Returns
    -------
    ndarray: The gravity term of the robot

    """

    # Gravity acceleration [m/s^2]
    gravity_acceleration = 9.80665

    x_0 = math.sin(joint_position[0])
    x_1 = math.cos(joint_position[0])
    x_2 = math.sin(joint_position[1])
    x_3 = x_2**2
    x_4 = math.cos(joint_position[1])
    x_5 = math.cos(joint_position[2])
    x_6 = -4.4e-5 * x_4
    x_7 = math.sin(joint_position[2])
    x_8 = x_2 * x_7
    x_9 = x_2 * x_5
    x_10 = x_0 * x_5
    x_11 = x_1 * x_4
    x_12 = x_11 * x_7
    x_13 = x_10 + x_12
    x_14 = -x_13
    x_15 = 0.117892 * x_2
    x_16 = x_0 * x_7
    x_17 = x_1 * x_4 * x_5 - x_16
    x_18 = 0.0064 * x_4
    x_19 = math.sin(joint_position[3])
    x_20 = x_19 * x_4
    x_21 = math.cos(joint_position[3])
    x_22 = x_2 * x_21
    x_23 = 0.075478 * x_19
    x_24 = 1.8e-5 * x_5
    x_25 = 0.93 * x_13
    x_26 = x_21 * x_5
    x_27 = x_2 * x_26
    x_28 = x_1 * x_2
    x_29 = x_21 * x_28
    x_30 = x_17 * x_19
    x_31 = -x_29 - x_30
    x_32 = 0.015006 * x_21
    x_33 = x_19 * x_9
    x_34 = x_17 * x_21
    x_35 = -x_19 * x_28 + x_34
    x_36 = 0.93 * x_35
    x_37 = 1.856 * x_35
    x_38 = 0.93 * x_31
    x_39 = math.cos(joint_position[4])
    x_40 = 0.1059 * x_20
    x_41 = math.sin(joint_position[4])
    x_42 = x_41 * x_7
    x_43 = x_21 * x_39 * x_5 - x_42
    x_44 = 0.1059 * x_2
    x_45 = x_13 * x_39 + x_35 * x_41
    x_46 = -x_45
    x_47 = 1.178 * x_46
    x_48 = x_39 * x_7
    x_49 = x_26 * x_41 + x_48
    x_50 = -x_49
    x_51 = x_35 * x_39
    x_52 = -x_13 * x_41 + x_51
    x_53 = 1.178 * x_52
    x_54 = 0.009432 * x_39
    x_55 = 0.009432 * x_2
    x_56 = 1.0e-6 * x_2
    x_57 = 0.678 * x_31
    x_58 = 1.0e-6 * x_21
    x_59 = x_19 * x_5
    x_60 = 0.063883 * x_2
    x_61 = 0.678 * x_46
    x_62 = 0.678 * x_52
    x_63 = math.sin(joint_position[5])
    x_64 = x_21 * x_63
    x_65 = math.cos(joint_position[5])
    x_66 = x_19 * x_65
    x_67 = x_39 * x_66
    x_68 = x_4 * (x_64 + x_67)
    x_69 = x_19 * x_63
    x_70 = x_21 * x_39 * x_65 - x_69
    x_71 = -x_42 * x_65 + x_5 * x_70
    x_72 = 0.5 * x_45
    x_73 = x_31 * x_63
    x_74 = x_52 * x_65
    x_75 = x_73 + x_74
    x_76 = 0.5 * x_75
    x_77 = x_39 * x_69
    x_78 = x_21 * x_65 - x_77
    x_79 = x_4 * x_78
    x_80 = -x_39 * x_64 - x_66
    x_81 = x_42 * x_63 + x_5 * x_80
    x_82 = x_2 * x_81
    x_83 = 0.678 * x_45
    x_84 = x_31 * x_65 - x_52 * x_63
    x_85 = 0.678 * x_84
    x_86 = 0.678 * x_75
    x_87 = math.cos(joint_position[6])
    x_88 = x_64 * x_87
    x_89 = math.sin(joint_position[6])
    x_90 = x_41 * x_89
    x_91 = x_39 * x_65 * x_87 - x_90
    x_92 = x_19 * x_91
    x_93 = x_88 + x_92
    x_94 = x_64 * x_89
    x_95 = x_41 * x_87
    x_96 = x_39 * x_89
    x_97 = -x_65 * x_96 - x_95
    x_98 = x_19 * x_97
    x_99 = -x_94 + x_98
    x_100 = x_65 * x_95
    x_101 = x_100 + x_96
    x_102 = x_21 * x_91 - x_69 * x_87
    x_103 = -x_101 * x_7 + x_102 * x_5
    x_104 = x_65 * x_90
    x_105 = -x_104 + x_39 * x_87
    x_106 = x_21 * x_97 + x_69 * x_89
    x_107 = -x_105 * x_7 + x_106 * x_5
    x_108 = 0.5 * x_84
    x_109 = x_45 * x_87
    x_110 = x_75 * x_89
    x_111 = -x_109 - x_110
    x_112 = 0.5 * x_111
    x_113 = x_75 * x_87
    x_114 = x_113 - x_45 * x_89
    x_115 = 0.5 * x_114
    x_116 = x_21 * x_7
    x_117 = x_19 * x_7
    x_118 = 0.009432 * x_41
    x_119 = 1.0e-6 * x_39
    x_120 = x_42 * x_58
    x_121 = 0.009432 * x_21
    x_122 = 0.1059 * x_21
    x_123 = -x_122 * x_42 + 0.1059 * x_39 * x_5
    x_124 = 0.1059 * x_41 * x_5
    x_125 = 0.063883 * x_5
    x_126 = x_21 * x_42
    x_127 = x_7 * x_70
    x_128 = x_41 * x_63
    x_129 = 1.0e-6 * x_128
    x_130 = x_41 * x_65
    x_131 = x_7 * x_80
    x_132 = 0.00965 * x_130
    x_133 = 0.045483 * x_39
    x_134 = 0.00965 * x_128
    x_135 = x_101 * x_5
    x_136 = x_105 * x_5
    x_137 = 0.011402 * x_7
    x_138 = x_106 * x_7
    x_139 = 0.000281 * x_128
    x_140 = 0.011402 * x_128
    x_141 = x_19 * x_41
    x_142 = 1.0e-6 * x_141
    x_143 = 0.063883 * x_19
    x_144 = x_21 * x_65
    x_145 = 0.05295 * x_75
    x_146 = x_39 * x_87
    x_147 = 0.000281 * x_65
    x_148 = 0.011402 * x_65
    x_149 = 0.029798 * x_63

    return np.array(
        [
            
                gravity_acceleration
                * (
                    0.83099584 * x_0 * x_2
                    - 1.1636 * x_0 * (-0.09958 * x_2 - x_6)
                    - 3.1671e-5 * x_0
                    + 1.1636 * x_1 * x_2 * (-4.4e-5 * x_8 - 0.006641 * x_9)
                    + 0.0178304 * x_1 * x_3 * x_5
                    + 0.0407277208 * x_1 * x_3
                    + 0.0407277208 * x_1 * x_4**2
                    + 0.013340052 * x_1
                    - x_108
                    * (
                        -0.011402 * x_103 * x_2
                        + 0.000281 * x_107 * x_2
                        - 0.011402 * x_4 * x_93
                        + 0.000281 * x_4 * x_99
                    )
                    - x_112
                    * (
                        0.029798 * x_103 * x_2
                        + 0.029798 * x_4 * x_93
                        - 0.000281 * x_79
                        - 0.000281 * x_82
                    )
                    - x_115
                    * (
                        -0.029798 * x_107 * x_2
                        + 0.011402 * x_2 * x_81
                        + 0.011402 * x_4 * x_78
                        - 0.029798 * x_4 * x_99
                    )
                    - 1.856 * x_13 * (-0.2084 * x_20 - 0.2084 * x_22 * x_5)
                    - 0.5861744 * x_14 * x_9
                    - 1.1636 * x_14 * (x_15 * x_5 + x_6)
                    - 2.786 * x_17 * (-x_18 + 0.2104 * x_8)
                    - 1.1636 * x_17 * (x_15 * x_7 + 0.006641 * x_4)
                    - x_25
                    * (
                        -x_19 * x_2 * x_24
                        + 1.8e-5 * x_21 * x_4
                        - 0.075478 * x_22 * x_5
                        - x_23 * x_4
                    )
                    - 1.856 * x_31 * (x_18 * x_19 + 0.0064 * x_27)
                    - x_36 * (-x_32 * x_4 + 0.015006 * x_33 + 0.075478 * x_8)
                    - x_37 * (-x_18 * x_21 + 0.0064 * x_33 + 0.2084 * x_8)
                    - x_38 * (0.015006 * x_20 + 0.015006 * x_27 - 1.8e-5 * x_8)
                    - x_47 * (x_39 * x_40 + x_43 * x_44)
                    - x_53 * (0.1059 * x_19 * x_4 * x_41 - x_44 * x_50)
                    - x_57
                    * (
                        1.0e-6 * x_19 * x_4 * x_41
                        - x_20 * x_54
                        - x_43 * x_55
                        - x_50 * x_56
                    )
                    - x_61
                    * (0.063883 * x_20 * x_39 + x_4 * x_58 + x_43 * x_60 - x_56 * x_59)
                    - x_62
                    * (
                        0.063883 * x_19 * x_4 * x_41
                        + 0.009432 * x_21 * x_4
                        - x_50 * x_60
                        - x_55 * x_59
                    )
                    - x_72 * (-x_44 * x_71 - 0.1059 * x_68)
                    - x_76 * (x_40 * x_41 + x_44 * x_49)
                    - x_83
                    * (
                        -0.045483 * x_2 * x_71
                        - 0.045483 * x_68
                        - 1.0e-6 * x_79
                        - 1.0e-6 * x_82
                    )
                    - x_85
                    * (
                        0.00965 * x_2 * x_71
                        + 1.0e-6 * x_20 * x_41
                        + x_49 * x_56
                        + 0.00965 * x_68
                    )
                    - x_86
                    * (
                        0.045483 * x_19 * x_4 * x_41
                        + 0.045483 * x_2 * x_49
                        - 0.00965 * x_79
                        - 0.00965 * x_82
                    )
                )
            ,
            
                gravity_acceleration
                * (
                    1.1636 * x_1 * x_2 * (-4.4e-5 * x_5 + 0.006641 * x_7)
                    - x_108
                    * (
                        x_102 * x_137
                        + 0.011402 * x_135
                        - 0.000281 * x_136
                        - 0.000281 * x_138
                    )
                    - 0.946867128 * x_11
                    - x_112
                    * (
                        -0.029798 * x_102 * x_7
                        - 0.029798 * x_135
                        - x_139 * x_5
                        + 0.000281 * x_7 * x_80
                    )
                    - x_115
                    * (0.029798 * x_136 - x_137 * x_80 + 0.029798 * x_138 + x_140 * x_5)
                    - 0.3867904 * x_116 * x_13
                    - x_123 * x_53
                    - x_123 * x_76
                    + 0.7233535312 * x_14 * x_7
                    - 0.7233535312 * x_17 * x_5
                    + 0.0118784 * x_21 * x_31 * x_7
                    - x_25 * (0.075478 * x_116 + 1.8e-5 * x_117)
                    - 0.0178304 * x_28 * x_7
                    - 5.11984e-5 * x_28
                    - x_36 * (-0.015006 * x_117 + 0.075478 * x_5)
                    - x_37 * (-0.0064 * x_117 + 0.2084 * x_5)
                    - x_38 * (-x_24 - x_32 * x_7)
                    - x_47 * (-x_122 * x_48 - x_124)
                    - x_57 * (x_118 * x_5 + x_119 * x_5 - x_120 + x_121 * x_48)
                    - x_61
                    * (-x_125 * x_41 + 1.0e-6 * x_19 * x_7 - 0.063883 * x_21 * x_48)
                    - x_62 * (0.009432 * x_117 + x_125 * x_39 - 0.063883 * x_126)
                    - x_72 * (x_124 * x_65 + 0.1059 * x_127)
                    - x_83
                    * (
                        0.045483 * x_127
                        - x_129 * x_5
                        + 0.045483 * x_130 * x_5
                        + 1.0e-6 * x_131
                    )
                    - x_85
                    * (-x_120 - 0.00965 * x_127 - x_132 * x_5 + 1.0e-6 * x_39 * x_5)
                    - x_86
                    * (-0.045483 * x_126 + 0.00965 * x_131 + x_133 * x_5 - x_134 * x_5)
                )
            ,
            
                gravity_acceleration
                * (
                    0.0101029324 * x_1 * x_4 * x_5
                    - 5.11984e-5 * x_10
                    - x_108
                    * (
                        0.000281 * x_19 * x_97
                        - 0.011402 * x_88
                        - 0.011402 * x_92
                        - 0.000281 * x_94
                    )
                    - x_112
                    * (
                        -0.000281 * x_144
                        + 0.000281 * x_77
                        + 0.029798 * x_88
                        + 0.029798 * x_92
                    )
                    - x_115
                    * (
                        0.029798 * x_21 * x_63 * x_89
                        + 0.011402 * x_21 * x_65
                        - 0.011402 * x_77
                        - 0.029798 * x_98
                    )
                    - 5.11984e-5 * x_12
                    + 0.3867904 * x_13 * x_19
                    - x_141 * x_145
                    - 0.1247502 * x_141 * x_52
                    - 0.0101029324 * x_16
                    - 0.02583398 * x_19 * x_31
                    - 0.1247502 * x_19 * x_39 * x_46
                    + 0.02583398 * x_21 * x_35
                    - x_25 * (1.8e-5 * x_21 - x_23)
                    - x_57 * (x_142 - x_19 * x_54)
                    - x_61 * (x_143 * x_39 + x_58)
                    - x_62 * (x_121 + x_143 * x_41)
                    - x_72 * (-0.1059 * x_64 - 0.1059 * x_67)
                    - x_83
                    * (
                        -x_133 * x_66
                        - 1.0e-6 * x_144
                        + 1.0e-6 * x_19 * x_39 * x_63
                        - 0.045483 * x_64
                    )
                    - x_85 * (x_142 + 0.00965 * x_64 + 0.00965 * x_67)
                    - x_86 * (0.045483 * x_141 - 0.00965 * x_144 + 0.00965 * x_77)
                )
            ,
            
                gravity_acceleration
                * (
                    0.45698494 * x_1 * x_19 * x_2
                    - x_108
                    * (
                        -0.000281 * x_146
                        + x_147 * x_90
                        + x_148 * x_95
                        + 0.011402 * x_96
                    )
                    - x_112 * (-0.029798 * x_100 - x_139 - 0.029798 * x_96)
                    - x_115 * (-0.029798 * x_104 + x_140 + 0.029798 * x_146)
                    - 0.05295 * x_130 * x_45
                    - x_145 * x_39
                    - 1.674e-5 * x_29
                    - 1.674e-5 * x_30
                    - 0.45698494 * x_34
                    - 0.168062874 * x_39 * x_52
                    + 0.168062874 * x_41 * x_46
                    - x_57 * (x_118 + x_119)
                    - x_83 * (-x_129 + 0.045483 * x_41 * x_65)
                    - x_85 * (-x_132 + 1.0e-6 * x_39)
                    - x_86 * (-x_134 + 0.045483 * x_39)
                )
            ,
            
                gravity_acceleration
                * (
                    -x_108 * (-0.011402 * x_63 * x_87 - 0.000281 * x_63 * x_89)
                    - x_112 * (-x_147 + x_149 * x_87)
                    - x_115 * (x_148 + x_149 * x_89)
                    + 6.78e-7 * x_13 * x_39
                    + 0.006394896 * x_13 * x_41
                    + 6.78e-7 * x_35 * x_41
                    + 0.05295 * x_45 * x_63
                    - 0.006394896 * x_51
                    - 0.0065427 * x_63 * x_84
                    + 0.0065427 * x_65 * x_75
                    - x_83 * (-0.045483 * x_63 - 1.0e-6 * x_65)
                )
            ,
            
                gravity_acceleration
                * (
                    -x_108 * (-0.000281 * x_87 + 0.011402 * x_89)
                    + 0.014899 * x_111 * x_89
                    - 0.014899 * x_114 * x_87
                    - 6.78e-7 * x_31 * x_65
                    + 6.78e-7 * x_52 * x_63
                    - 0.083787474 * x_73
                    - 0.083787474 * x_74
                )
            ,
            
                gravity_acceleration
                * (
                    -0.0001405 * x_109
                    - 0.0001405 * x_110
                    - 0.005701 * x_113
                    + 0.005701 * x_45 * x_89
                )
            ,
        ]
    )
